/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.item.debug;

import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ComplexMobTerrestrial;
import untamedwilds.entity.ISpecies;
import untamedwilds.util.TimeUtils;

public class AnalyzerItem
extends Item {
    public AnalyzerItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity playerIn, LivingEntity target, Hand hand) {
        World world = target.func_130014_f_();
        if (world.field_72995_K) {
            return ActionResultType.PASS;
        }
        if (target instanceof ComplexMob) {
            ComplexMob entity = (ComplexMob)target;
            String entityName = entity instanceof ISpecies ? ((ISpecies)((Object)entity)).getSpeciesName() : entity.func_200200_C_().getString();
            playerIn.func_145747_a((ITextComponent)new StringTextComponent("Diagnose: " + ((Boolean)ConfigGamerules.genderedBreeding.get() != false ? entity.getGenderString() + " " : "") + entityName + " (Skin: " + entity.getSkin() + ") (Eco Level: " + ComplexMob.getEcoLevel((LivingEntity)entity) + ") " + entity.func_110143_aJ() + "/" + entity.func_110138_aP() + " HP"), playerIn.func_110124_au());
            if (((Boolean)ConfigGamerules.scientificNames.get()).booleanValue()) {
                String useVarName = entity instanceof ISpecies ? "_" + ((ISpecies)((Object)entity)).getRawSpeciesName(entity.getVariant()) : "";
                playerIn.func_145747_a((ITextComponent)new TranslationTextComponent(entity.func_200600_R().func_210760_d() + useVarName + ".sciname").func_240699_a_(TextFormatting.ITALIC), playerIn.func_110124_au());
            }
            if (target instanceof ComplexMobTerrestrial) {
                playerIn.func_145747_a((ITextComponent)new StringTextComponent("Hunger: " + ((ComplexMobTerrestrial)entity).getHunger() + "/100 Hunger"), playerIn.func_110124_au());
            }
            if (!entity.isMale() && entity.func_70874_b() > 0 && !((Boolean)ConfigGamerules.easyBreeding.get()).booleanValue()) {
                playerIn.func_145747_a((ITextComponent)new StringTextComponent("This female will give birth in " + TimeUtils.convertTicksToDays(world, entity.func_70874_b()) + " (" + entity.func_70874_b() + " ticks)"), playerIn.func_110124_au());
            }
            if (entity.wantsToBreed()) {
                playerIn.func_145747_a((ITextComponent)new StringTextComponent("This mob is looking for a suitable mate"), playerIn.func_110124_au());
            }
            if (entity.func_70631_g_()) {
                playerIn.func_145747_a((ITextComponent)new StringTextComponent("This mob will grow up in " + TimeUtils.convertTicksToDays(world, entity.func_70874_b() * -1) + " (" + entity.func_70874_b() * -1 + " ticks)"), playerIn.func_110124_au());
            }
            return ActionResultType.SUCCESS;
        }
        playerIn.func_145747_a((ITextComponent)new StringTextComponent("Diagnose: " + target.func_200200_C_().getString() + " " + target.func_110143_aJ() + "/" + target.func_110138_aP() + " HP (Eco Level: " + ComplexMob.getEcoLevel(target) + ")"), playerIn.func_110124_au());
        if (target.func_70631_g_() && target instanceof AgeableEntity) {
            AgeableEntity entity = (AgeableEntity)target;
            playerIn.func_145747_a((ITextComponent)new StringTextComponent("This mob will grow up in " + TimeUtils.convertTicksToDays(world, entity.func_70874_b() * -1) + " (" + entity.func_70874_b() * -1 + " ticks)"), playerIn.func_110124_au());
        }
        return ActionResultType.SUCCESS;
    }
}

