/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.item;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.INeedsPostUpdate;
import untamedwilds.util.EntityUtils;
import untamedwilds.util.ItemGroupUT;

public class MobEggItem
extends Item {
    private final EntityType<? extends ComplexMob> entity;

    public MobEggItem(EntityType<? extends ComplexMob> typeIn, Item.Properties properties) {
        super(properties);
        this.entity = typeIn;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("mobspawn.tooltip.unknown").func_240699_a_(TextFormatting.GRAY));
    }

    public ActionResultType func_195939_a(ItemUseContext useContext) {
        World worldIn = useContext.func_195991_k();
        if (!(worldIn instanceof ServerWorld)) {
            return ActionResultType.SUCCESS;
        }
        ItemStack itemStack = useContext.func_195996_i();
        BlockPos pos = useContext.func_195995_a();
        Direction facing = useContext.func_196000_l();
        BlockState blockState = worldIn.func_180495_p(pos);
        BlockPos spawnPos = blockState.func_196952_d((IBlockReader)worldIn, pos).func_197766_b() ? pos : pos.func_177972_a(facing);
        EntityType<?> entity = EntityUtils.getEntityTypeFromTag(itemStack.func_77978_p(), this.entity);
        Entity spawn = entity.func_220349_b((ServerWorld)worldIn, itemStack.func_77978_p(), null, useContext.func_195999_j(), spawnPos, SpawnReason.BUCKET, true, !Objects.equals(pos, spawnPos) && facing == Direction.UP);
        if (spawn instanceof ComplexMob) {
            ComplexMob entitySpawn = (ComplexMob)spawn;
            entitySpawn.setVariant(this.getSpecies(itemStack, entitySpawn));
            entitySpawn.chooseSkinForSpecies(entitySpawn, true);
            entitySpawn.setRandomMobSize();
            entitySpawn.setGender(entitySpawn.func_70681_au().nextInt(2));
            entitySpawn.func_70873_a(entitySpawn.getAdulthoodTime() * -1);
            if (spawn instanceof INeedsPostUpdate) {
                ((INeedsPostUpdate)spawn).updateAttributes();
            }
        }
        if (spawn != null) {
            worldIn.func_217376_c(spawn);
        }
        itemStack.func_190918_g(1);
        return ActionResultType.CONSUME;
    }

    public String func_77658_a() {
        return new TranslationTextComponent("item.untamedwilds.egg_" + this.entity.getRegistryName().func_110623_a()).getString();
    }

    private int getSpecies(ItemStack itemIn, ComplexMob entityIn) {
        if (itemIn.func_77978_p() != null && itemIn.func_77978_p().func_74764_b("variant")) {
            return itemIn.func_77978_p().func_74762_e("variant");
        }
        return entityIn.getVariant();
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (group == ItemGroupUT.untamedwilds_items) {
            int j = EntityUtils.getNumberOfSpecies(this.entity);
            for (int i = 0; i < EntityUtils.getNumberOfSpecies(this.entity); ++i) {
                CompoundNBT baseTag = new CompoundNBT();
                ItemStack item = new ItemStack((IItemProvider)this);
                baseTag.func_74768_a("variant", i);
                baseTag.func_74768_a("CustomModelData", i);
                item.func_77982_d(baseTag);
                items.add((Object)item);
            }
        }
    }
}

