/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import untamedwilds.UntamedWilds;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.INeedsPostUpdate;
import untamedwilds.util.EntityUtils;
import untamedwilds.util.ItemGroupUT;

public class MobBucketedItem
extends BucketItem {
    private final EntityType<? extends ComplexMob> entity;

    public MobBucketedItem(EntityType<? extends ComplexMob> typeIn, Fluid fluid, Item.Properties builder) {
        super(() -> fluid, builder);
        this.entity = typeIn;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (ComplexMob.ENTITY_DATA_HASH.containsKey(this.entity)) {
            EntityUtils.buildTooltipData(stack, tooltip, this.entity, EntityUtils.getVariantName(this.entity, this.getSpecies(stack)));
        }
    }

    public String func_77667_c(ItemStack stack) {
        if (ComplexMob.ENTITY_DATA_HASH.containsKey(this.entity)) {
            return new TranslationTextComponent("item.untamedwilds.bucket_" + this.entity.getRegistryName().func_110623_a()).getString() + "_" + EntityUtils.getVariantName(this.entity, this.getSpecies(stack));
        }
        return super.func_77667_c(stack);
    }

    public void func_203792_a(World worldIn, ItemStack itemStack, BlockPos pos) {
        if (worldIn instanceof ServerWorld) {
            EntityType<?> entity = EntityUtils.getEntityTypeFromTag(itemStack.func_77978_p(), this.entity);
            if (itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74764_b("EntityTag")) {
                EntityUtils.createMobFromItem((ServerWorld)worldIn, itemStack, entity, 0, pos, null, false);
            } else {
                Entity spawn = entity.func_220349_b((ServerWorld)worldIn, itemStack.func_77978_p(), null, null, pos, SpawnReason.BUCKET, true, false);
                if (spawn instanceof ComplexMob) {
                    ComplexMob entitySpawn = (ComplexMob)spawn;
                    entitySpawn.setVariant(this.getSpecies(itemStack));
                    entitySpawn.chooseSkinForSpecies(entitySpawn, true);
                    entitySpawn.setRandomMobSize();
                    entitySpawn.setGender(entitySpawn.func_70681_au().nextInt(2));
                    if (spawn instanceof INeedsPostUpdate) {
                        ((INeedsPostUpdate)spawn).updateAttributes();
                    }
                    worldIn.func_217376_c(spawn);
                }
            }
        }
    }

    protected void func_203791_b(@Nullable PlayerEntity player, IWorld worldIn, BlockPos pos) {
        worldIn.func_184133_a(player, pos, SoundEvents.field_203819_X, SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }

    private int getSpecies(ItemStack itemIn) {
        if (itemIn.func_77978_p() != null && itemIn.func_77978_p().func_74764_b("CustomModelData")) {
            return itemIn.func_77978_p().func_74762_e("CustomModelData");
        }
        UntamedWilds.LOGGER.error("No variant found in this itemstack NBT data");
        return 0;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (group == ItemGroupUT.untamedwilds_items) {
            for (int i = 0; i < EntityUtils.getNumberOfSpecies(this.entity); ++i) {
                CompoundNBT baseTag = new CompoundNBT();
                ItemStack item = new ItemStack((IItemProvider)this);
                baseTag.func_74768_a("variant", i);
                baseTag.func_74768_a("CustomModelData", i);
                item.func_77982_d(baseTag);
                items.add((Object)item);
            }
        }
    }
}

