/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.init;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import untamedwilds.block.AlgaeBlock;
import untamedwilds.block.AnemoneBlock;
import untamedwilds.block.CageBlock;
import untamedwilds.block.CarpetBlock;
import untamedwilds.block.CritterBurrowBlock;
import untamedwilds.block.EpyphitePlantBlock;
import untamedwilds.block.FloatingPlantBlock;
import untamedwilds.block.LardBlock;
import untamedwilds.block.ReedBlock;
import untamedwilds.block.TallPlantBlock;
import untamedwilds.block.TitanArumBlock;
import untamedwilds.block.UndergrowthBlock;
import untamedwilds.block.UndergrowthPoisonousBlock;
import untamedwilds.block.blockentity.CageBlockEntity;
import untamedwilds.block.blockentity.CritterBurrowBlockEntity;
import untamedwilds.init.ModItems;

@Mod.EventBusSubscriber(modid="untamedwilds", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModBlock {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"untamedwilds");
    public static final DeferredRegister<TileEntityType<?>> TILE_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"untamedwilds");
    private static final List<Pair<RegistryObject<Block>, String>> RENDER_TYPE_DATA = Lists.newArrayList();
    public static RegistryObject<Block> CARPET_STRAW = ModBlock.createBlock("carpet_straw", () -> new CarpetBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151593_r, (MaterialColor)MaterialColor.field_151673_t).func_200943_b(0.1f).func_200947_a(SoundType.field_185850_c)), ItemGroup.field_78031_c);
    public static RegistryObject<Block> CARPET_BEAR_ASHEN = ModBlock.createBlock("carpet_bear_ashen", () -> new CarpetBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151593_r, (MaterialColor)MaterialColor.field_151670_w).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)), ItemGroup.field_78031_c);
    public static RegistryObject<Block> CARPET_BEAR_BLACK = ModBlock.createBlock("carpet_bear_black", () -> new CarpetBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151593_r, (MaterialColor)MaterialColor.field_151646_E).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)), ItemGroup.field_78031_c);
    public static RegistryObject<Block> CARPET_BEAR_BROWN = ModBlock.createBlock("carpet_bear_brown", () -> new CarpetBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151593_r, (MaterialColor)MaterialColor.field_151650_B).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)), ItemGroup.field_78031_c);
    public static RegistryObject<Block> CARPET_BEAR_WHITE = ModBlock.createBlock("carpet_bear_white", () -> new CarpetBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151593_r, (MaterialColor)MaterialColor.field_151666_j).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)), ItemGroup.field_78031_c);
    public static RegistryObject<Block> CARPET_BIGCAT_JAGUAR = ModBlock.createBlock("carpet_bigcat_jaguar", () -> new CarpetBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151593_r, (MaterialColor)MaterialColor.field_151647_F).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)), ItemGroup.field_78031_c);
    public static RegistryObject<Block> CARPET_BIGCAT_LEOPARD = ModBlock.createBlock("carpet_bigcat_leopard", () -> new CarpetBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151593_r, (MaterialColor)MaterialColor.field_151647_F).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)), ItemGroup.field_78031_c);
    public static RegistryObject<Block> CARPET_BIGCAT_LION = ModBlock.createBlock("carpet_bigcat_lion", () -> new CarpetBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151593_r, (MaterialColor)MaterialColor.field_151650_B).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)), ItemGroup.field_78031_c);
    public static RegistryObject<Block> CARPET_BIGCAT_PANTHER = ModBlock.createBlock("carpet_bigcat_panther", () -> new CarpetBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151593_r, (MaterialColor)MaterialColor.field_151666_j).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)), ItemGroup.field_78031_c);
    public static RegistryObject<Block> CARPET_BIGCAT_PUMA = ModBlock.createBlock("carpet_bigcat_puma", () -> new CarpetBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151593_r, (MaterialColor)MaterialColor.field_151670_w).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)), ItemGroup.field_78031_c);
    public static RegistryObject<Block> CARPET_BIGCAT_SNOW = ModBlock.createBlock("carpet_bigcat_snow_leopard", () -> new CarpetBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151593_r, (MaterialColor)MaterialColor.field_151646_E).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)), ItemGroup.field_78031_c);
    public static RegistryObject<Block> CARPET_BIGCAT_TIGER = ModBlock.createBlock("carpet_bigcat_tiger", () -> new CarpetBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151593_r, (MaterialColor)MaterialColor.field_151650_B).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)), ItemGroup.field_78031_c);
    public static RegistryObject<Block> LARD_BLOCK = ModBlock.createBlock("block_lard", () -> new LardBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151571_B, (MaterialColor)MaterialColor.field_151673_t).func_200943_b(0.1f).func_200947_a(SoundType.field_185859_l)), ItemGroup.field_78030_b);
    public static RegistryObject<Block> PEARL_BLOCK = ModBlock.createBlock("block_pearl", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151679_y).func_200948_a(5.0f, 6.0f).func_200947_a(SoundType.field_185851_d)), ItemGroup.field_78030_b);
    public static RegistryObject<Block> TRAP_CAGE = ModBlock.createBlock("trap_cage", () -> new CageBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151663_o).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a)), ItemGroup.field_78029_e);
    public static RegistryObject<Block> ANEMONE_ROSE_BULB = ModBlock.createBlock("anemone_rose_bulb", () -> new AnemoneBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_203243_f, (MaterialColor)MaterialColor.field_151645_D).func_200943_b(0.1f).func_200947_a(SoundType.field_185859_l)), "cutout", ItemGroup.field_78031_c);
    public static RegistryObject<Block> ANEMONE_SAND = ModBlock.createBlock("anemone_sand", () -> new AnemoneBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_203243_f, (MaterialColor)MaterialColor.field_151671_v).func_200943_b(0.1f).func_200947_a(SoundType.field_185859_l)), "cutout", ItemGroup.field_78031_c);
    public static RegistryObject<Block> ANEMONE_SEBAE = ModBlock.createBlock("anemone_sebae", () -> new AnemoneBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_203243_f, (MaterialColor)MaterialColor.field_193561_M).func_200943_b(0.1f).func_200947_a(SoundType.field_185859_l)), "cutout", ItemGroup.field_78031_c);
    public static RegistryObject<Block> COMMON_REED = ModBlock.createBlock("flora_common_reed", () -> new ReedBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151585_k, (MaterialColor)MaterialColor.field_151651_C).func_200943_b(0.1f).func_200947_a(SoundType.field_235601_w_).func_200942_a()), "cutout", ItemGroup.field_78031_c, 100);
    public static RegistryObject<Block> BUSH_TEMPERATE = ModBlock.createBlock("flora_bush_temperate", () -> new UndergrowthBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151585_k, (MaterialColor)MaterialColor.field_151651_C).func_200943_b(1.0f).func_200947_a(SoundType.field_211382_m).func_200942_a()), "cutout", ItemGroup.field_78031_c);
    public static RegistryObject<Block> ELEPHANT_EAR = ModBlock.createBlock("flora_elephant_ear", () -> new UndergrowthBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151585_k, (MaterialColor)MaterialColor.field_151651_C).func_200943_b(1.0f).func_200947_a(SoundType.field_211382_m).func_200942_a(), AbstractBlock.OffsetType.XYZ), "cutout", ItemGroup.field_78031_c);
    public static RegistryObject<Block> HEMLOCK = ModBlock.createBlock("flora_hemlock", () -> new UndergrowthPoisonousBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151585_k, (MaterialColor)MaterialColor.field_151651_C).func_200943_b(1.0f).func_200947_a(SoundType.field_211382_m).func_200942_a(), AbstractBlock.OffsetType.XYZ), "cutout", ItemGroup.field_78031_c);
    public static RegistryObject<Block> ZIMBABWE_ALOE = ModBlock.createItemlessBlock("flora_zimbabwe_aloe", () -> new TallPlantBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151585_k, (MaterialColor)MaterialColor.field_151651_C).func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)), "cutout");
    public static RegistryObject<Block> WATER_HYACINTH = ModBlock.createItemlessBlock("flora_water_hyacinth", () -> new FloatingPlantBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151585_k, (MaterialColor)MaterialColor.field_151651_C).func_200943_b(0.0f).func_200947_a(SoundType.field_185850_c).func_200942_a()), "cutout");
    public static RegistryObject<Block> AMAZON_SWORD = ModBlock.createBlock("flora_amazon_sword", () -> new AlgaeBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151585_k, (MaterialColor)MaterialColor.field_151651_C).func_200943_b(0.0f).func_200947_a(SoundType.field_211382_m).func_200942_a()), "cutout", ItemGroup.field_78031_c);
    public static RegistryObject<Block> EELGRASS = ModBlock.createBlock("flora_eelgrass", () -> new AlgaeBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151585_k, (MaterialColor)MaterialColor.field_151651_C).func_200943_b(0.0f).func_200947_a(SoundType.field_211382_m).func_200942_a()), "cutout", ItemGroup.field_78031_c);
    public static RegistryObject<Block> ORCHID_MAGENTA = ModBlock.createBlock("flora_orchid_magenta", () -> new EpyphitePlantBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151585_k, (MaterialColor)MaterialColor.field_151675_r).func_200943_b(0.0f).func_200947_a(SoundType.field_185850_c)), "cutout", ItemGroup.field_78031_c);
    public static RegistryObject<Block> ORCHID_PURPLE = ModBlock.createBlock("flora_orchid_purple", () -> new EpyphitePlantBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151585_k, (MaterialColor)MaterialColor.field_151678_z).func_200943_b(0.0f).func_200947_a(SoundType.field_185850_c)), "cutout", ItemGroup.field_78031_c);
    public static RegistryObject<Block> ORCHID_PINK = ModBlock.createBlock("flora_orchid_pink", () -> new EpyphitePlantBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151585_k, (MaterialColor)MaterialColor.field_151671_v).func_200943_b(0.0f).func_200947_a(SoundType.field_185850_c)), "cutout", ItemGroup.field_78031_c);
    public static RegistryObject<Block> ORCHID_RED = ModBlock.createBlock("flora_orchid_red", () -> new EpyphitePlantBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151585_k, (MaterialColor)MaterialColor.field_151645_D).func_200943_b(0.0f).func_200947_a(SoundType.field_185850_c)), "cutout", ItemGroup.field_78031_c);
    public static RegistryObject<Block> TITAN_ARUM = ModBlock.createItemlessBlock("flora_titan_arum", () -> new TitanArumBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151585_k, (MaterialColor)MaterialColor.field_151651_C).func_200943_b(2.0f).func_200947_a(SoundType.field_211382_m).func_200942_a()), "cutout");
    public static RegistryObject<Block> BURROW = ModBlock.createBlock("block_burrow", () -> new CritterBurrowBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151578_c, (MaterialColor)MaterialColor.field_151664_l).func_200943_b(1.0f).func_200947_a(SoundType.field_185849_b).func_200942_a()), "translucent", ItemGroup.field_78031_c);
    public static RegistryObject<TileEntityType<CageBlockEntity>> TILE_ENTITY_CAGE = TILE_ENTITIES.register("trap_cage", () -> new TileEntityType(CageBlockEntity::new, (Set)Sets.newHashSet((Object[])new Block[]{(Block)TRAP_CAGE.get()}), null));
    public static RegistryObject<TileEntityType<CritterBurrowBlockEntity>> TILE_ENTITY_BURROW = TILE_ENTITIES.register("critter_burrow", () -> new TileEntityType(CritterBurrowBlockEntity::new, (Set)Sets.newHashSet((Object[])new Block[]{(Block)BURROW.get()}), null));

    public static <B extends Block> RegistryObject<Block> createBlock(String name, Supplier<? extends B> supplier, ItemGroup group) {
        return ModBlock.createBlock(name, supplier, null, group, 0);
    }

    public static <B extends Block> RegistryObject<Block> createBlock(String name, Supplier<? extends B> supplier, @Nullable String renderType, ItemGroup group) {
        return ModBlock.createBlock(name, supplier, renderType, group, 0);
    }

    public static <B extends Block> RegistryObject<Block> createBlock(String name, Supplier<? extends B> supplier, @Nullable String renderType, ItemGroup group, final int burnTime) {
        RegistryObject block = BLOCKS.register(name, supplier);
        if (renderType != null) {
            RENDER_TYPE_DATA.add((Pair<RegistryObject<Block>, String>)new Pair((Object)block, (Object)renderType));
        }
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(group)){

            public int getBurnTime(ItemStack itemStack) {
                return burnTime;
            }
        });
        return block;
    }

    public static <B extends Block> RegistryObject<Block> createItemlessBlock(String name, Supplier<? extends B> supplier) {
        return ModBlock.createItemlessBlock(name, supplier, null);
    }

    public static <B extends Block> RegistryObject<Block> createItemlessBlock(String name, Supplier<? extends B> supplier, @Nullable String renderType) {
        RegistryObject block = BLOCKS.register(name, supplier);
        if (renderType != null) {
            RENDER_TYPE_DATA.add((Pair<RegistryObject<Block>, String>)new Pair((Object)block, (Object)renderType));
        }
        return block;
    }

    public static void registerRendering() {
        for (Pair<RegistryObject<Block>, String> i : RENDER_TYPE_DATA) {
            RenderType j = RenderType.func_228643_e_();
            if (Objects.equals(i.getSecond(), "cutout")) {
                j = RenderType.func_228643_e_();
            } else if (Objects.equals(i.getSecond(), "translucent")) {
                j = RenderType.func_228645_f_();
            }
            RenderTypeLookup.setRenderLayer((Block)((Block)((RegistryObject)i.getFirst()).get()), (RenderType)j);
        }
    }
}

