/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.reptile;

import com.github.alexthe666.citadel.animation.Animation;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import untamedwilds.entity.ComplexMobTerrestrial;
import untamedwilds.entity.INeedsPostUpdate;
import untamedwilds.entity.INewSkins;
import untamedwilds.entity.ISpecies;
import untamedwilds.entity.ai.SmartAvoidGoal;
import untamedwilds.entity.ai.SmartMateGoal;
import untamedwilds.entity.ai.SmartSwimGoal;
import untamedwilds.entity.ai.SmartWanderGoal;
import untamedwilds.entity.ai.target.DontThreadOnMeTarget;
import untamedwilds.entity.ai.target.HuntMobTarget;
import untamedwilds.init.ModItems;
import untamedwilds.util.EntityUtils;

public class EntitySnake
extends ComplexMobTerrestrial
implements ISpecies,
INewSkins,
INeedsPostUpdate {
    private static final DataParameter<Boolean> RATTLER = EntityDataManager.func_187226_a(EntitySnake.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static Animation ANIMATION_TONGUE;

    public EntitySnake(EntityType<? extends ComplexMobTerrestrial> type, World worldIn) {
        super(type, worldIn);
        this.field_70180_af.func_187214_a(RATTLER, (Object)false);
        ANIMATION_TONGUE = Animation.create((int)10);
        this.ticksToSit = 20;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70144_Y = 1.0f;
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233823_f_, 2.0).func_233815_a_(Attributes.field_233821_d_, 0.33).func_233815_a_(Attributes.field_233819_b_, 12.0).func_233815_a_(Attributes.field_233818_a_, 5.0).func_233815_a_(Attributes.field_233820_c_, 0.0).func_233815_a_(Attributes.field_233826_i_, 0.0);
    }

    public void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SmartSwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.3, false));
        this.field_70714_bg.func_75776_a(2, (Goal)new SmartMateGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(2, new SmartAvoidGoal<LivingEntity>(this, LivingEntity.class, 16.0f, 1.2, 1.6, input -> EntitySnake.getEcoLevel(input) > EntitySnake.getEcoLevel((LivingEntity)this)));
        this.field_70714_bg.func_75776_a(3, (Goal)new SmartWanderGoal(this, 1.0, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(3, new HuntMobTarget<LivingEntity>(this, LivingEntity.class, true, 30, false, input -> EntitySnake.getEcoLevel(input) < EntitySnake.getEcoLevel((LivingEntity)this)));
        this.field_70715_bh.func_75776_a(3, new DontThreadOnMeTarget<LivingEntity>((MobEntity)this, LivingEntity.class, true));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70173_aa % 1000 == 0) {
                if (this.wantsToBreed() && !this.isMale()) {
                    this.breed();
                }
                if (this.field_70146_Z.nextInt(40) == 0) {
                    this.func_70099_a(new ItemStack((IItemProvider)ModItems.MATERIAL_SNAKE_SKIN.get()), 0.2f);
                }
            }
            if (this.field_70170_p.func_82737_E() % 4000L == 0L) {
                this.func_70691_i(1.0f);
            }
            if (this.field_70173_aa % 120 == 0) {
                this.setAnimation(ANIMATION_TONGUE);
            }
            if (this.getAnimation() == NO_ANIMATION && this.func_70638_az() == null && !this.isMobSleeping()) {
                int i = this.field_70146_Z.nextInt(3000);
                if (i <= 10 && !this.func_70090_H() && this.isNotMoving() && this.canMove()) {
                    this.func_70661_as().func_75499_g();
                    this.setSitting(true);
                }
                if ((i == 11 || this.func_70090_H() || this.isActive()) && this.func_233685_eM_()) {
                    this.setSitting(false);
                }
            }
            this.setAngry(this.func_70638_az() != null);
        }
    }

    @Override
    public boolean wantsToBreed() {
        if (super.wantsToBreed() && !this.isMobSleeping() && this.func_70874_b() == 0 && EntityUtils.hasFullHealth((LivingEntity)this)) {
            List list = this.field_70170_p.func_217357_a(EntitySnake.class, this.func_174813_aQ().func_72314_b(6.0, 4.0, 6.0));
            list.removeIf(input -> EntityUtils.isInvalidPartner(this, input, false));
            if (list.size() >= 1) {
                this.func_70873_a(this.getPregnancyTime());
                ((EntitySnake)list.get(0)).func_70873_a(this.getPregnancyTime());
                return true;
            }
        }
        return false;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
    }

    @Override
    protected SoundEvent func_184639_G() {
        if (this.isAngry()) {
            super.func_184639_G();
        }
        return null;
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        EntityUtils.dropEggs(this, "egg_snake", this.getOffspring());
        return null;
    }

    @Override
    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(Hand.MAIN_HAND);
        if (itemstack.func_190926_b() && this.func_70089_S()) {
            EntityUtils.turnEntityIntoItem((LivingEntity)this, "spawn_snake");
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(player, hand);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, ANIMATION_TONGUE};
    }

    public boolean func_70652_k(Entity entityIn) {
        float f = (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e();
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), f);
        if (flag && this.getVenomStrength() > 0) {
            if (entityIn instanceof LivingEntity) {
                ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76436_u, 140, this.getVenomStrength() - 1));
            }
            return true;
        }
        return flag;
    }

    public Integer getVenomStrength() {
        return EntitySnake.getEntityData(this.func_200600_R()).getFlags(this.getVariant(), "venom");
    }

    @Override
    public void updateAttributes() {
        this.setRattler(EntitySnake.getEntityData(this.func_200600_R()).getFlags(this.getVariant(), "rattler") == 1);
    }

    public boolean isRattler() {
        return (Boolean)this.field_70180_af.func_187225_a(RATTLER);
    }

    private void setRattler(boolean dimorphism) {
        this.field_70180_af.func_187227_b(RATTLER, (Object)dimorphism);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("rattler", this.isRattler());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setRattler(compound.func_74767_n("rattler"));
    }
}

