/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.reptile;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.DolphinLookController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.entity.PartEntity;
import untamedwilds.entity.ComplexMobAmphibious;
import untamedwilds.entity.ComplexMobAquatic;
import untamedwilds.entity.ComplexMobTerrestrial;
import untamedwilds.entity.INeedsPostUpdate;
import untamedwilds.entity.INewSkins;
import untamedwilds.entity.ISpecies;
import untamedwilds.entity.ai.AmphibiousRandomSwimGoal;
import untamedwilds.entity.ai.AmphibiousTransition;
import untamedwilds.entity.ai.SmartMateGoal;
import untamedwilds.entity.ai.SmartWanderGoal;
import untamedwilds.entity.ai.target.HuntMobTarget;
import untamedwilds.init.ModEntity;
import untamedwilds.init.ModItems;
import untamedwilds.util.EntityUtils;

public class EntityAnaconda
extends ComplexMobAmphibious
implements ISpecies,
INeedsPostUpdate,
INewSkins {
    public final int length;
    public final EntityAnacondaPart[] anacondaParts;
    public final float[] buffer = new float[3];
    public int ringBufferIndex = -1;
    public final double[][] ringBuffer = new double[64][3];

    public EntityAnaconda(EntityType<? extends ComplexMobTerrestrial> type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.field_70765_h = new ComplexMobAquatic.MoveHelperController(this, 0.8f);
        this.field_70749_g = new DolphinLookController((MobEntity)this, 10);
        this.ticksToSit = 40;
        this.length = this.getMultiparts();
        this.anacondaParts = new EntityAnacondaPart[this.length];
        for (int i = 0; i < this.length; ++i) {
            this.anacondaParts[i] = new EntityAnacondaPart(this, this.func_213311_cf(), this.func_213302_cg());
        }
    }

    private void setPartPosition(EntityAnacondaPart part, double offsetX, double offsetY, double offsetZ) {
        part.func_70107_b(this.func_226277_ct_() + offsetX * (double)part.scale, this.func_226278_cu_() + offsetY * (double)part.scale, this.func_226281_cx_() + offsetZ * (double)part.scale);
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.anacondaParts;
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233823_f_, 3.0).func_233815_a_(Attributes.field_233821_d_, 0.33).func_233815_a_(Attributes.field_233819_b_, 12.0).func_233815_a_(Attributes.field_233818_a_, 30.0).func_233815_a_(Attributes.field_233820_c_, 0.8).func_233815_a_(Attributes.field_233826_i_, 4.0);
    }

    public void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.3, false));
        this.field_70714_bg.func_75776_a(2, (Goal)new SmartMateGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new AmphibiousTransition(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new AmphibiousRandomSwimGoal(this, 0.7, 400));
        this.field_70714_bg.func_75776_a(4, (Goal)new SmartWanderGoal(this, 0.7, false){

            @Override
            public boolean func_75250_a() {
                if (this.creature.peacefulTicks != 0) {
                    return false;
                }
                return super.func_75250_a();
            }
        });
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(3, new HuntMobTarget<LivingEntity>(this, LivingEntity.class, true, 30, false, input -> EntityAnaconda.getEcoLevel(input) < EntityAnaconda.getEcoLevel((LivingEntity)this)));
    }

    @Override
    public void func_70636_d() {
        block14: {
            int i;
            super.func_70636_d();
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70173_aa % 1000 == 0 && this.field_70146_Z.nextInt(40) == 0) {
                    this.func_70099_a(new ItemStack((IItemProvider)ModItems.MATERIAL_SNAKE_SKIN.get()), 0.2f);
                }
                if (this.field_70170_p.func_82737_E() % 4000L == 0L) {
                    this.func_70691_i(1.0f);
                }
                if (this.getAnimation() == NO_ANIMATION && this.func_70638_az() == null && !this.isMobSleeping()) {
                    i = this.field_70146_Z.nextInt(3000);
                    if (i <= 10 && !this.func_70090_H() && this.isNotMoving() && this.canMove()) {
                        this.func_70661_as().func_75499_g();
                        this.setSitting(true);
                    }
                    if ((i == 11 || this.func_70090_H() || this.isActive()) && this.func_233685_eM_()) {
                        this.setSitting(false);
                    }
                }
                this.setAngry(this.func_70638_az() != null);
            }
            if (this.func_175446_cd() || this.func_70631_g_()) break block14;
            if (this.canMove()) {
                if (this.ringBufferIndex < 0) {
                    for (i = 0; i < this.ringBuffer.length; ++i) {
                        this.ringBuffer[i][0] = this.field_70177_z;
                        this.ringBuffer[i][1] = this.func_226278_cu_();
                    }
                }
                ++this.ringBufferIndex;
                if (this.ringBufferIndex == this.ringBuffer.length) {
                    this.ringBufferIndex = 0;
                }
                this.ringBuffer[this.ringBufferIndex][0] = this.field_70177_z;
                this.ringBuffer[this.ringBufferIndex][1] = this.func_226278_cu_();
                Vector3d[] avector3d = new Vector3d[this.anacondaParts.length];
                for (int j = 0; j < this.anacondaParts.length; ++j) {
                    this.anacondaParts[j].collideWithNearbyEntities();
                    avector3d[j] = new Vector3d(this.anacondaParts[j].func_226277_ct_(), this.anacondaParts[j].func_226278_cu_(), this.anacondaParts[j].func_226281_cx_());
                }
                float f15 = (float)(this.getMovementOffsets(5, 1.0f)[1] - this.getMovementOffsets(10, 1.0f)[1]) * 10.0f * ((float)Math.PI / 180);
                float f16 = MathHelper.func_76134_b((float)f15);
                float yaw = this.field_70177_z * ((float)Math.PI / 180);
                float pitch = this.field_70125_A * ((float)Math.PI / 180);
                float f3 = MathHelper.func_76126_a((float)yaw) * (1.0f - Math.abs(this.field_70125_A / 90.0f));
                float f18 = MathHelper.func_76134_b((float)yaw) * (1.0f - Math.abs(this.field_70125_A / 90.0f));
                double[] adouble = this.getMovementOffsets(5, 1.0f);
                for (int k = 0; k < this.getMultiparts(); ++k) {
                    EntityAnacondaPart anaconda_part = this.anacondaParts[k];
                    double[] adouble1 = this.getMovementOffsets(5 + k * 2, 1.0f);
                    float f7 = yaw + (float)MathHelper.func_76138_g((double)(adouble1[0] - adouble[0])) * ((float)Math.PI / 180);
                    float f20 = MathHelper.func_76126_a((float)f7) * (1.0f - Math.abs(this.field_70125_A / 90.0f));
                    float f21 = MathHelper.func_76134_b((float)f7) * (1.0f - Math.abs(this.field_70125_A / 90.0f));
                    float f23 = k == 0 ? (float)(k + 1) : (float)((k + 1) * -1);
                    float value = pitch * (float)k;
                    this.setPartPosition(anaconda_part, -(f3 * 0.5f + f20 * f23) * f16, value, (f18 * 0.5f + f21 * f23) * f16);
                    this.anacondaParts[k].field_70169_q = avector3d[k].field_72450_a;
                    this.anacondaParts[k].field_70167_r = avector3d[k].field_72448_b;
                    this.anacondaParts[k].field_70166_s = avector3d[k].field_72449_c;
                    this.anacondaParts[k].field_70142_S = avector3d[k].field_72450_a;
                    this.anacondaParts[k].field_70137_T = avector3d[k].field_72448_b;
                    this.anacondaParts[k].field_70136_U = avector3d[k].field_72449_c;
                }
            } else {
                for (int k = 0; k < this.getMultiparts(); ++k) {
                    EntityAnacondaPart anaconda_part = this.anacondaParts[k];
                    this.setPartPosition(anaconda_part, 0.0, 0.0, 0.0);
                    this.anacondaParts[k].field_70169_q = this.func_226277_ct_();
                    this.anacondaParts[k].field_70167_r = this.func_226278_cu_();
                    this.anacondaParts[k].field_70166_s = this.func_226281_cx_();
                    this.anacondaParts[k].field_70142_S = this.func_226277_ct_();
                    this.anacondaParts[k].field_70137_T = this.func_226278_cu_();
                    this.anacondaParts[k].field_70136_U = this.func_226281_cx_();
                }
            }
        }
    }

    public double[] getMovementOffsets(int p_70974_1_, float partialTicks) {
        if (this.func_233643_dh_()) {
            partialTicks = 0.0f;
        }
        partialTicks = 1.0f - partialTicks;
        int i = this.ringBufferIndex - p_70974_1_ & 0x3F;
        int j = this.ringBufferIndex - p_70974_1_ - 1 & 0x3F;
        double[] adouble = new double[3];
        double d0 = this.ringBuffer[i][0];
        double d1 = this.ringBuffer[j][0] - d0;
        adouble[0] = d0 + d1 * (double)partialTicks;
        d0 = this.ringBuffer[i][1];
        d1 = this.ringBuffer[j][1] - d0;
        adouble[1] = d0 + d1 * (double)partialTicks;
        adouble[2] = MathHelper.func_219803_d((double)partialTicks, (double)this.ringBuffer[i][2], (double)this.ringBuffer[j][2]);
        return adouble;
    }

    @Override
    public boolean wantsToBreed() {
        if (super.wantsToBreed() && !this.isMobSleeping() && this.func_70874_b() == 0 && EntityUtils.hasFullHealth((LivingEntity)this)) {
            List list = this.field_70170_p.func_217357_a(EntityAnaconda.class, this.func_174813_aQ().func_72314_b(6.0, 4.0, 6.0));
            list.removeIf(input -> EntityUtils.isInvalidPartner(this, input, false));
            if (list.size() >= 1) {
                this.func_70873_a(this.getPregnancyTime());
                ((EntityAnaconda)list.get(0)).func_70873_a(this.getPregnancyTime());
                return true;
            }
        }
        return false;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
    }

    @Override
    protected SoundEvent func_184639_G() {
        if (this.isAngry()) {
            return super.func_184639_G();
        }
        return null;
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        if (this.isEggLayer()) {
            EntityUtils.dropEggs(this, "egg_large_snake_" + this.getRawSpeciesName(this.getVariant()).toLowerCase(), 4);
            return null;
        }
        return this.create_offspring(new EntityAnaconda((EntityType<? extends ComplexMobTerrestrial>)ModEntity.ANACONDA, this.field_70170_p));
    }

    public boolean func_70652_k(Entity entityIn) {
        float f = (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e();
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), f);
        if (flag) {
            if (this.peacefulTicks == 0 && entityIn instanceof LivingEntity && !(entityIn instanceof PlayerEntity) && entityIn.func_213311_cf() * entityIn.func_213302_cg() < 1.2f && entityIn instanceof TameableEntity && !((TameableEntity)entityIn).func_70909_n()) {
                this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_226131_af_, SoundCategory.BLOCKS, 1.0f, 1.0f);
                EntityUtils.spawnParticlesOnEntity(this.field_70170_p, (LivingEntity)entityIn, ParticleTypes.field_197598_I, 6, 2);
                this.func_213317_d(new Vector3d(entityIn.func_226277_ct_() - this.func_226277_ct_(), entityIn.func_226278_cu_() - this.func_226278_cu_(), entityIn.func_226281_cx_() - this.func_226281_cx_()).func_186678_a((double)0.15f));
                this.peacefulTicks = 144000;
                entityIn.func_70106_y();
            }
            return true;
        }
        return flag;
    }

    public boolean attackEntityPartFrom(EntityAnacondaPart anaconda_part, DamageSource source, float amount) {
        return this.func_70097_a(source, amount);
    }

    public boolean isEggLayer() {
        return EntityAnaconda.getEntityData(this.func_200600_R()).getFlags(this.getVariant(), "eggLayer") == 1;
    }

    public int getMultiparts() {
        return 3;
    }

    @Override
    public void updateAttributes() {
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a((double)EntityAnaconda.getEntityData(this.func_200600_R()).getSpeciesData().get(this.getVariant()).getAttack().floatValue());
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)EntityAnaconda.getEntityData(this.func_200600_R()).getSpeciesData().get(this.getVariant()).getHealth().floatValue());
        this.func_70606_j(this.func_110138_aP());
    }

    public static class EntityAnacondaPart
    extends PartEntity<EntityAnaconda> {
        private final EntitySize size;
        public float scale = 1.0f;

        public EntityAnacondaPart(EntityAnaconda parent, float sizeX, float sizeY) {
            super((Entity)parent);
            this.size = EntitySize.func_220314_b((float)sizeX, (float)sizeY);
            this.func_213323_x_();
        }

        protected void collideWithNearbyEntities() {
            List entities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a((double)0.2f, 0.0, (double)0.2f));
            Entity parent = this.getParent();
            if (parent != null) {
                entities.stream().filter(entity -> entity != parent && (!(entity instanceof EntityAnacondaPart) || ((EntityAnacondaPart)((Object)entity)).getParent() != parent) && entity.func_70104_M()).forEach(entity -> entity.func_70108_f(parent));
            }
        }

        public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
            return this.getParent() == null ? ActionResultType.PASS : ((EntityAnaconda)this.getParent()).func_230254_b_(player, hand);
        }

        public void func_70108_f(Entity entityIn) {
            entityIn.func_70108_f((Entity)this);
        }

        public boolean func_70067_L() {
            return true;
        }

        protected void func_70037_a(CompoundNBT compound) {
        }

        protected void func_213281_b(CompoundNBT compound) {
        }

        protected void func_70088_a() {
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            return !this.func_180431_b(source) && ((EntityAnaconda)this.getParent()).attackEntityPartFrom(this, source, amount);
        }

        public boolean func_70028_i(Entity entityIn) {
            return this == entityIn || this.getParent() == entityIn;
        }

        public IPacket<?> func_213297_N() {
            throw new UnsupportedOperationException();
        }

        public EntitySize func_213305_a(Pose poseIn) {
            return this.size.func_220313_a(this.scale);
        }
    }
}

