/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.mammal;

import com.github.alexthe666.citadel.animation.Animation;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.monster.IFlinging;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ComplexMobTerrestrial;
import untamedwilds.entity.INeedsPostUpdate;
import untamedwilds.entity.INewSkins;
import untamedwilds.entity.ISpecies;
import untamedwilds.entity.ai.GotoSleepGoal;
import untamedwilds.entity.ai.GrazeGoal;
import untamedwilds.entity.ai.MeleeAttackCharger;
import untamedwilds.entity.ai.SmartFollowOwnerGoal;
import untamedwilds.entity.ai.SmartLookAtGoal;
import untamedwilds.entity.ai.SmartMateGoal;
import untamedwilds.entity.ai.SmartMeleeAttackGoal;
import untamedwilds.entity.ai.SmartWanderGoal;
import untamedwilds.entity.ai.target.ProtectChildrenTarget;
import untamedwilds.entity.ai.target.SmartOwnerHurtTargetGoal;
import untamedwilds.init.ModEntity;
import untamedwilds.util.EntityUtils;

public class EntityRhino
extends ComplexMobTerrestrial
implements INewSkins,
ISpecies,
INeedsPostUpdate {
    private static final DataParameter<Boolean> CHARGING = EntityDataManager.func_187226_a(EntityRhino.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static Animation ATTACK_THREATEN;
    public static Animation ATTACK_GORE;

    public EntityRhino(EntityType<? extends ComplexMob> type, World worldIn) {
        super(type, worldIn);
        ATTACK_THREATEN = Animation.create((int)50);
        ATTACK_GORE = Animation.create((int)14);
        this.field_70138_W = 1.0f;
        this.field_70728_aV = 10;
        this.turn_speed = 0.2f;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CHARGING, (Object)false);
    }

    public void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackCharger(this, 1.4f, 3));
        this.field_70714_bg.func_75776_a(2, (Goal)new SmartMeleeAttackGoal((CreatureEntity)this, 1.6, false));
        this.field_70714_bg.func_75776_a(3, (Goal)new SmartMateGoal(this, 0.8));
        this.field_70714_bg.func_75776_a(3, (Goal)new GrazeGoal(this, 10));
        this.field_70714_bg.func_75776_a(4, (Goal)new GotoSleepGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new SmartWanderGoal(this, 1.0, 120, 0, true));
        this.field_70714_bg.func_75776_a(6, (Goal)new SmartLookAtGoal(this, LivingEntity.class, 10.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, new ProtectChildrenTarget<LivingEntity>((ComplexMob)this, LivingEntity.class, 0, true, true, input -> !(input instanceof EntityRhino) && EntityRhino.getEcoLevel(input) > EntityRhino.getEcoLevel((LivingEntity)this)));
    }

    protected void func_175544_ck() {
        if (this.func_70909_n()) {
            this.field_70714_bg.func_75776_a(3, (Goal)new SmartFollowOwnerGoal(this, 1.3, 12.0f, 3.0f));
            this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
            this.field_70715_bh.func_75776_a(2, (Goal)new SmartOwnerHurtTargetGoal(this));
        }
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233823_f_, 8.0).func_233815_a_(Attributes.field_233821_d_, 0.2).func_233815_a_(Attributes.field_233819_b_, 24.0).func_233815_a_(Attributes.field_233818_a_, 60.0).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233826_i_, 6.0);
    }

    @Override
    public boolean wantsToBreed() {
        if (((Boolean)ConfigGamerules.naturalBreeding.get()).booleanValue() && this.field_175504_a == 0) {
            return this.getHunger() >= 80;
        }
        return false;
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K) {
            int i;
            if (this.field_70170_p.func_82737_E() % 1000L == 0L) {
                this.addHunger(-10);
                if (!this.isStarving()) {
                    this.func_70691_i(1.0f);
                }
            }
            if ((i = this.field_70146_Z.nextInt(3000)) == 13 && !this.func_70090_H() && this.func_70638_az() == null && this.isNotMoving() && this.canMove() && this.getAnimation() == NO_ANIMATION) {
                this.setSitting(true);
            }
            if (i == 14 && this.func_233685_eM_()) {
                this.setSitting(false);
            }
            this.setAngry(this.func_70638_az() != null);
        } else if (this.getAnimation() == ATTACK_THREATEN) {
            this.func_70031_b(this.getAnimationTick() % 18 < 6);
        }
        super.func_70636_d();
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        if (flag && this.getAnimation() == NO_ANIMATION && !this.func_70631_g_()) {
            Animation anim = this.chooseAttackAnimation();
            this.setAnimation(anim);
            if (!this.isCharging()) {
                this.func_184185_a(SoundEvents.field_232852_rw_, 1.0f, this.func_70647_i());
                IFlinging.func_234403_a_((LivingEntity)this, (LivingEntity)((LivingEntity)entityIn));
            }
        }
        return flag;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_219648_fh, 0.15f, 1.0f);
    }

    private Animation chooseAttackAnimation() {
        return ATTACK_GORE;
    }

    @Nullable
    public EntityRhino func_241840_a(ServerWorld serverWorld, AgeableEntity ageable) {
        return this.create_offspring(new EntityRhino(ModEntity.RHINO, this.field_70170_p));
    }

    @Override
    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(Hand.MAIN_HAND);
        if (hand == Hand.MAIN_HAND && !this.field_70170_p.func_201670_d() && !this.func_70909_n() && this.func_70631_g_() && EntityUtils.hasFullHealth((LivingEntity)this) && this.func_70877_b(itemstack)) {
            this.func_184185_a(SoundEvents.field_187711_cp, 1.5f, 0.8f);
            if (this.func_70681_au().nextInt(3) == 0) {
                this.func_193101_c(player);
                EntityUtils.spawnParticlesOnEntity(this.field_70170_p, (LivingEntity)this, ParticleTypes.field_197633_z, 3, 6);
            } else {
                EntityUtils.spawnParticlesOnEntity(this.field_70170_p, (LivingEntity)this, ParticleTypes.field_197601_L, 3, 3);
            }
        }
        return super.func_230254_b_(player, hand);
    }

    public boolean isCharging() {
        return (Boolean)this.field_70180_af.func_187225_a(CHARGING);
    }

    public void setCharging(boolean bool) {
        this.field_70180_af.func_187227_b(CHARGING, (Object)bool);
    }

    @Override
    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_221794_dg;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, ATTACK_THREATEN, ATTACK_GORE};
    }

    @Override
    public Animation getAnimationEat() {
        return NO_ANIMATION;
    }

    @Override
    public void updateAttributes() {
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a((double)EntityRhino.getEntityData(this.func_200600_R()).getSpeciesData().get(this.getVariant()).getAttack().floatValue());
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)EntityRhino.getEntityData(this.func_200600_R()).getSpeciesData().get(this.getVariant()).getHealth().floatValue());
        this.func_70606_j(this.func_110138_aP());
    }
}

