/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.mammal;

import com.github.alexthe666.citadel.animation.Animation;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ComplexMobAmphibious;
import untamedwilds.entity.INewSkins;
import untamedwilds.entity.ISpecies;
import untamedwilds.entity.ai.AmphibiousRandomSwimGoal;
import untamedwilds.entity.ai.AmphibiousTransition;
import untamedwilds.entity.ai.GotoSleepGoal;
import untamedwilds.entity.ai.GrazeGoal;
import untamedwilds.entity.ai.SmartLookAtGoal;
import untamedwilds.entity.ai.SmartMateGoal;
import untamedwilds.entity.ai.SmartMeleeAttackGoal;
import untamedwilds.entity.ai.SmartWanderGoal;
import untamedwilds.entity.ai.unique.HippoTerritoryTargetGoal;
import untamedwilds.init.ModEntity;
import untamedwilds.util.EntityUtils;

public class EntityHippo
extends ComplexMobAmphibious
implements INewSkins,
ISpecies {
    public static Animation EAT;
    public static Animation IDLE_YAWN;
    public static Animation IDLE_LOOK;
    public static Animation ATTACK;
    public static Animation IDLE_TALK;
    public int angryProgress;

    public EntityHippo(EntityType<? extends ComplexMob> type, World worldIn) {
        super(type, worldIn);
        IDLE_YAWN = Animation.create((int)36);
        IDLE_LOOK = Animation.create((int)128);
        IDLE_TALK = Animation.create((int)20);
        EAT = Animation.create((int)48);
        ATTACK = Animation.create((int)24);
        this.field_70138_W = 1.0f;
        this.field_70728_aV = 10;
        this.isAmphibious = true;
        this.buoyancy = 0.998f;
        this.turn_speed = 0.3f;
    }

    public void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (Goal)new SmartMeleeAttackGoal((CreatureEntity)this, 1.4, false));
        this.field_70714_bg.func_75776_a(3, (Goal)new SmartMateGoal(this, 0.8));
        this.field_70714_bg.func_75776_a(3, (Goal)new GrazeGoal(this, 10));
        this.field_70714_bg.func_75776_a(4, (Goal)new AmphibiousTransition(this, 1.1));
        this.field_70714_bg.func_75776_a(4, (Goal)new GotoSleepGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new SmartWanderGoal(this, 1.0, 120, 0, false));
        this.field_70714_bg.func_75776_a(5, (Goal)new AmphibiousRandomSwimGoal(this, 1.0, 120));
        this.field_70714_bg.func_75776_a(6, (Goal)new SmartLookAtGoal(this, LivingEntity.class, 10.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(3, new HippoTerritoryTargetGoal<LivingEntity>(this, LivingEntity.class, true, false, input -> !(input instanceof EntityHippo) && !(input instanceof ISpecies) && EntityHippo.getEcoLevel(input) <= EntityHippo.getEcoLevel((LivingEntity)this)));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233823_f_, 9.0).func_233815_a_(Attributes.field_233821_d_, 0.2).func_233815_a_(Attributes.field_233819_b_, 24.0).func_233815_a_(Attributes.field_233818_a_, 60.0).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233826_i_, 0.0);
    }

    @Override
    public boolean wantsToBreed() {
        if (((Boolean)ConfigGamerules.naturalBreeding.get()).booleanValue() && this.field_175504_a == 0) {
            return this.getHunger() >= 80;
        }
        return false;
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K) {
            int i;
            if (this.field_70170_p.func_82737_E() % 1000L == 0L) {
                this.addHunger(-10);
                if (!this.isStarving()) {
                    this.func_70691_i(1.0f);
                }
            }
            if (!((i = this.field_70146_Z.nextInt(3000)) > 8 || this.func_70090_H() || this.isAngry() || this.isMobSleeping() || this.getAnimation() != NO_ANIMATION)) {
                this.setAnimation(IDLE_YAWN);
            }
            if (i > 8 && i <= 12 && !this.isAngry() && !this.isMobSleeping() && this.getAnimation() == NO_ANIMATION) {
                this.setAnimation(IDLE_LOOK);
            }
            if (i == 13 && !this.func_70090_H() && this.isNotMoving() && this.canMove() && this.getAnimation() == NO_ANIMATION) {
                this.setSitting(true);
            }
            if (i == 14 && this.func_233685_eM_()) {
                this.setSitting(false);
            }
            if (i == 15 && !this.isActive() && !this.isMobSleeping() && this.func_70090_H()) {
                this.setAnimation(IDLE_YAWN);
                this.setMobSleeping(true);
                this.forceSleep = -800 - this.field_70146_Z.nextInt(1200);
            }
            if (i > 2980 && !this.func_70631_g_()) {
                this.setAnimation(IDLE_TALK);
            }
            if (this.getAnimation() == ATTACK && this.func_70638_az() != null && this.func_174813_aQ().func_72314_b((double)1.2f, 1.0, (double)1.2f).func_72318_a(this.func_70638_az().func_213303_ch()) && this.getAnimationTick() > 8) {
                LivingEntity target = this.func_70638_az();
                this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e());
                EntityUtils.destroyBoat(this.field_70170_p, target);
            }
            this.setAngry(this.func_70638_az() != null);
        }
        if (this.getAnimation() != NO_ANIMATION && this.getAnimation() == IDLE_TALK && this.getAnimationTick() == 1) {
            this.func_184185_a(this.func_184639_G(), this.func_70599_aP(), this.func_70647_i());
        }
        if (this.field_70170_p.field_72995_K && this.isAngry() && this.angryProgress < 40) {
            this.angryProgress += 4;
        } else if (this.field_70170_p.field_72995_K && !this.isAngry() && this.angryProgress > 0) {
            this.angryProgress -= 4;
        }
        super.func_70636_d();
    }

    @Override
    public boolean wantsToLeaveWater() {
        return this.isActive();
    }

    @Override
    public boolean wantsToEnterWater() {
        return !this.isActive();
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        if (flag && this.getAnimation() == NO_ANIMATION && !this.func_70631_g_()) {
            Animation anim = this.chooseAttackAnimation();
            this.setAnimation(anim);
        }
        return flag;
    }

    private Animation chooseAttackAnimation() {
        return ATTACK;
    }

    @Nullable
    public EntityHippo func_241840_a(ServerWorld serverWorld, AgeableEntity ageable) {
        return this.create_offspring(new EntityHippo(ModEntity.HIPPO, this.field_70170_p));
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, EAT, IDLE_YAWN, IDLE_LOOK, IDLE_TALK, ATTACK};
    }

    @Override
    public Animation getAnimationEat() {
        return EAT;
    }
}

