/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.mammal;

import com.github.alexthe666.citadel.animation.Animation;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ComplexMobTerrestrial;
import untamedwilds.entity.INeedsPostUpdate;
import untamedwilds.entity.INewSkins;
import untamedwilds.entity.IPackEntity;
import untamedwilds.entity.ISpecies;
import untamedwilds.entity.ai.FindItemsGoal;
import untamedwilds.entity.ai.FollowParentGoal;
import untamedwilds.entity.ai.GotoSleepGoal;
import untamedwilds.entity.ai.SmartAvoidGoal;
import untamedwilds.entity.ai.SmartFollowOwnerGoal;
import untamedwilds.entity.ai.SmartLookAtGoal;
import untamedwilds.entity.ai.SmartMateGoal;
import untamedwilds.entity.ai.SmartMeleeAttackGoal;
import untamedwilds.entity.ai.SmartSwimGoal;
import untamedwilds.entity.ai.SmartWanderGoal;
import untamedwilds.entity.ai.target.HuntMobTarget;
import untamedwilds.entity.ai.target.ProtectChildrenTarget;
import untamedwilds.entity.ai.target.SmartOwnerHurtTargetGoal;
import untamedwilds.init.ModEntity;
import untamedwilds.util.EntityUtils;

public class EntityBigCat
extends ComplexMobTerrestrial
implements ISpecies,
INewSkins,
INeedsPostUpdate,
IPackEntity {
    private static final DataParameter<Boolean> DIMORPHISM = EntityDataManager.func_187226_a(EntityBigCat.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static Animation ATTACK_BITE;
    public static Animation ATTACK_MAUL;
    public static Animation ATTACK_POUNCE;
    public static Animation ANIMATION_ROAR;
    public static Animation ANIMATION_EAT;
    public static Animation IDLE_TALK;
    public static Animation IDLE_STRETCH;
    public int aggroProgress;

    public EntityBigCat(EntityType<? extends ComplexMob> type, World worldIn) {
        super(type, worldIn);
        this.field_70180_af.func_187214_a(DIMORPHISM, (Object)false);
        ATTACK_POUNCE = Animation.create((int)42);
        ATTACK_MAUL = Animation.create((int)22);
        IDLE_TALK = Animation.create((int)20);
        IDLE_STRETCH = Animation.create((int)110);
        this.field_70138_W = 1.0f;
        this.field_70728_aV = 10;
        this.turn_speed = 0.1f;
    }

    public void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SmartSwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new FindItemsGoal(this, 12, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new SmartMeleeAttackGoal((CreatureEntity)this, 2.3, false, 1.0f, false, true));
        this.field_70714_bg.func_75776_a(3, new SmartAvoidGoal<LivingEntity>(this, LivingEntity.class, 16.0f, 1.2, 1.6, input -> EntityBigCat.getEcoLevel(input) > EntityBigCat.getEcoLevel((LivingEntity)this)));
        this.field_70714_bg.func_75776_a(4, (Goal)new SmartMateGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new GotoSleepGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal(this, 1.25));
        this.field_70714_bg.func_75776_a(5, (Goal)new SmartWanderGoal(this, 1.0, true));
        this.field_70714_bg.func_75776_a(6, (Goal)new SmartLookAtGoal(this, LivingEntity.class, 10.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, new ProtectChildrenTarget<LivingEntity>((ComplexMob)this, LivingEntity.class, 0, true, true, input -> !(input instanceof EntityBigCat)));
        this.field_70715_bh.func_75776_a(3, new HuntMobTarget<LivingEntity>(this, LivingEntity.class, true, 30, false, input -> EntityBigCat.getEcoLevel(input) < EntityBigCat.getEcoLevel((LivingEntity)this)));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233823_f_, 8.0).func_233815_a_(Attributes.field_233821_d_, 0.16).func_233815_a_(Attributes.field_233819_b_, 32.0).func_233815_a_(Attributes.field_233818_a_, 40.0).func_233815_a_(Attributes.field_233820_c_, 0.8).func_233815_a_(Attributes.field_233826_i_, 0.0);
    }

    @Override
    public boolean wantsToBreed() {
        if (super.wantsToBreed() && !this.isMobSleeping() && this.func_70874_b() == 0 && EntityUtils.hasFullHealth((LivingEntity)this) && this.getHunger() >= 80) {
            if (((Boolean)ConfigGamerules.hardcoreBreeding.get()).booleanValue()) {
                List list = this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_72314_b(6.0, 4.0, 6.0));
                return list.size() < 3;
            }
            return true;
        }
        return false;
    }

    @Nullable
    public EntityBigCat func_241840_a(ServerWorld serverWorld, AgeableEntity ageable) {
        return this.create_offspring(new EntityBigCat(ModEntity.BIG_CAT, this.field_70170_p));
    }

    public boolean func_96092_aw() {
        return false;
    }

    protected int func_225508_e_(float distance, float damageMultiplier) {
        return MathHelper.func_76123_f((float)((distance * 0.5f - 3.0f) * damageMultiplier));
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K) {
            PlayerEntity player;
            List list;
            if (this.herd == null && EntityUtils.getPackSize(this.func_200600_R(), this.getVariant()) > 1) {
                IPackEntity.initPack(this);
            } else if (EntityUtils.getPackSize(this.func_200600_R(), this.getVariant()) > 1) {
                this.herd.tick();
            }
            if (this.field_70173_aa % 600 == 0 && this.wantsToBreed()) {
                this.func_146082_f(null);
            }
            if (this.field_70170_p.func_82737_E() % 1000L == 0L) {
                this.addHunger(-3);
                if (!this.isStarving()) {
                    this.func_70691_i(2.0f);
                }
            }
            if (((Boolean)ConfigGamerules.angrySleepers.get()).booleanValue() && !this.func_70909_n() && this.isMobSleeping() && this.forceSleep == 0 && !(list = this.field_70170_p.func_217357_a(PlayerEntity.class, this.func_174813_aQ().func_72314_b(6.0, 4.0, 6.0))).isEmpty() && !(player = (PlayerEntity)list.get(0)).func_225608_bj_() && !player.func_184812_l_()) {
                this.setMobSleeping(false);
                this.func_70624_b((LivingEntity)player);
                this.forceSleep = -300;
            }
            if (this.field_70173_aa % 200 == 0 && !this.isActive() && this.func_70661_as().func_75500_f()) {
                ++this.tiredCounter;
                if (this.func_195048_a(this.getHomeAsVec()) <= 6.0) {
                    this.setMobSleeping(true);
                    this.tiredCounter = 0;
                } else if (this.tiredCounter >= 3) {
                    this.setHome(BlockPos.field_177992_a);
                    this.tiredCounter = 0;
                }
            }
            if (this.getAnimation() == NO_ANIMATION && this.func_70638_az() == null && !this.isMobSleeping() && this.getCommandInt() == 0) {
                int i = this.field_70146_Z.nextInt(3000);
                if (i == 0 && !this.func_70090_H() && this.isNotMoving() && this.canMove() && this.isActive()) {
                    this.func_70661_as().func_75499_g();
                    this.setSitting(true);
                }
                if ((i == 1 || this.func_70090_H()) && this.func_233685_eM_() && this.getCommandInt() < 2) {
                    this.setSitting(false);
                }
                if (i == 2 && this.canMove() && !this.func_70090_H() && !this.func_70631_g_()) {
                    this.func_70661_as().func_75499_g();
                    this.setAnimation(IDLE_STRETCH);
                }
                if (i > 2980 && !this.func_70090_H() && !this.func_70631_g_()) {
                    this.setAnimation(IDLE_TALK);
                }
            }
            if (this.field_70173_aa % 80 == 2 && this.func_70638_az() != null && this.getAnimation() == NO_ANIMATION) {
                this.setAnimation(ANIMATION_ROAR);
            }
            if (this.getAnimation() == ATTACK_POUNCE && this.getAnimationTick() == 10) {
                this.func_70605_aq().func_188488_a(2.0f, 0.0f);
                this.func_70683_ar().func_75660_a();
            }
            this.setAngry(this.func_70638_az() != null);
        }
        if (this.getAnimation() == ANIMATION_EAT && (this.getAnimationTick() == 10 || this.getAnimationTick() == 20 || this.getAnimationTick() == 30)) {
            this.func_184185_a(SoundEvents.field_187711_cp, 1.5f, 0.8f);
        }
        if (this.getAnimation() == ATTACK_MAUL && this.getAnimationTick() == 10) {
            this.func_184185_a(SoundEvents.field_187730_dW, 1.5f, 0.8f);
        }
        if (this.getAnimation() == IDLE_TALK && this.getAnimationTick() == 1) {
            this.func_184185_a(this.func_184639_G(), this.func_70599_aP(), this.func_70647_i());
        }
        if (this.field_70170_p.field_72995_K && this.isAngry() && this.aggroProgress < 40) {
            ++this.aggroProgress;
        } else if (this.field_70170_p.field_72995_K && !this.isAngry() && this.aggroProgress > 0) {
            --this.aggroProgress;
        }
        super.func_70636_d();
    }

    public double func_70042_X() {
        return this.getModelScale() + 0.5f * this.getMobSize();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.15f, 1.0f);
    }

    protected void func_175544_ck() {
        if (this.func_70909_n()) {
            this.field_70714_bg.func_75776_a(3, (Goal)new SmartFollowOwnerGoal(this, 2.3, 12.0f, 3.0f));
            this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
            this.field_70715_bh.func_75776_a(2, (Goal)new SmartOwnerHurtTargetGoal(this));
        }
    }

    @Override
    protected SoundEvent func_184639_G() {
        return this.func_70631_g_() ? SoundEvents.field_219667_hf : super.func_184639_G();
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return this.func_70631_g_() ? SoundEvents.field_219666_he : super.func_184601_bQ(source);
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return this.func_70631_g_() ? SoundEvents.field_219668_hg : super.func_184615_bR();
    }

    @Override
    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(Hand.MAIN_HAND);
        if (hand == Hand.MAIN_HAND && !this.field_70170_p.func_201670_d() && !this.func_70909_n() && this.func_70631_g_() && EntityUtils.hasFullHealth((LivingEntity)this) && this.func_70877_b(itemstack)) {
            this.func_184185_a(SoundEvents.field_187711_cp, 1.5f, 0.8f);
            if (this.func_70681_au().nextInt(3) == 0) {
                this.func_193101_c(player);
                EntityUtils.spawnParticlesOnEntity(this.field_70170_p, (LivingEntity)this, ParticleTypes.field_197633_z, 3, 6);
            } else {
                EntityUtils.spawnParticlesOnEntity(this.field_70170_p, (LivingEntity)this, ParticleTypes.field_197601_L, 3, 3);
            }
        }
        return super.func_230254_b_(player, hand);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        if (flag && this.getAnimation() == NO_ANIMATION && !this.func_70631_g_()) {
            Animation anim = this.chooseAttackAnimation(entityIn);
            this.setAnimation(anim);
            this.setAnimationTick(0);
        }
        return flag;
    }

    private Animation chooseAttackAnimation(Entity target) {
        if (target.func_213302_cg() < this.func_213302_cg()) {
            return ATTACK_MAUL;
        }
        return ATTACK_POUNCE;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, ATTACK_POUNCE, ATTACK_MAUL, IDLE_TALK, IDLE_STRETCH};
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.9f;
    }

    @Override
    public void updateAttributes() {
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a((double)EntityBigCat.getEntityData(this.func_200600_R()).getSpeciesData().get(this.getVariant()).getAttack().floatValue());
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)EntityBigCat.getEntityData(this.func_200600_R()).getSpeciesData().get(this.getVariant()).getHealth().floatValue());
        this.func_70606_j(this.func_110138_aP());
        this.setDimorphism(EntityBigCat.getEntityData(this.func_200600_R()).getFlags(this.getVariant(), "dimorphism") == 1);
    }

    public boolean hasDimorphism() {
        return (Boolean)this.field_70180_af.func_187225_a(DIMORPHISM);
    }

    private void setDimorphism(boolean dimorphism) {
        this.field_70180_af.func_187227_b(DIMORPHISM, (Object)dimorphism);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("hasDimorphism", this.hasDimorphism());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setDimorphism(compound.func_74767_n("hasDimorphism"));
    }

    @Override
    public ResourceLocation getTexture() {
        ResourceLocation texture_path = EntityUtils.getSkinFromEntity(this);
        if (this.hasDimorphism()) {
            String trimmed_path = texture_path.func_110623_a().substring(0, texture_path.func_110623_a().lastIndexOf(46));
            return new ResourceLocation("untamedwilds", trimmed_path + "_" + this.getGenderString() + ".png");
        }
        return texture_path;
    }
}

