/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.mammal;

import com.github.alexthe666.citadel.animation.Animation;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ComplexMobTerrestrial;
import untamedwilds.entity.INeedsPostUpdate;
import untamedwilds.entity.INewSkins;
import untamedwilds.entity.ISpecies;
import untamedwilds.entity.ai.FindItemsGoal;
import untamedwilds.entity.ai.FollowParentGoal;
import untamedwilds.entity.ai.GotoSleepGoal;
import untamedwilds.entity.ai.SmartAvoidGoal;
import untamedwilds.entity.ai.SmartFollowOwnerGoal;
import untamedwilds.entity.ai.SmartLookAtGoal;
import untamedwilds.entity.ai.SmartMateGoal;
import untamedwilds.entity.ai.SmartMeleeAttackGoal;
import untamedwilds.entity.ai.SmartSwimGoal;
import untamedwilds.entity.ai.SmartWanderGoal;
import untamedwilds.entity.ai.target.HuntMobTarget;
import untamedwilds.entity.ai.target.ProtectChildrenTarget;
import untamedwilds.entity.ai.target.SmartOwnerHurtTargetGoal;
import untamedwilds.init.ModEntity;
import untamedwilds.init.ModSounds;
import untamedwilds.util.EntityUtils;

public class EntityBear
extends ComplexMobTerrestrial
implements ISpecies,
INewSkins,
INeedsPostUpdate {
    private static final DataParameter<Boolean> SHORT_SNOUT = EntityDataManager.func_187226_a(EntityBear.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> BACK_HUMP = EntityDataManager.func_187226_a(EntityBear.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static Animation ATTACK_BITE;
    public static Animation ATTACK_MAUL;
    public static Animation ATTACK_SWIPE;
    public static Animation ATTACK_POUND;
    public static Animation ANIMATION_ROAR;
    public static Animation IDLE_STAND;
    public static Animation IDLE_TALK;
    public static Animation ANIMATION_EAT;

    public EntityBear(EntityType<? extends ComplexMob> type, World worldIn) {
        super(type, worldIn);
        this.field_70180_af.func_187214_a(SHORT_SNOUT, (Object)false);
        this.field_70180_af.func_187214_a(BACK_HUMP, (Object)false);
        ANIMATION_ROAR = Animation.create((int)50);
        IDLE_TALK = Animation.create((int)20);
        IDLE_STAND = Animation.create((int)148);
        ANIMATION_EAT = Animation.create((int)104);
        ATTACK_BITE = Animation.create((int)18);
        ATTACK_MAUL = Animation.create((int)76);
        ATTACK_SWIPE = Animation.create((int)26);
        ATTACK_POUND = Animation.create((int)28);
        this.field_70138_W = 1.0f;
        this.turn_speed = 0.3f;
        this.field_70728_aV = 10;
    }

    public void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SmartSwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new FindItemsGoal(this, 12));
        this.field_70714_bg.func_75776_a(2, (Goal)new SmartMeleeAttackGoal((CreatureEntity)this, 2.3, false, 1.0f));
        this.field_70714_bg.func_75776_a(3, new SmartAvoidGoal<LivingEntity>(this, LivingEntity.class, 16.0f, 1.2, 1.6, input -> EntityBear.getEcoLevel(input) > EntityBear.getEcoLevel((LivingEntity)this)));
        this.field_70714_bg.func_75776_a(4, (Goal)new SmartMateGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new GotoSleepGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal(this, 1.25));
        this.field_70714_bg.func_75776_a(6, (Goal)new SmartWanderGoal(this, 1.0, true));
        this.field_70714_bg.func_75776_a(7, (Goal)new SmartLookAtGoal(this, LivingEntity.class, 10.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, new ProtectChildrenTarget<LivingEntity>((ComplexMob)this, LivingEntity.class, 0, true, true, input -> !(input instanceof EntityBear)));
        this.field_70715_bh.func_75776_a(3, new HuntMobTarget<LivingEntity>(this, LivingEntity.class, true, 30, false, input -> EntityBear.getEcoLevel(input) < EntityBear.getEcoLevel((LivingEntity)this)));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233823_f_, 5.0).func_233815_a_(Attributes.field_233821_d_, 0.15).func_233815_a_(Attributes.field_233819_b_, 24.0).func_233815_a_(Attributes.field_233818_a_, 30.0).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233826_i_, 4.0);
    }

    @Override
    public boolean wantsToBreed() {
        if (super.wantsToBreed() && !this.isMobSleeping() && this.func_70874_b() == 0 && EntityUtils.hasFullHealth((LivingEntity)this) && this.getHunger() >= 80) {
            if (((Boolean)ConfigGamerules.hardcoreBreeding.get()).booleanValue()) {
                List list = this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_72314_b(6.0, 4.0, 6.0));
                return list.size() < 3;
            }
            return true;
        }
        return false;
    }

    @Nullable
    public EntityBear func_241840_a(ServerWorld serverWorld, AgeableEntity ageable) {
        return this.create_offspring(new EntityBear(ModEntity.BEAR, this.field_70170_p));
    }

    public boolean func_96092_aw() {
        return false;
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K) {
            PlayerEntity player;
            List list;
            if (this.field_70173_aa % 600 == 0 && this.wantsToBreed()) {
                this.func_146082_f(null);
            }
            if (this.field_70173_aa % 1000 == 0) {
                this.addHunger(-2);
                if (!this.isStarving()) {
                    this.func_70691_i(2.0f);
                }
            }
            if (this.func_110143_aJ() < this.func_110138_aP() / 2.0f) {
                this.func_195064_c(new EffectInstance(Effects.field_76420_g, 1200, 0, true, true));
                this.forceSleep = -1200;
            }
            if (((Boolean)ConfigGamerules.angrySleepers.get()).booleanValue() && !this.func_70909_n() && this.isMobSleeping() && this.forceSleep == 0 && !(list = this.field_70170_p.func_217357_a(PlayerEntity.class, this.func_174813_aQ().func_72314_b(6.0, 4.0, 6.0))).isEmpty() && !(player = (PlayerEntity)list.get(0)).func_225608_bj_() && !player.func_184812_l_()) {
                this.setMobSleeping(false);
                this.func_70624_b((LivingEntity)player);
                this.forceSleep = -300;
            }
            this.setAngry(this.func_70638_az() != null);
            if (this.getAnimation() == NO_ANIMATION && this.func_70638_az() == null && !this.isMobSleeping() && this.getCommandInt() == 0) {
                int i = this.field_70146_Z.nextInt(3000);
                if (i == 0 && !this.func_70090_H() && this.isNotMoving() && this.canMove() && this.isActive()) {
                    this.func_70661_as().func_75499_g();
                    this.setSitting(true);
                }
                if ((i == 1 || this.func_70090_H()) && this.func_233685_eM_() && this.getCommandInt() < 2) {
                    this.setSitting(false);
                }
                if (i == 2 && this.canMove() && !this.func_70090_H() && !this.func_70631_g_() && !this.func_233685_eM_()) {
                    this.setAnimation(IDLE_STAND);
                }
                if (i > 2980 && !this.func_70090_H() && !this.func_70631_g_()) {
                    this.setAnimation(IDLE_TALK);
                }
            }
        }
        if (this.field_70173_aa % 100 == 0 && this.func_70638_az() != null && this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_ROAR);
        }
        if (this.getAnimation() != NO_ANIMATION) {
            if (this.getAnimation() == ATTACK_BITE && this.getAnimationTick() == 1) {
                this.func_184185_a(ModSounds.ENTITY_ATTACK_BITE, 1.5f, 0.8f);
            }
            if (this.getAnimation() == ATTACK_SWIPE && this.getAnimationTick() == 8) {
                this.func_184185_a(SoundEvents.field_187730_dW, 1.5f, 0.8f);
            }
            if (this.getAnimation() == ATTACK_POUND && this.getAnimationTick() == 10) {
                this.func_70605_aq().func_188488_a(2.0f, 0.0f);
                this.func_184185_a(SoundEvents.field_187730_dW, 1.5f, 0.8f);
            }
            if (this.getAnimation() == ATTACK_MAUL) {
                if (this.getAnimationTick() == 10) {
                    this.func_184185_a(this.getThreatSound(), this.func_70599_aP(), this.func_70647_i());
                }
                if (this.getAnimationTick() == 20) {
                    BlockPos pos;
                    BlockState state;
                    this.func_184185_a(SoundEvents.field_187804_ed, 1.5f, 0.8f);
                    if (!this.field_70170_p.func_201670_d() && !(state = this.field_70170_p.func_180495_p(pos = this.func_233580_cy_().func_177977_b())).addLandingEffects((ServerWorld)this.field_70170_p, pos, state, (LivingEntity)this, 40)) {
                        ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, state), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 40, 0.0, 0.0, 0.0, (double)99.3f);
                    }
                }
            }
            if (this.getAnimation() == ANIMATION_ROAR && this.getAnimationTick() == 7) {
                this.func_184185_a(this.getThreatSound(), this.func_70599_aP(), this.func_70647_i());
            }
            if (this.getAnimation() == IDLE_TALK && this.getAnimationTick() == 1) {
                this.func_184185_a(ModSounds.ENTITY_BEAR_AMBIENT, this.func_70599_aP(), this.func_70647_i());
            }
            if (this.getAnimation() == ANIMATION_EAT && (this.getAnimationTick() == 10 || this.getAnimationTick() == 20 || this.getAnimationTick() == 30)) {
                this.func_184185_a(SoundEvents.field_187711_cp, 1.5f, 0.8f);
            }
        }
        super.func_70636_d();
    }

    protected void func_175544_ck() {
        if (this.func_70909_n()) {
            this.field_70714_bg.func_75776_a(3, (Goal)new SmartFollowOwnerGoal(this, 2.3, 12.0f, 3.0f));
            this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
            this.field_70715_bh.func_75776_a(2, (Goal)new SmartOwnerHurtTargetGoal(this));
        }
    }

    public double func_70042_X() {
        return this.getModelScale() + 0.5f * this.getMobSize();
    }

    @Override
    protected SoundEvent func_184639_G() {
        return !this.func_70631_g_() ? super.func_184639_G() : ModSounds.ENTITY_BEAR_BABY_AMBIENT;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return !this.func_70631_g_() ? super.func_184601_bQ(source) : ModSounds.ENTITY_BEAR_BABY_CRY;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return super.func_184615_bR();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_190030_ev, 0.15f, 1.0f);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        if (flag && this.getAnimation() == NO_ANIMATION && !this.func_70631_g_()) {
            Animation anim = this.chooseAttackAnimation();
            this.setAnimation(anim);
            this.setAnimationTick(0);
        }
        return flag;
    }

    public boolean func_180431_b(DamageSource source) {
        return super.func_180431_b(source) || source == DamageSource.field_220302_v;
    }

    private Animation chooseAttackAnimation() {
        switch (this.field_70146_Z.nextInt(4)) {
            case 0: {
                return ATTACK_SWIPE;
            }
            case 1: {
                return ATTACK_BITE;
            }
            case 2: {
                return ATTACK_MAUL;
            }
        }
        return ATTACK_POUND;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.85f;
    }

    @Override
    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(Hand.MAIN_HAND);
        if (hand == Hand.MAIN_HAND && !this.field_70170_p.func_201670_d() && !this.func_70909_n() && this.func_70631_g_() && EntityUtils.hasFullHealth((LivingEntity)this) && this.func_70877_b(itemstack)) {
            this.func_184185_a(SoundEvents.field_187711_cp, 1.5f, 0.8f);
            if (this.func_70681_au().nextInt(3) == 0) {
                this.func_193101_c(player);
                EntityUtils.spawnParticlesOnEntity(this.field_70170_p, (LivingEntity)this, ParticleTypes.field_197633_z, 3, 6);
            } else {
                EntityUtils.spawnParticlesOnEntity(this.field_70170_p, (LivingEntity)this, ParticleTypes.field_197601_L, 3, 3);
            }
        }
        return super.func_230254_b_(player, hand);
    }

    @Override
    public Animation getAnimationEat() {
        return ANIMATION_EAT;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, ANIMATION_ROAR, IDLE_STAND, IDLE_TALK, ANIMATION_EAT, ATTACK_MAUL, ATTACK_BITE, ATTACK_SWIPE, ATTACK_POUND};
    }

    public boolean isPanda() {
        return EntityBear.getEntityData(this.func_200600_R()).getFlags(this.getVariant(), "isPanda") == 1;
    }

    @Override
    public void updateAttributes() {
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a((double)EntityBear.getEntityData(this.func_200600_R()).getSpeciesData().get(this.getVariant()).getAttack().floatValue());
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)EntityBear.getEntityData(this.func_200600_R()).getSpeciesData().get(this.getVariant()).getHealth().floatValue());
        this.func_70606_j(this.func_110138_aP());
        this.setShortSnout(EntityBear.getEntityData(this.func_200600_R()).getFlags(this.getVariant(), "hasShortSnout") == 1);
        this.setHump(EntityBear.getEntityData(this.func_200600_R()).getFlags(this.getVariant(), "hasHump") == 1);
    }

    public boolean hasShortSnout() {
        return (Boolean)this.field_70180_af.func_187225_a(SHORT_SNOUT);
    }

    private void setShortSnout(boolean short_snout) {
        this.field_70180_af.func_187227_b(SHORT_SNOUT, (Object)short_snout);
    }

    public boolean hasHump() {
        return (Boolean)this.field_70180_af.func_187225_a(BACK_HUMP);
    }

    private void setHump(boolean hump) {
        this.field_70180_af.func_187227_b(BACK_HUMP, (Object)hump);
    }

    @Override
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        ILivingEntityData data = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        if (this.func_226278_cu_() < 53.0) {
            this.setVariant(1);
        }
        return data;
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("hasShortSnout", this.hasShortSnout());
        compound.func_74757_a("hasHump", this.hasHump());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setShortSnout(compound.func_74767_n("hasShortSnout"));
        this.setHump(compound.func_74767_n("hasHump"));
    }
}

