/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.fish;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.entity.PartEntity;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ComplexMobAquatic;
import untamedwilds.entity.INewSkins;
import untamedwilds.entity.ISpecies;
import untamedwilds.entity.ai.SmartMateGoal;
import untamedwilds.init.ModEntity;
import untamedwilds.util.EntityUtils;

public class EntityWhaleShark
extends ComplexMobAquatic
implements ISpecies,
INewSkins {
    public final int length;
    public final EntityWhaleSharkPart[] whale_shark_parts;
    public int ringBufferIndex = -1;
    public final double[][] ringBuffer = new double[64][3];

    public EntityWhaleShark(EntityType<? extends ComplexMob> type, World worldIn) {
        super(type, worldIn);
        this.length = this.getMultiparts();
        this.whale_shark_parts = new EntityWhaleSharkPart[this.length];
        for (int i = 0; i < this.length; ++i) {
            this.whale_shark_parts[i] = new EntityWhaleSharkPart(this, this.func_213311_cf(), this.func_213302_cg());
        }
        this.turn_speed = 0.1f;
    }

    private void setPartPosition(EntityWhaleSharkPart part, double offsetX, double offsetY, double offsetZ) {
        part.func_70107_b(this.func_226277_ct_() + offsetX * (double)part.scale, this.func_226278_cu_() + offsetY * (double)part.scale, this.func_226281_cx_() + offsetZ * (double)part.scale);
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.whale_shark_parts;
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233823_f_, 3.0).func_233815_a_(Attributes.field_233821_d_, 0.8).func_233815_a_(Attributes.field_233819_b_, 12.0).func_233815_a_(Attributes.field_233818_a_, 80.0).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233826_i_, 6.0);
    }

    @Override
    public void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.3, false));
        this.field_70714_bg.func_75776_a(2, (Goal)new SmartMateGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new SmartMateGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new ComplexMobAquatic.SwimGoal(this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82737_E() % 4000L == 0L) {
            this.func_70691_i(1.0f);
        }
        if (!this.func_175446_cd() && !this.func_70631_g_()) {
            if (this.ringBufferIndex < 0) {
                for (int i = 0; i < this.ringBuffer.length; ++i) {
                    this.ringBuffer[i][0] = this.field_70177_z;
                    this.ringBuffer[i][1] = this.func_226278_cu_();
                }
            }
            ++this.ringBufferIndex;
            if (this.ringBufferIndex == this.ringBuffer.length) {
                this.ringBufferIndex = 0;
            }
            this.ringBuffer[this.ringBufferIndex][0] = this.field_70126_B + 0.5f * MathHelper.func_76142_g((float)(this.field_70177_z - this.field_70126_B));
            this.ringBuffer[this.ringBufferIndex][1] = this.func_226278_cu_();
            Vector3d[] avector3d = new Vector3d[this.whale_shark_parts.length];
            for (int j = 0; j < this.whale_shark_parts.length; ++j) {
                this.whale_shark_parts[j].collideWithNearbyEntities();
                avector3d[j] = new Vector3d(this.whale_shark_parts[j].func_226277_ct_(), this.whale_shark_parts[j].func_226278_cu_(), this.whale_shark_parts[j].func_226281_cx_());
            }
            float f15 = (float)(this.getMovementOffsets(5, 1.0f)[1] - this.getMovementOffsets(10, 1.0f)[1]) * 10.0f * ((float)Math.PI / 180);
            float f16 = MathHelper.func_76134_b((float)f15);
            float yaw = this.field_70177_z * ((float)Math.PI / 180);
            float pitch = this.field_70125_A * ((float)Math.PI / 180);
            float f3 = MathHelper.func_76126_a((float)yaw) * (1.0f - Math.abs(this.field_70125_A / 90.0f));
            float f18 = MathHelper.func_76134_b((float)yaw) * (1.0f - Math.abs(this.field_70125_A / 90.0f));
            double[] adouble = this.getMovementOffsets(5, 1.0f);
            for (int k = 0; k < this.getMultiparts(); ++k) {
                EntityWhaleSharkPart whale_shark_part = this.whale_shark_parts[k];
                double[] adouble1 = this.getMovementOffsets(5 + k * 2, 1.0f);
                float f7 = yaw + (float)MathHelper.func_76138_g((double)(adouble1[0] - adouble[0])) * ((float)Math.PI / 180);
                float f20 = MathHelper.func_76126_a((float)f7) * (1.0f - Math.abs(this.field_70125_A / 90.0f));
                float f21 = MathHelper.func_76134_b((float)f7) * (1.0f - Math.abs(this.field_70125_A / 90.0f));
                float f23 = k == 0 ? (float)(k + 3) : (float)((k + 3) * -1);
                float value = MathHelper.func_76131_a((float)(pitch * (float)k), (float)-20.0f, (float)20.0f);
                this.setPartPosition(whale_shark_part, -(f3 * 0.5f + f20 * f23) * f16, value, (f18 * 0.5f + f21 * f23) * f16);
                this.whale_shark_parts[k].field_70169_q = avector3d[k].field_72450_a;
                this.whale_shark_parts[k].field_70167_r = avector3d[k].field_72448_b;
                this.whale_shark_parts[k].field_70166_s = avector3d[k].field_72449_c;
                this.whale_shark_parts[k].field_70142_S = avector3d[k].field_72450_a;
                this.whale_shark_parts[k].field_70137_T = avector3d[k].field_72448_b;
                this.whale_shark_parts[k].field_70136_U = avector3d[k].field_72449_c;
            }
        }
    }

    @Override
    protected SoundEvent getFlopSound() {
        return SoundEvents.field_187684_cg;
    }

    public double[] getMovementOffsets(int offset, float partialTicks) {
        if (this.func_233643_dh_()) {
            partialTicks = 0.0f;
        }
        partialTicks = 1.0f - partialTicks;
        int i = this.ringBufferIndex - offset & 0x3F;
        int j = this.ringBufferIndex - offset - 1 & 0x3F;
        double[] adouble = new double[3];
        double d0 = this.ringBuffer[i][0];
        double d1 = this.ringBuffer[j][0] - d0;
        adouble[0] = d0 + d1 * (double)partialTicks;
        d0 = this.ringBuffer[i][1];
        d1 = this.ringBuffer[j][1] - d0;
        adouble[1] = d0 + d1 * (double)partialTicks;
        adouble[2] = MathHelper.func_219803_d((double)partialTicks, (double)this.ringBuffer[i][2], (double)this.ringBuffer[j][2]);
        return adouble;
    }

    @Override
    public boolean wantsToBreed() {
        if (super.wantsToBreed() && !this.isMobSleeping() && this.func_70874_b() == 0 && EntityUtils.hasFullHealth((LivingEntity)this)) {
            List list = this.field_70170_p.func_217357_a(EntityWhaleShark.class, this.func_174813_aQ().func_72314_b(6.0, 4.0, 6.0));
            list.removeIf(input -> EntityUtils.isInvalidPartner(this, input, false));
            if (list.size() >= 1) {
                this.func_70873_a(this.getPregnancyTime());
                ((EntityWhaleShark)list.get(0)).func_70873_a(this.getPregnancyTime());
                return true;
            }
        }
        return false;
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        return this.create_offspring(new EntityWhaleShark(ModEntity.WHALE_SHARK, this.field_70170_p));
    }

    public boolean attackEntityPartFrom(EntityWhaleSharkPart whale_shark_part, DamageSource source, float amount) {
        return this.func_70097_a(source, amount);
    }

    public int getMultiparts() {
        return 2;
    }

    @Override
    public boolean canBeTargeted() {
        return false;
    }

    public static class EntityWhaleSharkPart
    extends PartEntity<EntityWhaleShark> {
        private final EntitySize size;
        public float scale = 1.0f;

        public EntityWhaleSharkPart(EntityWhaleShark parent, float sizeX, float sizeY) {
            super((Entity)parent);
            this.size = EntitySize.func_220314_b((float)sizeX, (float)sizeY);
            this.func_213323_x_();
        }

        protected void collideWithNearbyEntities() {
            List entities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a((double)0.2f, 0.0, (double)0.2f));
            Entity parent = this.getParent();
            if (parent != null) {
                entities.stream().filter(entity -> entity != parent && (!(entity instanceof EntityWhaleSharkPart) || ((EntityWhaleSharkPart)((Object)entity)).getParent() != parent) && entity.func_70104_M()).forEach(entity -> entity.func_70108_f(parent));
            }
        }

        public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
            return this.getParent() == null ? ActionResultType.PASS : ((EntityWhaleShark)this.getParent()).func_230254_b_(player, hand);
        }

        public void func_70108_f(Entity entityIn) {
            entityIn.func_70108_f((Entity)this);
        }

        public boolean func_70067_L() {
            return true;
        }

        protected void func_70037_a(CompoundNBT compound) {
        }

        protected void func_213281_b(CompoundNBT compound) {
        }

        protected void func_70088_a() {
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            return !this.func_180431_b(source) && ((EntityWhaleShark)this.getParent()).attackEntityPartFrom(this, source, amount);
        }

        public boolean func_70028_i(Entity entityIn) {
            return this == entityIn || this.getParent() == entityIn;
        }

        public IPacket<?> func_213297_N() {
            throw new UnsupportedOperationException();
        }

        public EntitySize func_213305_a(Pose poseIn) {
            return this.size.func_220313_a(this.scale);
        }
    }
}

