/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.fish;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ComplexMobAquatic;
import untamedwilds.entity.INeedsPostUpdate;
import untamedwilds.entity.INewSkins;
import untamedwilds.entity.ISpecies;
import untamedwilds.entity.ai.SmartMeleeAttackGoal;
import untamedwilds.entity.ai.target.HuntMobTarget;
import untamedwilds.util.EntityUtils;

public class EntityFootballFish
extends ComplexMobAquatic
implements ISpecies,
INewSkins,
INeedsPostUpdate {
    private static final DataParameter<Boolean> HAS_MALE = EntityDataManager.func_187226_a(EntityFootballFish.class, (IDataSerializer)DataSerializers.field_187198_h);

    public EntityFootballFish(EntityType<? extends ComplexMob> type, World worldIn) {
        super(type, worldIn);
        this.field_70180_af.func_187214_a(HAS_MALE, (Object)false);
        this.field_70728_aV = 2;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233823_f_, 3.0).func_233815_a_(Attributes.field_233821_d_, 0.42).func_233815_a_(Attributes.field_233819_b_, 8.0).func_233815_a_(Attributes.field_233818_a_, 8.0).func_233815_a_(Attributes.field_233820_c_, 0.0).func_233815_a_(Attributes.field_233826_i_, 2.0);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SmartMeleeAttackGoal((CreatureEntity)this, 1.8, false, 2.0f));
        this.field_70714_bg.func_75776_a(2, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(4, (Goal)new ComplexMobAquatic.SwimGoal(this, 4));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, new HuntMobTarget<LivingEntity>(this, LivingEntity.class, true, false, input -> EntityFootballFish.getEcoLevel(input) < 5));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70173_aa % 1000 == 0) {
                if (this.wantsToBreed() && !this.isMale()) {
                    this.breed();
                }
                if (!this.hasAttachedMale() && this.field_70146_Z.nextInt(40) == 0 && this.func_226278_cu_() < 42.0) {
                    this.setAttachedMale(true);
                }
            }
            if (this.field_70170_p.func_82737_E() % 4000L == 0L) {
                this.func_70691_i(1.0f);
            }
        }
    }

    @Override
    public boolean wantsToBreed() {
        if (((Boolean)ConfigGamerules.naturalBreeding.get()).booleanValue() && this.hasAttachedMale() && this.func_70874_b() == 0 && EntityUtils.hasFullHealth((LivingEntity)this)) {
            BlockPos.Mutable blockPos = new BlockPos.Mutable();
            for (int i = 0; i <= 16; ++i) {
                BlockState state = this.field_70170_p.func_180495_p((BlockPos)blockPos.func_189532_c(this.func_226277_ct_(), this.func_226278_cu_() + (double)i, this.func_226281_cx_()));
                if (state.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a)) continue;
                return false;
            }
            this.func_70873_a(this.func_70874_b());
            return true;
        }
        return false;
    }

    @Override
    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(Hand.MAIN_HAND);
        if (hand == Hand.MAIN_HAND && !this.field_70170_p.func_201670_d() && this.hasAttachedMale() && itemstack.func_77973_b() == Items.field_151097_aZ) {
            this.func_184185_a(SoundEvents.field_187763_eJ, 1.5f, 0.8f);
            this.setAttachedMale(false);
            this.func_70097_a(DamageSource.func_76358_a((LivingEntity)player), 1.0f);
        }
        return super.func_230254_b_(player, hand);
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        if (!this.hasAttachedMale()) {
            this.setAttachedMale(true);
        }
        EntityUtils.dropEggs(this, "egg_football_fish", this.getOffspring());
        return null;
    }

    @Override
    protected SoundEvent getFlopSound() {
        return SoundEvents.field_187684_cg;
    }

    @Override
    public void updateAttributes() {
        this.setGender(1);
        if (this.field_70146_Z.nextInt(3) == 0) {
            this.setAttachedMale(true);
        }
    }

    public boolean hasAttachedMale() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_MALE);
    }

    private void setAttachedMale(boolean attachedMale) {
        this.field_70180_af.func_187227_b(HAS_MALE, (Object)attachedMale);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("hasMale", this.hasAttachedMale());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setAttachedMale(compound.func_74767_n("hasMale"));
    }
}

