/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai.unique;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.util.math.AxisAlignedBB;
import untamedwilds.entity.ComplexMobTerrestrial;

public class PandaEatBamboo
extends Goal {
    private final ComplexMobTerrestrial taskOwner;
    private final Sorter sorter;
    private final int executionChance;
    private final int distance;
    private ItemEntity targetItem;
    private Item targetItemStack;

    public PandaEatBamboo(ComplexMobTerrestrial creature, int chance, int distance) {
        this.taskOwner = creature;
        this.executionChance = chance;
        this.sorter = new Sorter((Entity)creature);
        this.distance = distance;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET));
    }

    public boolean func_75250_a() {
        if (this.taskOwner.getHunger() > 80 || this.taskOwner.func_70631_g_() || this.taskOwner.isMobSleeping()) {
            return false;
        }
        if (this.taskOwner.func_70681_au().nextInt(this.executionChance) != 0) {
            return false;
        }
        List list = this.taskOwner.field_70170_p.func_217357_a(ItemEntity.class, this.getTargetableArea(this.distance));
        list.removeIf(item -> item.func_92059_d().func_77973_b().equals("bamboo"));
        if (list.isEmpty()) {
            return false;
        }
        list.sort(this.sorter);
        this.targetItem = (ItemEntity)list.get(0);
        this.targetItemStack = this.targetItem.func_92059_d().func_77973_b();
        return true;
    }

    private AxisAlignedBB getTargetableArea(double targetDistance) {
        return this.taskOwner.func_174813_aQ().func_72314_b(targetDistance, 4.0, targetDistance);
    }

    public void func_75249_e() {
        this.taskOwner.func_70661_as().func_75492_a(this.targetItem.func_226277_ct_(), this.targetItem.func_226278_cu_(), this.targetItem.func_226281_cx_(), 1.0);
    }

    public boolean func_75253_b() {
        if (this.targetItem == null || !this.targetItem.func_70089_S()) {
            return false;
        }
        if (this.taskOwner.func_233685_eM_()) {
            return false;
        }
        return !this.taskOwner.func_70781_l();
    }

    public void func_75246_d() {
        double distance = Math.sqrt(Math.pow(this.taskOwner.func_226277_ct_() - this.targetItem.func_226277_ct_(), 2.0) + Math.pow(this.taskOwner.func_226281_cx_() - this.targetItem.func_226281_cx_(), 2.0));
        if (distance < 1.5) {
            this.taskOwner.addHunger(10);
            this.targetItem.func_92059_d().func_190918_g(1);
            if (this.targetItem.func_92059_d().func_190916_E() == 0) {
                this.targetItem.func_70106_y();
            }
            this.taskOwner.setAnimation(this.taskOwner.getAnimationEat());
        }
        if (this.taskOwner.func_70661_as().func_75500_f()) {
            this.func_75251_c();
        }
        this.taskOwner.func_70661_as().func_75492_a(this.targetItem.func_226277_ct_(), this.targetItem.func_226278_cu_(), this.targetItem.func_226281_cx_(), 1.0);
    }

    public static class Sorter
    implements Comparator<Entity> {
        private final Entity entity;

        private Sorter(Entity entityIn) {
            this.entity = entityIn;
        }

        @Override
        public int compare(Entity entity_1, Entity entity_2) {
            double dist_2;
            double dist_1 = this.entity.func_70068_e(entity_1);
            if (dist_1 < (dist_2 = this.entity.func_70068_e(entity_2))) {
                return -1;
            }
            return dist_1 > dist_2 ? 1 : 0;
        }
    }
}

