/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai.unique;

import com.mojang.datafixers.util.Pair;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import untamedwilds.entity.mammal.EntityBear;

public class BearRaidChestsGoal
extends Goal {
    private IInventory targetInventory;
    private BlockPos targetPos;
    private final EntityBear taskOwner;
    private final int executionChance;
    private int searchCooldown;
    private boolean continueTask;

    public BearRaidChestsGoal(EntityBear entityIn, int chance) {
        this.taskOwner = entityIn;
        this.executionChance = chance;
        this.searchCooldown = 100;
        this.continueTask = true;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if (this.taskOwner.func_70909_n() || !this.taskOwner.func_233570_aj_() || this.taskOwner.getHunger() > 60 || this.taskOwner.func_70681_au().nextInt(this.executionChance) != 0 || this.taskOwner.func_70638_az() != null) {
            return false;
        }
        BlockPos pos = this.taskOwner.func_233580_cy_();
        this.targetPos = this.getNearbyInventories(pos);
        return this.targetPos != null;
    }

    public void func_75249_e() {
        this.taskOwner.func_70661_as().func_75492_a((double)this.targetPos.func_177958_n() + 0.5, (double)(this.targetPos.func_177956_o() + 1), (double)this.targetPos.func_177952_p() + 0.5, 1.0);
        super.func_75249_e();
    }

    public void func_75251_c() {
        super.func_75251_c();
    }

    public void func_75246_d() {
        if (this.targetPos != null && this.taskOwner.func_70092_e(this.targetPos.func_177958_n(), this.targetPos.func_177956_o(), this.targetPos.func_177952_p()) < 4.0) {
            this.taskOwner.func_70671_ap().func_75650_a((double)this.targetPos.func_177958_n(), (double)((float)this.targetPos.func_177956_o() + 1.5f), (double)this.targetPos.func_177952_p(), 10.0f, (float)this.taskOwner.func_70646_bf());
            this.taskOwner.func_70661_as().func_75499_g();
            this.taskOwner.setSitting(true);
            --this.searchCooldown;
            if (this.taskOwner.field_70170_p.func_175625_s(this.targetPos) instanceof ChestTileEntity) {
                ChestTileEntity chest = (ChestTileEntity)this.taskOwner.field_70170_p.func_175625_s(this.targetPos);
                this.taskOwner.field_70170_p.func_175641_c(this.targetPos, chest.func_195044_w().func_177230_c(), 1, 1);
            }
            if (this.searchCooldown == 0) {
                this.searchCooldown = 100;
                this.continueTask = this.stealItem();
            }
        }
        super.func_75246_d();
    }

    public boolean func_75253_b() {
        if (this.taskOwner.getHunger() >= 60 || this.targetInventory.func_191420_l()) {
            this.taskOwner.setSitting(false);
            if (this.taskOwner.field_70170_p.func_175625_s(this.targetPos) instanceof ChestTileEntity) {
                ChestTileEntity chest = (ChestTileEntity)this.taskOwner.field_70170_p.func_175625_s(this.targetPos);
                this.taskOwner.field_70170_p.func_175641_c(this.targetPos, chest.func_195044_w().func_177230_c(), 1, 0);
            }
            return false;
        }
        return this.continueTask;
    }

    private boolean stealItem() {
        block16: {
            if (this.targetInventory == null) break block16;
            Direction enumfacing = Direction.DOWN;
            if (BearRaidChestsGoal.isInventoryEmpty(this.targetInventory, enumfacing)) {
                return false;
            }
            if (this.targetInventory instanceof ISidedInventory) {
                int[] aint;
                ISidedInventory isidedinventory = (ISidedInventory)this.targetInventory;
                for (int i : aint = isidedinventory.func_180463_a(enumfacing)) {
                    ItemStack itemstack = this.targetInventory.func_70301_a(i);
                    if (itemstack.func_190926_b() || !BearRaidChestsGoal.canExtractItemFromSlot(this.targetInventory, itemstack, i, enumfacing)) continue;
                    ItemStack itemstack1 = itemstack.func_77946_l();
                    this.targetInventory.func_70299_a(i, ItemStack.field_190927_a);
                    if (itemstack1.func_77973_b().func_219971_r()) {
                        this.taskOwner.func_184185_a(SoundEvents.field_187739_dZ, 1.0f, 1.0f);
                        this.taskOwner.addHunger(itemstack1.func_77973_b().func_219967_s().func_221466_a() * 10 * itemstack1.func_190916_E());
                        for (Pair pair : itemstack1.func_77973_b().func_219967_s().func_221464_f()) {
                            if (pair.getFirst() == null || !(this.taskOwner.field_70170_p.field_73012_v.nextFloat() < ((Float)pair.getSecond()).floatValue())) continue;
                            this.taskOwner.func_195064_c(new EffectInstance((EffectInstance)pair.getFirst()));
                        }
                        return false;
                    }
                    if (itemstack1.func_77973_b().func_77636_d(itemstack1)) {
                        this.taskOwner.func_184185_a(SoundEvents.field_187739_dZ, 1.0f, 1.0f);
                        this.taskOwner.addHunger(10);
                        for (EffectInstance effectinstance : PotionUtils.func_185189_a((ItemStack)itemstack1)) {
                            if (effectinstance.func_188419_a().func_76403_b()) {
                                effectinstance.func_188419_a().func_180793_a((Entity)this.taskOwner, (Entity)this.taskOwner, (LivingEntity)this.taskOwner, effectinstance.func_76458_c(), 1.0);
                                continue;
                            }
                            this.taskOwner.func_195064_c(new EffectInstance(effectinstance));
                        }
                        return false;
                    }
                    this.taskOwner.func_70099_a(itemstack, 0.2f);
                    return true;
                }
            } else {
                int j = this.targetInventory.func_70302_i_();
                for (int k = 0; k < j; ++k) {
                    ItemStack itemstack = this.targetInventory.func_70301_a(k);
                    if (itemstack.func_190926_b() || !BearRaidChestsGoal.canExtractItemFromSlot(this.targetInventory, itemstack, k, enumfacing)) continue;
                    ItemStack itemstack1 = itemstack.func_77946_l();
                    this.targetInventory.func_70299_a(k, ItemStack.field_190927_a);
                    this.taskOwner.setAnimation(EntityBear.ATTACK_SWIPE);
                    if (itemstack1.func_77973_b().func_219971_r()) {
                        this.taskOwner.func_184185_a(SoundEvents.field_187739_dZ, 1.0f, 1.0f);
                        this.taskOwner.addHunger(itemstack1.func_77973_b().func_219967_s().func_221466_a() * 10 * itemstack1.func_190916_E());
                        for (Pair pair : itemstack1.func_77973_b().func_219967_s().func_221464_f()) {
                            if (pair.getFirst() == null || !(this.taskOwner.field_70170_p.field_73012_v.nextFloat() < ((Float)pair.getSecond()).floatValue())) continue;
                            this.taskOwner.func_195064_c(new EffectInstance((EffectInstance)pair.getFirst()));
                        }
                        return false;
                    }
                    if (itemstack1.func_77973_b().func_77636_d(itemstack1)) {
                        this.taskOwner.func_184185_a(SoundEvents.field_187664_bz, 1.0f, 1.0f);
                        this.taskOwner.addHunger(10);
                        for (EffectInstance effectinstance : PotionUtils.func_185189_a((ItemStack)itemstack1)) {
                            if (effectinstance.func_188419_a().func_76403_b()) {
                                effectinstance.func_188419_a().func_180793_a((Entity)this.taskOwner, (Entity)this.taskOwner, (LivingEntity)this.taskOwner, effectinstance.func_76458_c(), 1.0);
                                continue;
                            }
                            this.taskOwner.func_195064_c(new EffectInstance(effectinstance));
                        }
                        return false;
                    }
                    if (itemstack1.func_77973_b().func_219971_r() && itemstack1.func_77973_b().func_77636_d(itemstack1)) {
                        this.taskOwner.func_184185_a(SoundEvents.field_187739_dZ, 1.0f, 1.0f);
                        return false;
                    }
                    this.taskOwner.func_70099_a(itemstack, 0.2f);
                    return true;
                }
            }
        }
        return false;
    }

    private static IInventory getInventoryAtPosition(World worldIn, BlockPos pos) {
        TileEntity tileentity;
        IInventory iinventory = null;
        BlockState state = worldIn.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block.hasTileEntity(state) && (tileentity = worldIn.func_175625_s(pos)) instanceof IInventory) {
            iinventory = (IInventory)tileentity;
        }
        return iinventory;
    }

    private static boolean isInventoryEmpty(IInventory inventoryIn, Direction side) {
        if (inventoryIn instanceof ISidedInventory) {
            int[] aint;
            ISidedInventory isidedinventory = (ISidedInventory)inventoryIn;
            for (int i : aint = isidedinventory.func_180463_a(side)) {
                if (isidedinventory.func_70301_a(i).func_190926_b()) continue;
                return false;
            }
        } else {
            int j = inventoryIn.func_70302_i_();
            for (int k = 0; k < j; ++k) {
                if (inventoryIn.func_70301_a(k).func_190926_b()) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean canExtractItemFromSlot(IInventory inventoryIn, ItemStack stack, int index, Direction side) {
        return !(inventoryIn instanceof ISidedInventory) || ((ISidedInventory)inventoryIn).func_180461_b(index, stack, side);
    }

    private BlockPos getNearbyInventories(BlockPos roomCenter) {
        int X = 15;
        int Y = 3;
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)roomCenter.func_177982_a(-X, -Y, -X), (BlockPos)roomCenter.func_177982_a(X, Y, X))) {
            if (this.taskOwner.field_70170_p.func_175625_s(blockpos) == null || BearRaidChestsGoal.getInventoryAtPosition(this.taskOwner.field_70170_p, blockpos) == null || BearRaidChestsGoal.isInventoryEmpty(BearRaidChestsGoal.getInventoryAtPosition(this.taskOwner.field_70170_p, blockpos), Direction.UP)) continue;
            this.targetInventory = BearRaidChestsGoal.getInventoryAtPosition(this.taskOwner.field_70170_p, blockpos);
            return blockpos;
        }
        return null;
    }
}

