/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai.target;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.TargetGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.util.math.AxisAlignedBB;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ComplexMobTerrestrial;

public class HuntMobTarget<T extends LivingEntity>
extends TargetGoal {
    protected final Class<T> targetClass;
    protected final Sorter sorter;
    protected Predicate<? super T> targetEntitySelector;
    protected T targetEntity;
    private final int threshold;
    private final boolean isCannibal;

    public HuntMobTarget(ComplexMob creature, Class<T> classTarget, boolean checkSight, boolean isCannibal, Predicate<? super T> targetSelector) {
        this(creature, classTarget, checkSight, 200, isCannibal, targetSelector);
    }

    public HuntMobTarget(ComplexMob creature, Class<T> classTarget, boolean checkSight, int hungerThreshold, boolean isCannibal, Predicate<? super T> targetSelector) {
        super((MobEntity)creature, checkSight, true);
        this.targetClass = classTarget;
        this.sorter = new Sorter((Entity)creature);
        this.func_220684_a(EnumSet.of(Goal.Flag.TARGET));
        this.threshold = hungerThreshold;
        this.isCannibal = isCannibal;
        this.targetEntitySelector = entity -> {
            if (targetSelector != null && !targetSelector.test(entity)) {
                return false;
            }
            return this.func_220777_a((LivingEntity)entity, EntityPredicate.field_221016_a);
        };
    }

    public boolean func_75250_a() {
        if (this.field_75299_d.func_70631_g_() || this.field_75299_d.func_110143_aJ() < this.field_75299_d.func_110138_aP() / 3.0f) {
            return false;
        }
        if (this.field_75299_d instanceof ComplexMob) {
            ComplexMobTerrestrial temp;
            if (((ComplexMob)this.field_75299_d).peacefulTicks != 0) {
                return false;
            }
            if (this.field_75299_d instanceof ComplexMobTerrestrial && ((temp = (ComplexMobTerrestrial)this.field_75299_d).func_70909_n() || temp.getHunger() > this.threshold)) {
                return false;
            }
        }
        List list = this.field_75299_d.field_70170_p.func_175647_a(this.targetClass, this.getTargetableArea(this.func_111175_f()), this.targetEntitySelector);
        list.removeIf(this::shouldRemoveTarget);
        if (list.isEmpty()) {
            return false;
        }
        list.sort(this.sorter);
        this.targetEntity = (LivingEntity)list.get(0);
        if (this.field_75299_d instanceof ComplexMob) {
            ((ComplexMob)this.field_75299_d).peacefulTicks = 6000;
        }
        return true;
    }

    AxisAlignedBB getTargetableArea(double targetDistance) {
        return this.field_75299_d.func_174813_aQ().func_72314_b(targetDistance, 4.0, targetDistance);
    }

    public void func_75249_e() {
        this.field_75299_d.func_70624_b(this.targetEntity);
        super.func_75249_e();
    }

    public boolean shouldRemoveTarget(LivingEntity entity) {
        if (entity instanceof CreeperEntity) {
            return false;
        }
        if (!this.isCannibal && entity instanceof ComplexMob) {
            ComplexMob ctarget = (ComplexMob)entity;
            return this.field_75299_d.getClass() == entity.getClass() && ((ComplexMob)this.field_75299_d).getVariant() == ctarget.getVariant() || !ctarget.canBeTargeted();
        }
        return false;
    }

    public static class Sorter
    implements Comparator<Entity> {
        private final Entity entity;

        private Sorter(Entity entityIn) {
            this.entity = entityIn;
        }

        @Override
        public int compare(Entity entity_1, Entity entity_2) {
            double dist_2;
            double dist_1 = this.entity.func_70068_e(entity_1);
            if (dist_1 < (dist_2 = this.entity.func_70068_e(entity_2))) {
                return -1;
            }
            return dist_1 > dist_2 ? 1 : 0;
        }
    }
}

