/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai.target;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.TargetGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.util.EntityPredicates;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ISpecies;

public class DontThreadOnMeTarget<T extends LivingEntity>
extends TargetGoal {
    protected final Class<T> targetClass;
    protected final int targetChance;
    protected LivingEntity nearestTarget;
    protected Predicate<T> targetEntitySelector;

    public DontThreadOnMeTarget(MobEntity entityIn, Class<T> targetClassIn, boolean checkSight) {
        this(entityIn, targetClassIn, checkSight, false);
    }

    public DontThreadOnMeTarget(MobEntity entityIn, Class<T> targetClassIn, boolean checkSight, boolean nearbyOnlyIn) {
        this(entityIn, targetClassIn, 6, checkSight, nearbyOnlyIn);
    }

    public DontThreadOnMeTarget(MobEntity entityIn, Class<T> targetClassIn, int targetChanceIn, boolean checkSight, boolean nearbyOnlyIn) {
        super(entityIn, checkSight, nearbyOnlyIn);
        this.targetClass = targetClassIn;
        this.targetChance = targetChanceIn;
        this.func_220684_a(EnumSet.of(Goal.Flag.TARGET));
        this.targetEntitySelector = entity -> {
            if (entity instanceof CreeperEntity) {
                return false;
            }
            if (this.field_75299_d.getClass() == entity.getClass()) {
                if (this.field_75299_d instanceof ISpecies && entity instanceof ISpecies) {
                    ComplexMob attacker = (ComplexMob)this.field_75299_d;
                    ComplexMob defender = (ComplexMob)((Object)entity);
                    if (attacker.getVariant() == defender.getVariant()) {
                        return false;
                    }
                }
                return false;
            }
            return EntityPredicates.field_180132_d.test(entity) && this.func_220777_a((LivingEntity)entity, EntityPredicate.field_221016_a);
        };
    }

    public boolean func_75250_a() {
        if (!((Boolean)ConfigGamerules.contactAgression.get()).booleanValue() || this.field_75299_d.func_70681_au().nextInt(this.targetChance) != 0 || this.field_75299_d.func_70661_as().func_75500_f()) {
            return false;
        }
        List list = this.field_75299_d.field_70170_p.func_175647_a(this.targetClass, this.field_75299_d.func_174813_aQ(), this.targetEntitySelector);
        if (list.isEmpty()) {
            return false;
        }
        this.nearestTarget = (LivingEntity)list.get(0);
        return true;
    }

    public void func_75249_e() {
        this.field_75299_d.func_70624_b(this.nearestTarget);
        super.func_75249_e();
    }
}

