/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai;

import java.util.EnumSet;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.vector.Vector3d;
import untamedwilds.entity.ComplexMobTerrestrial;
import untamedwilds.entity.IPackEntity;

public class SmartWanderGoal
extends Goal {
    public final ComplexMobTerrestrial creature;
    protected double x;
    protected double y;
    protected double z;
    private final int runChance;
    private final int executionChance;
    private final boolean avoidWater;
    private final double speed;

    public SmartWanderGoal(ComplexMobTerrestrial entityIn, double speedIn) {
        this(entityIn, speedIn, 120, 0, false);
    }

    public SmartWanderGoal(ComplexMobTerrestrial entityIn, double speedIn, boolean avoidWater) {
        this(entityIn, speedIn, 120, 0, avoidWater);
    }

    public SmartWanderGoal(ComplexMobTerrestrial entityIn, double speedIn, int runChance, boolean avoidWater) {
        this(entityIn, speedIn, 120, runChance, avoidWater);
    }

    public SmartWanderGoal(ComplexMobTerrestrial entityIn, double speedIn, int chance, int runChance, boolean avoidWater) {
        this.creature = entityIn;
        this.speed = speedIn;
        this.executionChance = this.creature.isActive() ? chance : chance * 5;
        this.runChance = runChance;
        this.avoidWater = avoidWater;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if (this.creature.func_184207_aI() || !this.creature.canMove() || !this.creature.func_70661_as().func_75500_f() || this.creature.getCommandInt() != 0) {
            return false;
        }
        if (this.creature.func_70681_au().nextInt(this.executionChance) != 0) {
            return false;
        }
        Vector3d vec3d = this.getPosition();
        if (vec3d == null) {
            return false;
        }
        this.x = vec3d.field_72450_a;
        this.y = vec3d.field_72448_b;
        this.z = vec3d.field_72449_c;
        return true;
    }

    private Vector3d getPosition() {
        if (this.creature instanceof IPackEntity && this.creature.herd != null && this.creature.herd.getLeader() != this.creature) {
            Vector3d vec3d = RandomPositionGenerator.func_191377_b((CreatureEntity)this.creature.herd.getLeader(), (int)7, (int)3);
            return vec3d == null ? RandomPositionGenerator.func_75463_a((CreatureEntity)this.creature.herd.getLeader(), (int)5, (int)2) : vec3d;
        }
        if (this.avoidWater) {
            Vector3d vec3d = RandomPositionGenerator.func_191377_b((CreatureEntity)this.creature, (int)15, (int)7);
            return vec3d == null ? RandomPositionGenerator.func_75463_a((CreatureEntity)this.creature, (int)10, (int)4) : vec3d;
        }
        return RandomPositionGenerator.func_75463_a((CreatureEntity)this.creature, (int)10, (int)4);
    }

    public boolean func_75253_b() {
        return !this.creature.func_70661_as().func_75500_f();
    }

    public void func_75249_e() {
        this.creature.func_70661_as().func_75492_a(this.x, this.y, this.z, this.speed * (double)(this.creature.func_70681_au().nextInt(100) < this.runChance ? 1.8f : 1.0f));
    }
}

