/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai;

import java.util.EnumSet;
import java.util.Optional;
import java.util.Random;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.potion.Effects;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import untamedwilds.util.EntityUtils;

public class SmartMeleeAttackGoal
extends Goal {
    protected final CreatureEntity attacker;
    protected int attackTick;
    private final double speedTowardsTarget;
    private final boolean longMemory;
    private Path path;
    private int delayCounter;
    private double targetX;
    private double targetY;
    private double targetZ;
    private float extraReach;
    private long field_220720_k;
    private int failedPathFindingPenalty = 0;
    private boolean canPenalize = false;
    private final boolean doSkirmish;
    private final boolean isJumper;

    public SmartMeleeAttackGoal(CreatureEntity entityIn, double speedIn, boolean useLongMemory) {
        this(entityIn, speedIn, useLongMemory, 0.0f, false, false);
    }

    public SmartMeleeAttackGoal(CreatureEntity entityIn, double speedIn, boolean useLongMemory, float reach) {
        this(entityIn, speedIn, useLongMemory, reach, false, false);
    }

    public SmartMeleeAttackGoal(CreatureEntity entityIn, double speedIn, boolean useLongMemory, float reach, boolean doSkirmish, boolean isJumper) {
        this.attacker = entityIn;
        this.speedTowardsTarget = speedIn;
        this.longMemory = useLongMemory;
        this.extraReach = reach;
        this.doSkirmish = doSkirmish;
        this.isJumper = isJumper;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        if (this.attacker.func_70631_g_() || this.doSkirmish && !EntityUtils.hasFullHealth((LivingEntity)this.attacker)) {
            return false;
        }
        long i = this.attacker.field_70170_p.func_82737_E();
        if (i - this.field_220720_k < 20L) {
            return false;
        }
        this.field_220720_k = i;
        LivingEntity livingentity = this.attacker.func_70638_az();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.func_70089_S()) {
            return false;
        }
        if (this.canPenalize) {
            if (--this.delayCounter <= 0) {
                this.path = this.attacker.func_70661_as().func_75494_a((Entity)livingentity, 0);
                this.delayCounter = 4 + this.attacker.func_70681_au().nextInt(7);
                return this.path != null;
            }
            return true;
        }
        this.path = this.attacker.func_70661_as().func_75494_a((Entity)livingentity, 0);
        return this.path != null;
    }

    public boolean func_75253_b() {
        LivingEntity livingentity = this.attacker.func_70638_az();
        if (livingentity == null || this.attacker.func_70086_ai() < 40 && !this.attacker.func_70648_aU() || !livingentity.func_70089_S()) {
            return false;
        }
        if (!this.longMemory) {
            return !this.attacker.func_70661_as().func_75500_f();
        }
        if (!this.attacker.func_213389_a(livingentity.func_233580_cy_())) {
            return false;
        }
        return !(livingentity instanceof PlayerEntity) || !livingentity.func_175149_v() && !((PlayerEntity)livingentity).func_184812_l_();
    }

    public void func_75249_e() {
        this.attacker.func_70661_as().func_75484_a(this.path, this.speedTowardsTarget);
        this.attacker.func_213395_q(true);
        this.delayCounter = 0;
    }

    public void func_75251_c() {
        LivingEntity livingentity = this.attacker.func_70638_az();
        if (!EntityPredicates.field_188444_d.test(livingentity)) {
            this.attacker.func_70624_b(null);
        }
        this.attacker.func_213395_q(false);
        this.attacker.func_70661_as().func_75499_g();
    }

    public void func_75246_d() {
        LivingEntity livingentity = this.attacker.func_70638_az();
        this.attacker.func_70671_ap().func_220674_a(livingentity.func_213303_ch());
        double d0 = this.attacker.func_70092_e(livingentity.func_226277_ct_(), livingentity.func_174813_aQ().field_72338_b, livingentity.func_226281_cx_());
        --this.delayCounter;
        if (this.attacker.func_70090_H() && this.attacker.field_70173_aa % 12 == 0 && livingentity.func_174813_aQ().field_72338_b - 2.0 > this.attacker.func_226278_cu_()) {
            this.attacker.func_70683_ar().func_75660_a();
        }
        if ((this.longMemory || this.attacker.func_70635_at().func_75522_a((Entity)livingentity)) && this.delayCounter <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || livingentity.func_70092_e(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.attacker.func_70681_au().nextFloat() < 0.05f)) {
            this.targetX = livingentity.func_226277_ct_();
            this.targetY = livingentity.func_174813_aQ().field_72338_b;
            this.targetZ = livingentity.func_226281_cx_();
            this.delayCounter = 4 + this.attacker.func_70681_au().nextInt(7);
            if (this.canPenalize) {
                PathPoint finalPathPoint;
                this.delayCounter += this.failedPathFindingPenalty;
                this.failedPathFindingPenalty = this.attacker.func_70661_as().func_75505_d() != null ? ((finalPathPoint = this.attacker.func_70661_as().func_75505_d().func_75870_c()) != null && livingentity.func_70092_e((double)finalPathPoint.field_75839_a, (double)finalPathPoint.field_75837_b, (double)finalPathPoint.field_75838_c) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
            }
            if (d0 > 1024.0) {
                this.delayCounter += 10;
            } else if (d0 > 256.0) {
                this.delayCounter += 5;
            }
            if (!this.attacker.func_70661_as().func_75497_a((Entity)livingentity, this.speedTowardsTarget)) {
                this.delayCounter += 15;
            }
        }
        BlockPos testpos = this.attacker.func_233580_cy_().func_177963_a(Math.cos(Math.toRadians(this.attacker.field_70177_z + 90.0f)) * 1.2, 0.0, Math.sin(Math.toRadians(this.attacker.field_70177_z + 90.0f)) * 1.2);
        if (this.isJumper && this.attacker.func_233570_aj_() && this.attacker.func_130014_f_().func_180495_p(testpos.func_177977_b()).func_196958_f() && this.attacker.func_130014_f_().func_180495_p(testpos.func_177979_c(2)).func_196958_f() && this.attacker.func_70635_at().func_75522_a((Entity)livingentity)) {
            BlockPos targetpos = this.attacker.func_233580_cy_().func_177963_a(Math.cos(Math.toRadians(this.attacker.field_70177_z + 90.0f)) * 5.0, 0.0, Math.sin(Math.toRadians(this.attacker.field_70177_z + 90.0f)) * 5.0);
            Vector3d vector3d = new Vector3d((double)targetpos.func_177958_n(), (double)targetpos.func_177956_o(), (double)targetpos.func_177952_p());
            if (vector3d.func_72438_d(livingentity.func_213303_ch()) < this.attacker.func_213303_ch().func_72438_d(livingentity.func_213303_ch())) {
                Random rand = this.attacker.func_70681_au();
                for (int i = 0; i < 4; ++i) {
                    Optional<Vector3d> jump_vec;
                    targetpos.func_177982_a(rand.nextInt(2) - 1, rand.nextInt(2) - 1, rand.nextInt(2) - 1);
                    if (!this.attacker.func_70661_as().func_188555_b(targetpos) || !(jump_vec = this.calculateOptimalJumpVector(this.attacker, Vector3d.func_237489_a_((Vector3i)targetpos))).isPresent()) continue;
                    double d1 = jump_vec.get().func_72433_c();
                    double d2 = 1.0 + d1 + (this.attacker.func_70644_a(Effects.field_76430_j) ? (double)(0.1f * (float)(this.attacker.func_70660_b(Effects.field_76430_j).func_76458_c() + 1)) : 0.0);
                    this.attacker.func_213293_j(jump_vec.get().field_72450_a * d2 / d1, jump_vec.get().field_72448_b, jump_vec.get().field_72449_c * d2 / d1);
                    this.attacker.func_70661_as().func_75499_g();
                }
            }
        }
        this.attackTick = Math.max(this.attackTick - 1, 0);
        this.checkAndPerformAttack(livingentity, d0);
    }

    protected void checkAndPerformAttack(LivingEntity enemy, double distToEnemySqr) {
        double d0 = this.getAttackReachSqr(enemy);
        if (this.attacker.func_70685_l((Entity)enemy) && distToEnemySqr <= d0 && this.attackTick <= 0) {
            this.attackTick = 20;
            this.attacker.func_70652_k((Entity)enemy);
        }
    }

    protected double getAttackReachSqr(LivingEntity attackTarget) {
        return this.attacker.func_213311_cf() * 2.0f * this.attacker.func_213311_cf() * 2.0f + attackTarget.func_213311_cf() + this.extraReach;
    }

    private Optional<Vector3d> calculateOptimalJumpVector(CreatureEntity entityIn, Vector3d targetVector) {
        Optional<Vector3d> optional = Optional.empty();
        for (int i = 20; i < 55; i += 5) {
            Optional<Vector3d> optional1 = this.calculateJumpVectorForAngle(entityIn, targetVector, i);
            if (optional.isPresent() && (!optional1.isPresent() || !(optional1.get().func_189985_c() < optional.get().func_189985_c()))) continue;
            optional = optional1;
        }
        return optional;
    }

    private Optional<Vector3d> calculateJumpVectorForAngle(CreatureEntity entityIn, Vector3d targetVector, int upwardsAngle) {
        Vector3d Vector3d2 = entityIn.func_213303_ch();
        Vector3d Vector3d1 = new Vector3d(targetVector.field_72450_a - Vector3d2.field_72450_a, 0.0, targetVector.field_72449_c - Vector3d2.field_72449_c).func_72432_b().func_186678_a(0.5);
        targetVector = targetVector.func_178788_d(Vector3d1);
        Vector3d Vector3d22 = targetVector.func_178788_d(Vector3d2);
        float angleRad = (float)upwardsAngle * (float)Math.PI / 180.0f;
        double d0 = Math.atan2(Vector3d22.field_72449_c, Vector3d22.field_72450_a);
        double d1 = Vector3d22.func_178786_a(0.0, Vector3d22.field_72448_b, 0.0).func_189985_c();
        double d2 = Math.sqrt(d1);
        double d3 = Vector3d22.field_72448_b;
        double d4 = Math.sin(2.0f * angleRad);
        double d6 = Math.pow(Math.cos(angleRad), 2.0);
        double up_sin = Math.sin(angleRad);
        double up_cos = Math.cos(angleRad);
        double horizontal_sin = Math.sin(d0);
        double horizontal_cos = Math.cos(d0);
        double d11 = d1 * 0.08 / (d2 * d4 - 2.0 * d3 * d6);
        if (d11 < 0.0) {
            return Optional.empty();
        }
        double d12 = Math.sqrt(d11);
        if (d12 > 4.0) {
            return Optional.empty();
        }
        double d13 = d12 * up_cos;
        double d14 = d12 * up_sin;
        int i = (int)(Math.ceil(d2 / d13) * 2.0);
        double d15 = 0.0;
        Vector3d Vector3d3 = null;
        for (int j = 0; j < i - 1; ++j) {
            double offsetY = up_sin / up_cos * (d15 += d2 / (double)i) - Math.pow(d15, 2.0) * 0.08 / (2.0 * d11 * Math.pow(up_cos, 2.0));
            double offsetX = d15 * horizontal_cos;
            double offsetZ = d15 * horizontal_sin;
            Vector3d Vector3d4 = new Vector3d(Vector3d2.field_72450_a + offsetX, Vector3d2.field_72448_b + offsetY, Vector3d2.field_72449_c + offsetZ);
            if (Vector3d3 != null && !this.isClearTransition(Vector3d3, Vector3d4)) {
                return Optional.empty();
            }
            Vector3d3 = Vector3d4;
        }
        return Optional.of(new Vector3d(d13 * horizontal_cos, d14, d13 * horizontal_sin).func_186678_a((double)0.95f));
    }

    private boolean isClearTransition(Vector3d p_147665_, Vector3d p_147666_) {
        Vector3d Vector3d2 = p_147666_.func_178788_d(p_147665_);
        double d0 = Math.min(this.attacker.func_213311_cf(), this.attacker.func_213302_cg());
        int i = (int)Math.ceil(Vector3d2.func_72433_c() / d0);
        Vector3d Vector3d1 = Vector3d2.func_72432_b();
        Vector3d Vector3d22 = p_147665_;
        for (int j = 0; j < i; ++j) {
            Vector3d22 = j == i - 1 ? p_147666_ : Vector3d22.func_178787_e(Vector3d1.func_186678_a(d0 * (double)0.9f));
            AxisAlignedBB aabb = this.makeBoundingBox(Vector3d22.field_72450_a, Vector3d22.field_72448_b, Vector3d22.field_72449_c);
            if (this.attacker.func_130014_f_().func_195585_a((Entity)this.attacker, VoxelShapes.func_197881_a((AxisAlignedBB)aabb))) continue;
            return false;
        }
        return true;
    }

    public AxisAlignedBB makeBoundingBox(double p_20385_, double p_20386_, double p_20387_) {
        float f = this.attacker.func_213311_cf() / 2.0f;
        float f1 = this.attacker.func_213302_cg();
        return new AxisAlignedBB(p_20385_ - (double)f, p_20386_, p_20387_ - (double)f, p_20385_ + (double)f, p_20386_ + (double)f1, p_20387_ + (double)f);
    }
}

