/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import untamedwilds.entity.ComplexMobTerrestrial;
import untamedwilds.entity.mammal.EntityBison;
import untamedwilds.entity.mammal.EntityRhino;
import untamedwilds.util.EntityUtils;

public class MeleeAttackCharger
extends Goal {
    private final int executionChance;
    private final float speed;
    private final ComplexMobTerrestrial taskOwner;
    private double chargeX;
    private double chargeY;
    private double chargeZ;
    private int charge;

    public MeleeAttackCharger(ComplexMobTerrestrial entityIn, float speedIn, int chance) {
        this.taskOwner = entityIn;
        this.speed = speedIn;
        this.executionChance = chance;
        this.charge = 0;
        this.func_220684_a(EnumSet.of(Goal.Flag.TARGET, Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        LivingEntity chargeTarget = this.taskOwner.func_70638_az();
        if (this.taskOwner.func_70631_g_() || chargeTarget == null || !this.taskOwner.func_233570_aj_() || this.taskOwner.func_70681_au().nextInt(this.executionChance) != 0) {
            return false;
        }
        double distance = this.taskOwner.func_70032_d((Entity)chargeTarget);
        if (distance < 2.0 || distance > 24.0 || !this.taskOwner.func_233570_aj_()) {
            return false;
        }
        Vector3d chargePos = EntityUtils.getOvershootPath((Entity)this.taskOwner, (Entity)chargeTarget, 10.0);
        boolean canSeeTargetFromDest = this.taskOwner.func_70635_at().func_75522_a((Entity)chargeTarget);
        if (canSeeTargetFromDest) {
            this.chargeX = chargePos.func_82615_a();
            this.chargeY = chargePos.func_82617_b();
            this.chargeZ = chargePos.func_82616_c();
            return true;
        }
        return false;
    }

    public void func_75249_e() {
        this.charge = 50;
        if (this.taskOwner instanceof EntityBison) {
            this.taskOwner.setAnimation(EntityBison.ATTACK_THREATEN);
        }
        if (this.taskOwner instanceof EntityRhino) {
            this.taskOwner.setAnimation(EntityRhino.ATTACK_THREATEN);
        }
    }

    public boolean func_75253_b() {
        return this.charge > 0 || !this.taskOwner.func_70661_as().func_75500_f();
    }

    public void func_75246_d() {
        this.taskOwner.func_70671_ap().func_220679_a(this.chargeX, this.chargeY - 1.0, this.chargeZ);
        if (this.charge > 0) {
            if (--this.charge == 0) {
                this.taskOwner.func_70661_as().func_75492_a(this.chargeX, this.chargeY, this.chargeZ, (double)(this.speed * 1.2f));
            } else {
                this.taskOwner.func_70031_b(true);
            }
        } else {
            AxisAlignedBB offset_box = this.taskOwner.func_174813_aQ().func_72317_d(Math.cos(Math.toRadians(this.taskOwner.field_70177_z + 90.0f)) * 1.2, 0.0, Math.sin(Math.toRadians(this.taskOwner.field_70177_z + 90.0f)) * 1.2);
            List entitiesHit = this.taskOwner.func_130014_f_().func_175647_a(LivingEntity.class, offset_box, EntityPredicates.field_188444_d);
            for (LivingEntity entityHit : entitiesHit) {
                if (entityHit instanceof EntityRhino || entityHit.equals((Object)this.taskOwner) || !this.taskOwner.func_70685_l((Entity)entityHit)) continue;
                this.taskOwner.func_70652_k((Entity)entityHit);
            }
        }
    }

    public void func_75251_c() {
        this.charge = 0;
        this.taskOwner.func_70031_b(false);
    }
}

