/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.fluid.FluidState;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ComplexMobAquatic;

public class JumpGoal
extends Goal {
    private static final int[] JUMP_DISTANCES = new int[]{0, 1, 3, 4};
    private final ComplexMob taskOwner;
    private final int chance;
    private boolean inWater;
    private final boolean safeJumping;

    public JumpGoal(ComplexMobAquatic entityIn, int chance) {
        this(entityIn, chance, true);
    }

    public JumpGoal(ComplexMobAquatic entityIn, int chance, boolean safeJumping) {
        this.taskOwner = entityIn;
        this.chance = chance;
        this.safeJumping = safeJumping;
    }

    public boolean func_75250_a() {
        if (this.taskOwner.func_70681_au().nextInt(this.chance) != 0) {
            return false;
        }
        Direction direction = this.taskOwner.func_184172_bi();
        int i = direction.func_82601_c();
        int j = direction.func_82599_e();
        BlockPos blockpos = this.taskOwner.func_233580_cy_();
        for (int k : JUMP_DISTANCES) {
            if (this.isAirAbove(blockpos, i, j, k) && (!this.safeJumping || this.canJumpTo(blockpos, i, j, k))) continue;
            return false;
        }
        return true;
    }

    private boolean canJumpTo(BlockPos pos, int dx, int dz, int scale) {
        BlockPos blockpos = pos.func_177982_a(dx * scale, 0, dz * scale);
        return this.taskOwner.field_70170_p.func_204610_c(blockpos).func_206884_a((ITag)FluidTags.field_206959_a) && !this.taskOwner.field_70170_p.func_180495_p(blockpos).func_185904_a().func_76230_c();
    }

    private boolean isAirAbove(BlockPos pos, int dx, int dz, int scale) {
        return this.taskOwner.field_70170_p.func_180495_p(pos.func_177982_a(dx * scale, 1, dz * scale)).func_196958_f() && this.taskOwner.field_70170_p.func_180495_p(pos.func_177982_a(dx * scale, 2, dz * scale)).func_196958_f();
    }

    public boolean func_75253_b() {
        double d0 = this.taskOwner.func_213322_ci().field_72448_b;
        return !(d0 * d0 < (double)0.03f && this.taskOwner.field_70125_A != 0.0f && Math.abs(this.taskOwner.field_70125_A) < 10.0f && this.taskOwner.func_70090_H() || this.taskOwner.func_233570_aj_());
    }

    public boolean func_220685_C_() {
        return false;
    }

    public void func_75249_e() {
        Direction direction = this.taskOwner.func_184172_bi();
        this.taskOwner.func_213317_d(this.taskOwner.func_213322_ci().func_72441_c((double)direction.func_82601_c() * 0.6, 0.6, (double)direction.func_82599_e() * 0.6));
        this.taskOwner.func_70661_as().func_75499_g();
    }

    public void func_75251_c() {
        this.taskOwner.field_70125_A = 0.0f;
    }

    public void func_75246_d() {
        boolean flag = this.inWater;
        if (!flag) {
            FluidState fluidstate = this.taskOwner.field_70170_p.func_204610_c(this.taskOwner.func_233580_cy_());
            this.inWater = fluidstate.func_206884_a((ITag)FluidTags.field_206959_a);
        }
        if (this.inWater && !flag) {
            this.taskOwner.func_184185_a(SoundEvents.field_205209_aZ, 1.0f, 1.0f);
        }
        Vector3d vector3d = this.taskOwner.func_213322_ci();
        if (vector3d.field_72448_b * vector3d.field_72448_b < (double)0.03f && this.taskOwner.field_70125_A != 0.0f) {
            this.taskOwner.field_70125_A = MathHelper.func_226167_j_((float)this.taskOwner.field_70125_A, (float)0.0f, (float)0.2f);
        } else {
            double d0 = Math.sqrt(Entity.func_213296_b((Vector3d)vector3d));
            double d1 = Math.signum(-vector3d.field_72448_b) * Math.acos(d0 / vector3d.func_72433_c()) * 57.2957763671875;
            this.taskOwner.field_70125_A = (float)d1;
        }
    }
}

