/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai;

import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMobTerrestrial;
import untamedwilds.init.ModTags;

public class GrazeGoal
extends Goal {
    private final ComplexMobTerrestrial taskOwner;
    private final World entityWorld;
    private BlockPos testpos;
    private int eatingGrassTimer;
    private final int executionChance;

    public GrazeGoal(ComplexMobTerrestrial entityIn, int chance) {
        this.taskOwner = entityIn;
        this.entityWorld = entityIn.field_70170_p;
        this.executionChance = chance;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean func_75250_a() {
        BlockPos pos;
        if (!this.taskOwner.canMove() || this.taskOwner.func_70631_g_() || this.taskOwner.getHunger() > 100 || this.taskOwner.func_70638_az() != null || this.taskOwner.func_70681_au().nextInt(this.executionChance) != 0) {
            return false;
        }
        this.testpos = this.taskOwner.func_233580_cy_().func_177963_a(Math.cos(Math.toRadians(this.taskOwner.field_70177_z + 90.0f)) * 1.2, 0.0, Math.sin(Math.toRadians(this.taskOwner.field_70177_z + 90.0f)) * 1.2);
        if (this.entityWorld.func_180495_p(this.testpos).func_235714_a_(ModTags.BlockTags.GRAZEABLE_BLOCKS) || this.entityWorld.func_180495_p(this.testpos.func_177977_b()).func_177230_c() == Blocks.field_196658_i) {
            return true;
        }
        if (this.taskOwner.getHunger() < 40 && (pos = this.locateGrazeables()) != null) {
            this.taskOwner.func_70661_as().func_75492_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 1.0);
        }
        return false;
    }

    public void func_75249_e() {
        this.eatingGrassTimer = 40;
        this.entityWorld.func_72960_a((Entity)this.taskOwner, (byte)10);
        this.taskOwner.func_70661_as().func_75499_g();
        this.taskOwner.setAnimation(this.taskOwner.getAnimationEat());
    }

    public void func_75251_c() {
        this.eatingGrassTimer = 0;
    }

    public boolean func_75253_b() {
        return this.eatingGrassTimer > 0;
    }

    public void func_75246_d() {
        this.eatingGrassTimer = Math.max(0, this.eatingGrassTimer - 1);
        if (this.eatingGrassTimer == 4) {
            if (this.entityWorld.func_180495_p(this.testpos).func_235714_a_(ModTags.BlockTags.GRAZEABLE_BLOCKS)) {
                if (ForgeEventFactory.getMobGriefingEvent((World)this.entityWorld, (Entity)this.taskOwner) && ((Boolean)ConfigGamerules.grazerGriefing.get()).booleanValue()) {
                    this.entityWorld.func_175655_b(this.testpos, false);
                }
                this.taskOwner.addHunger(16);
                this.taskOwner.func_70615_aA();
            } else {
                BlockPos blockpos1 = this.testpos.func_177977_b();
                if (this.entityWorld.func_180495_p(blockpos1).func_177230_c() == Blocks.field_196658_i) {
                    if (ForgeEventFactory.getMobGriefingEvent((World)this.entityWorld, (Entity)this.taskOwner)) {
                        this.entityWorld.func_217379_c(2001, blockpos1, Block.func_196246_j((BlockState)Blocks.field_196658_i.func_176223_P()));
                        if (((Boolean)ConfigGamerules.grazerGriefing.get()).booleanValue()) {
                            this.entityWorld.func_180501_a(blockpos1, Blocks.field_150346_d.func_176223_P(), 2);
                        }
                    }
                    this.taskOwner.addHunger(16);
                    this.taskOwner.func_70615_aA();
                }
            }
        }
    }

    @Nullable
    private BlockPos locateGrazeables() {
        Random random = this.taskOwner.func_70681_au();
        BlockPos blockpos = this.taskOwner.func_233580_cy_();
        for (int i = 0; i < 10; ++i) {
            BlockPos blockpos1 = blockpos.func_177982_a(random.nextInt(12) - 6, random.nextInt(4) - 2, random.nextInt(12) - 6);
            if (!this.entityWorld.func_180495_p(this.testpos).func_235714_a_(ModTags.BlockTags.GRAZEABLE_BLOCKS) && this.entityWorld.func_180495_p(this.testpos.func_177977_b()).func_177230_c() != Blocks.field_196658_i || !(this.taskOwner.func_180484_a(blockpos1) < 0.0f)) continue;
            return blockpos1;
        }
        return null;
    }
}

