/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai;

import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import untamedwilds.entity.ComplexMobAmphibious;
import untamedwilds.entity.ComplexMobTerrestrial;

public class GotoSleepGoal
extends Goal {
    private final ComplexMobTerrestrial creature;
    protected Vector3f target;
    private final int executionChance;
    private final double speed;
    private final boolean usesHome;

    public GotoSleepGoal(ComplexMobTerrestrial entityIn, double speedIn) {
        this(entityIn, speedIn, 200, true);
    }

    public GotoSleepGoal(ComplexMobTerrestrial entityIn, double speedIn, int chance) {
        this(entityIn, speedIn, chance, true);
    }

    public GotoSleepGoal(ComplexMobTerrestrial entityIn, double speedIn, int chance, boolean usesHome) {
        this.creature = entityIn;
        this.speed = speedIn;
        this.executionChance = chance;
        this.usesHome = usesHome;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
    }

    public boolean func_75250_a() {
        if (this.creature.func_70681_au().nextInt(this.executionChance) != 0) {
            return false;
        }
        if (this.creature.isMobSleeping() && this.creature.isActive() && this.creature.forceSleep <= 0 || !(this.creature instanceof ComplexMobAmphibious) && this.creature.func_70090_H()) {
            this.creature.setMobSleeping(false);
            return false;
        }
        if (this.creature.getCommandInt() != 0 || this.creature.isActive() || this.creature.func_184207_aI() || !this.creature.canMove() || this.creature.func_70090_H() && !(this.creature instanceof ComplexMobAmphibious)) {
            return false;
        }
        if (this.isValidShelter(this.creature.func_233580_cy_().func_177972_a(Direction.UP)) || !this.usesHome) {
            this.creature.setMobSleeping(true);
            return false;
        }
        return false;
    }

    private boolean canEasilyReach(BlockPos target) {
        int j;
        Path path = this.creature.func_70661_as().func_179680_a(target, 0);
        if (path == null) {
            return false;
        }
        PathPoint pathpoint = path.func_75870_c();
        if (pathpoint == null) {
            return false;
        }
        int i = pathpoint.field_75839_a - MathHelper.func_76141_d((float)target.func_177958_n());
        return (double)(i * i + (j = pathpoint.field_75838_c - MathHelper.func_76141_d((float)target.func_177952_p())) * j) <= 2.25;
    }

    public void func_75249_e() {
        this.creature.setMobSleeping(true);
    }

    public boolean func_75253_b() {
        return false;
    }

    @Nullable
    public BlockPos checkForNewHome() {
        Random random = this.creature.func_70681_au();
        BlockPos blockpos = this.creature.func_233580_cy_();
        for (int i = 0; i < 10; ++i) {
            BlockPos blockpos1 = blockpos.func_177982_a(random.nextInt(12) - 6, random.nextInt(4) - 2, random.nextInt(12) - 6);
            if (!this.isValidShelter(blockpos1) || !(this.creature.func_180484_a(blockpos1) < 0.0f)) continue;
            return blockpos1;
        }
        return null;
    }

    private boolean isValidShelter(BlockPos blockPos) {
        return !this.creature.field_70170_p.func_175710_j(blockPos);
    }
}

