/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai;

import java.util.EnumSet;
import java.util.Random;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.PathType;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import untamedwilds.entity.ComplexMobAmphibious;

public class AmphibiousTransition
extends Goal {
    private final ComplexMobAmphibious taskOwner;
    private final double movementSpeed;
    private final int executionChance;
    private final World world;
    private Vector3d shelter;

    public AmphibiousTransition(ComplexMobAmphibious entityIn, double speedIn) {
        this(entityIn, speedIn, 120);
    }

    public AmphibiousTransition(ComplexMobAmphibious entityIn, double speedIn, int chance) {
        this.taskOwner = entityIn;
        this.movementSpeed = speedIn;
        this.executionChance = chance;
        this.world = entityIn.field_70170_p;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
    }

    public boolean func_75250_a() {
        if (this.taskOwner.func_184207_aI() || !this.taskOwner.canMove() || this.taskOwner.func_70638_az() != null) {
            return false;
        }
        if (this.taskOwner.func_70681_au().nextInt(this.executionChance) != 0) {
            return false;
        }
        Vector3d vec3d = null;
        if (this.taskOwner.wantsToEnterWater() && !this.taskOwner.func_70090_H()) {
            vec3d = this.findWaterPos();
        } else if (this.taskOwner.wantsToLeaveWater() && this.taskOwner.func_70090_H()) {
            vec3d = this.findLandPos();
        }
        this.shelter = vec3d;
        return vec3d != null;
    }

    public boolean func_75253_b() {
        return !this.taskOwner.func_70661_as().func_75500_f();
    }

    public void func_75249_e() {
        this.taskOwner.func_70661_as().func_75492_a(this.shelter.func_82615_a(), this.shelter.func_82617_b(), this.shelter.func_82616_c(), this.movementSpeed);
    }

    protected Vector3d findWaterPos() {
        Random random = this.taskOwner.func_70681_au();
        BlockPos blockpos = new BlockPos(this.taskOwner.func_226277_ct_(), this.taskOwner.func_174813_aQ().field_72338_b, this.taskOwner.func_226281_cx_());
        for (int i = 0; i < 10; ++i) {
            BlockPos blockpos1 = blockpos.func_177982_a(random.nextInt(20) - 10, random.nextInt(6) - 3, random.nextInt(20) - 10);
            if (!this.world.func_204610_c(blockpos1).func_206884_a((ITag)FluidTags.field_206959_a)) continue;
            return new Vector3d((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o(), (double)blockpos1.func_177952_p() + 0.5);
        }
        return null;
    }

    private Vector3d findLandPos() {
        Random random = this.taskOwner.func_70681_au();
        BlockPos blockpos = new BlockPos(this.taskOwner.func_226277_ct_(), this.taskOwner.func_174813_aQ().field_72338_b, this.taskOwner.func_226281_cx_());
        for (int i = 0; i < 10; ++i) {
            BlockPos blockpos1 = blockpos.func_177982_a(random.nextInt(20) - 10, random.nextInt(6), random.nextInt(20) - 10);
            if (!this.world.func_204610_c(blockpos1).func_206888_e() || !this.world.func_180495_p(blockpos1).func_196957_g((IBlockReader)this.world, blockpos1, PathType.LAND) || !this.world.func_180495_p(blockpos1.func_177977_b()).func_200132_m()) continue;
            return new Vector3d((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o(), (double)blockpos1.func_177952_p() + 0.5);
        }
        return null;
    }
}

