/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.biome.Biome;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMob;
import untamedwilds.util.SpeciesDataHolder;

public interface ISpecies {
    default public int setSpeciesByBiome(RegistryKey<Biome> biomekey, Biome biome, SpawnReason reason) {
        if (((Boolean)ConfigGamerules.randomSpecies.get()).booleanValue() || this.isArtificialSpawnReason(reason)) {
            return ((MobEntity)this).func_70681_au().nextInt(ComplexMob.getEntityData(((MobEntity)this).func_200600_R()).getSpeciesData().size());
        }
        ArrayList<Integer> validTypes = new ArrayList<Integer>();
        for (SpeciesDataHolder speciesDatum : ComplexMob.getEntityData(((MobEntity)this).func_200600_R()).getSpeciesData()) {
            for (List<SpeciesDataHolder.BiomeTestHolder> testList : speciesDatum.getBiomeCategories()) {
                ArrayList<Boolean> results = new ArrayList<Boolean>();
                for (SpeciesDataHolder.BiomeTestHolder test : testList) {
                    if (!test.isValidBiome(biomekey, biome)) break;
                    results.add(true);
                }
                if (results.size() != testList.size()) continue;
                for (int i = 0; i < speciesDatum.getRarity(); ++i) {
                    validTypes.add(speciesDatum.getVariant());
                }
            }
        }
        if (validTypes.isEmpty()) {
            return 99;
        }
        return (Integer)validTypes.get(new Random().nextInt(validTypes.size()));
    }

    default public String getRawSpeciesName(int i) {
        return ComplexMob.getEntityData(((ComplexMob)((Object)this)).func_200600_R()).getSpeciesData().get(i).getName().toLowerCase();
    }

    default public String getSpeciesName(int i) {
        return new TranslationTextComponent("entity.untamedwilds." + ((ComplexMob)((Object)this)).func_200600_R().getRegistryName().func_110623_a() + "_" + this.getRawSpeciesName(i)).getString();
    }

    default public String getSpeciesName() {
        return this instanceof ComplexMob ? this.getSpeciesName(((ComplexMob)((Object)this)).getVariant()) : "";
    }

    default public boolean isArtificialSpawnReason(SpawnReason reason) {
        return reason == SpawnReason.SPAWN_EGG || reason == SpawnReason.BUCKET || reason == SpawnReason.MOB_SUMMONED || reason == SpawnReason.COMMAND || reason == SpawnReason.SPAWNER;
    }
}

