/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMob;
import untamedwilds.util.EntityUtils;

public abstract class ComplexMobTerrestrial
extends ComplexMob
implements IAnimatedEntity {
    public int sitProgress;
    public int ticksToSit;
    public int sleepProgress;
    public int forceSleep;
    protected int tiredCounter = 0;
    protected int buoyancy = 1;
    private static final DataParameter<Integer> HUNGER = EntityDataManager.func_187226_a(ComplexMobTerrestrial.class, (IDataSerializer)DataSerializers.field_187192_b);
    private int animationTick;
    private Animation currentAnimation;
    public float turn_speed = 0.2f;
    protected float swimSpeedMult = 1.0f;

    public ComplexMobTerrestrial(EntityType<? extends ComplexMob> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new MoveHelperController(this);
        this.ticksToSit = 40;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HUNGER, (Object)79);
    }

    @Override
    public void func_70636_d() {
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        if (!this.field_70170_p.field_72995_K) {
            if (this.forceSleep > 0) {
                --this.forceSleep;
            } else if (this.forceSleep < 0) {
                ++this.forceSleep;
            }
            if (!this.func_70661_as().func_75500_f() && (this.func_233685_eM_() || this.isMobSleeping())) {
                this.setSitting(false);
                this.setMobSleeping(false);
            }
            if (this.func_70086_ai() < 40 && this.field_70173_aa % 10 == 0) {
                this.func_70605_aq().func_188488_a(0.6f, 0.0f);
                this.func_70664_aZ();
            }
            if (!this.isMobSleeping() && this.forceSleep > 0) {
                this.setMobSleeping(true);
            }
            if (this.field_70173_aa % 200 == 0 && !this.isActive() && this.func_70661_as().func_75500_f()) {
                ++this.tiredCounter;
                if (this.func_195048_a(this.getHomeAsVec()) <= 6.0) {
                    this.setMobSleeping(true);
                    this.tiredCounter = 0;
                } else if (this.tiredCounter >= 3) {
                    this.setHome(BlockPos.field_177992_a);
                    this.tiredCounter = 0;
                }
                this.field_70765_h.func_75642_a((double)this.getHome().func_177958_n(), (double)this.getHome().func_177956_o(), (double)this.getHome().func_177952_p(), 1.0);
            }
        }
        if (this.field_70170_p.func_201670_d()) {
            if (this.func_233685_eM_() && this.sitProgress < this.ticksToSit) {
                ++this.sitProgress;
            } else if (!this.func_233685_eM_() && this.sitProgress > 0) {
                --this.sitProgress;
            }
            if (this.isMobSleeping() && this.sleepProgress < 40) {
                ++this.sleepProgress;
            } else if (!this.isMobSleeping() && this.sleepProgress > 0) {
                --this.sleepProgress;
            }
        }
        super.func_70636_d();
    }

    @Override
    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (!this.func_70631_g_() && this.isFavouriteFood(itemstack) && !this.field_70729_aU) {
            if (!this.field_70170_p.field_72995_K && !player.func_184812_l_()) {
                itemstack.func_190918_g(1);
            }
            if (((Boolean)ConfigGamerules.playerBreeding.get()).booleanValue() && this.field_175504_a == 0) {
                this.func_146082_f(player);
                EntityUtils.spawnParticlesOnEntity(this.field_70170_p, (LivingEntity)this, ParticleTypes.field_197633_z, 7, 1);
            }
            this.setAnimation(this.getAnimationEat());
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187537_bA, this.func_184176_by(), 1.0f, 1.0f, true);
            return ActionResultType.CONSUME;
        }
        return super.func_230254_b_(player, hand);
    }

    protected ActivityType getActivityType() {
        return ComplexMobTerrestrial.getEntityData(this.func_200600_R()).getActivityType(this.getVariant());
    }

    public boolean isActive() {
        ActivityType type = this.getActivityType();
        Pair<Integer, Integer> times = type.getTimes();
        if (this.func_70909_n() && this.getCommandInt() != 0 || !((Boolean)ConfigGamerules.sleepBehaviour.get()).booleanValue()) {
            return true;
        }
        if (type == ActivityType.CATHEMERAL) {
            return this.field_70173_aa % 17000 < 3000;
        }
        long time = this.field_70170_p.func_72820_D();
        if (!((Integer)times.getFirst()).equals(times.getSecond())) {
            if ((Integer)times.getFirst() > (Integer)times.getSecond()) {
                return time > (long)((Integer)times.getFirst()).intValue() || time < (long)((Integer)times.getSecond()).intValue();
            }
            return time > (long)((Integer)times.getFirst()).intValue() && time < (long)((Integer)times.getSecond()).intValue();
        }
        return this.forceSleep >= 0;
    }

    private void setHunger(int hunger) {
        this.field_70180_af.func_187227_b(HUNGER, (Object)hunger);
    }

    public int getHunger() {
        return (Integer)this.field_70180_af.func_187225_a(HUNGER);
    }

    public boolean isStarving() {
        return this.getHunger() <= 0;
    }

    public void addHunger(int change) {
        int i = this.getHunger() + change;
        this.setHunger(i > 200 ? 200 : Math.max(i, 0));
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_233685_eM_()) {
            this.setSitting(false);
        }
        if (this.isMobSleeping()) {
            this.setMobSleeping(false);
            this.forceSleep = -4000;
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70645_a(DamageSource p_70645_1_) {
        if (!this.field_70170_p.field_72995_K && !((Boolean)ConfigGamerules.hardcoreDeath.get()).booleanValue() && this.getHome() != BlockPos.field_177992_a && this.func_70909_n() && this.getHunger() != 0) {
            this.func_195064_c(new EffectInstance(Effects.field_188423_x, 800, 0));
            this.func_70606_j(0.5f);
            this.setHunger(0);
            if (!this.func_213373_a(this.getHome().func_177958_n(), this.getHome().func_177956_o(), this.getHome().func_177952_p(), true)) {
                super.func_70645_a(p_70645_1_);
            }
        } else {
            super.func_70645_a(p_70645_1_);
        }
    }

    public void func_213352_e(Vector3d destination) {
        double d6;
        double d8;
        if (this.func_70613_aW() || this.func_184186_bw()) {
            ModifiableAttributeInstance gravity = this.func_110148_a((Attribute)ForgeMod.ENTITY_GRAVITY.get());
            boolean flag = this.func_213322_ci().field_72448_b <= 0.0;
            double d0 = gravity.func_111126_e();
            FluidState fluidstate = this.field_70170_p.func_204610_c(this.func_233580_cy_());
            if (this.func_70090_H() && this.func_241208_cS_() && !this.func_230285_a_(fluidstate.func_206886_c())) {
                double d82 = this.func_226278_cu_();
                float f5 = this.func_70051_ag() ? 0.9f : this.func_189749_co();
                float f6 = 0.045f;
                float f7 = EnchantmentHelper.func_185294_d((LivingEntity)this);
                if (!this.field_70122_E) {
                    f7 *= 0.7f;
                }
                if (f7 > 0.0f) {
                    if (f7 > 3.0f) {
                        f7 = 3.0f;
                    }
                    f5 += (0.54600006f - f5) * f7 / 3.0f;
                    f6 += (this.func_70689_ay() - f6) * f7 / 3.0f;
                }
                if (this.func_70644_a(Effects.field_206827_D)) {
                    f5 = 0.96f;
                }
                this.func_213309_a(f6 *= (float)this.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get()).func_111126_e(), destination);
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                Vector3d vector3d6 = this.func_213322_ci();
                if (this.field_70123_F && this.func_70617_f_()) {
                    vector3d6 = new Vector3d(vector3d6.field_72450_a, 0.2, vector3d6.field_72449_c);
                }
                this.func_213317_d(vector3d6.func_216372_d((double)f5, (double)0.8f, (double)f5));
                Vector3d vector3d2 = this.func_233626_a_(d0, flag, this.func_213322_ci());
                this.func_213317_d(vector3d2);
                if (this.field_70123_F && this.func_70038_c(vector3d2.field_72450_a, vector3d2.field_72448_b + (double)0.6f - this.func_226278_cu_() + d82, vector3d2.field_72449_c)) {
                    this.func_213293_j(vector3d2.field_72450_a, 0.3f, vector3d2.field_72449_c);
                }
            } else if (this.func_180799_ab() && this.func_241208_cS_() && !this.func_230285_a_(fluidstate.func_206886_c())) {
                double d7 = this.func_226278_cu_();
                this.func_213309_a(0.02f, destination);
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                if (this.func_233571_b_((ITag)FluidTags.field_206960_b) <= this.func_233579_cu_()) {
                    this.func_213317_d(this.func_213322_ci().func_216372_d(0.5, (double)0.8f, 0.5));
                    this.func_213317_d(this.func_233626_a_(d0, flag, this.func_213322_ci()));
                } else {
                    this.func_213317_d(this.func_213322_ci().func_186678_a(0.5));
                }
                if (!this.func_189652_ae()) {
                    this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -d0 / 4.0, 0.0));
                }
                Vector3d vector3d4 = this.func_213322_ci();
                if (this.field_70123_F && this.func_70038_c(vector3d4.field_72450_a, vector3d4.field_72448_b + (double)0.6f - this.func_226278_cu_() + d7, vector3d4.field_72449_c)) {
                    this.func_213293_j(vector3d4.field_72450_a, 0.3f, vector3d4.field_72449_c);
                }
            } else {
                BlockPos blockpos = this.func_226270_aj_();
                float f3 = this.field_70170_p.func_180495_p(this.func_226270_aj_()).getSlipperiness((IWorldReader)this.field_70170_p, this.func_226270_aj_(), (Entity)this);
                float f4 = this.field_70122_E ? f3 * 0.91f : 0.91f;
                Vector3d vector3d5 = this.func_233633_a_(destination, f3);
                double d2 = vector3d5.field_72448_b;
                if (this.func_70644_a(Effects.field_188424_y)) {
                    d2 += (0.05 * (double)(this.func_70660_b(Effects.field_188424_y).func_76458_c() + 1) - vector3d5.field_72448_b) * 0.2;
                    this.field_70143_R = 0.0f;
                } else if (this.field_70170_p.field_72995_K && !this.field_70170_p.func_175667_e(blockpos)) {
                    d2 = this.func_226278_cu_() > 0.0 ? -0.1 : 0.0;
                } else if (!this.func_189652_ae()) {
                    d2 -= d0;
                }
                this.func_213293_j(vector3d5.field_72450_a * (double)f4, d2 * (double)0.98f, vector3d5.field_72449_c * (double)f4);
            }
        }
        this.field_184618_aE = this.field_70721_aZ;
        double d5 = this.func_226277_ct_() - this.field_70169_q;
        float f8 = MathHelper.func_76133_a((double)(d5 * d5 + (d8 = this instanceof IFlyingAnimal ? this.func_226278_cu_() - this.field_70167_r : 0.0) * d8 + (d6 = this.func_226281_cx_() - this.field_70166_s) * d6)) * 4.0f;
        if (f8 > 1.0f) {
            f8 = 1.0f;
        }
        this.field_70721_aZ += (f8 - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[0];
    }

    public Animation getAnimationEat() {
        return NO_ANIMATION;
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("SleepingTicks", this.forceSleep);
        compound.func_74768_a("Hunger", this.getHunger());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.forceSleep = compound.func_74762_e("SleepingTicks");
        this.setHunger(compound.func_74762_e("Hunger"));
    }

    static class MoveHelperController
    extends MovementController {
        private final ComplexMobTerrestrial entity;

        MoveHelperController(ComplexMobTerrestrial turtleIn) {
            super((MobEntity)turtleIn);
            this.entity = turtleIn;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.STRAFE) {
                float f = (float)this.entity.func_110148_a(Attributes.field_233821_d_).func_111126_e();
                float f1 = (float)this.field_75645_e * f;
                float f2 = this.field_188489_f;
                float f3 = this.field_188490_g;
                float f4 = MathHelper.func_76129_c((float)(f2 * f2 + f3 * f3));
                if (f4 < 1.0f) {
                    f4 = 1.0f;
                }
                f4 = f1 / f4;
                float f5 = MathHelper.func_76126_a((float)(this.entity.field_70177_z * ((float)Math.PI / 180)));
                float f6 = MathHelper.func_76134_b((float)(this.entity.field_70177_z * ((float)Math.PI / 180)));
                float f7 = (f2 *= f4) * f6 - (f3 *= f4) * f5;
                float f8 = f3 * f6 + f2 * f5;
                PathNavigator pathnavigator = this.entity.func_70661_as();
                NodeProcessor nodeprocessor = pathnavigator.func_189566_q();
                if (nodeprocessor.func_186330_a((IBlockReader)this.entity.field_70170_p, MathHelper.func_76128_c((double)(this.entity.func_226277_ct_() + (double)f7)), MathHelper.func_76128_c((double)this.entity.func_226278_cu_()), MathHelper.func_76128_c((double)(this.entity.func_226281_cx_() + (double)f8))) != PathNodeType.WALKABLE) {
                    this.field_188489_f = (float)this.func_75638_b();
                    this.field_188490_g = 0.0f;
                    f1 = f;
                }
                this.entity.func_70659_e(f1);
                this.entity.func_191989_p(this.field_188489_f);
                this.entity.func_184646_p(this.field_188490_g);
                this.field_188491_h = MovementController.Action.WAIT;
            } else if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                this.field_188491_h = MovementController.Action.WAIT;
                double d0 = this.field_75646_b - this.entity.func_226277_ct_();
                double d1 = this.field_75644_d - this.entity.func_226281_cx_();
                double d2 = this.field_75647_c - this.entity.func_226278_cu_();
                double d3 = d0 * d0 + d2 * d2 + d1 * d1;
                if (d3 < 2.500000277905201E-7) {
                    this.entity.func_191989_p(0.0f);
                    return;
                }
                float f = (float)(MathHelper.func_181159_b((double)d1, (double)d0) * 57.2957763671875) - 90.0f;
                this.entity.field_70177_z = this.func_75639_a(this.entity.field_70177_z, f, this.entity.turn_speed * 100.0f);
                BlockPos blockpos = this.entity.func_233580_cy_();
                BlockState blockstate = this.entity.field_70170_p.func_180495_p(blockpos);
                Block block = blockstate.func_177230_c();
                VoxelShape voxelshape = blockstate.func_196952_d((IBlockReader)this.entity.field_70170_p, blockpos);
                if (this.entity.func_70090_H()) {
                    if (this.entity.field_70123_F && this.entity.field_70173_aa % 10 == 0) {
                        this.entity.func_70664_aZ();
                    }
                    float f2 = -((float)(MathHelper.func_181159_b((double)d1, (double)MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2))) * 57.2957763671875));
                    f2 = MathHelper.func_76131_a((float)MathHelper.func_76142_g((float)f2), (float)-85.0f, (float)85.0f);
                    this.entity.field_70125_A = this.func_75639_a(this.entity.field_70125_A, f2, 1.0f);
                    float f4 = MathHelper.func_76126_a((float)(this.entity.field_70125_A * ((float)Math.PI / 180)));
                    this.entity.field_70701_bs = -f4 * (float)this.entity.func_110148_a(Attributes.field_233821_d_).func_111126_e();
                    if (this.entity.func_70638_az() == null) {
                        this.entity.func_213317_d(this.entity.func_213322_ci().func_72441_c(0.0, (double)(this.entity.buoyancy - 1), 0.0));
                    }
                }
                float f1 = (float)(this.func_75638_b() * this.entity.func_110148_a(Attributes.field_233821_d_).func_111126_e());
                this.entity.func_70659_e(MathHelper.func_219799_g((float)0.125f, (float)this.entity.func_70689_ay(), (float)f1));
                if (d2 > (double)this.entity.field_70138_W && d0 * d0 + d1 * d1 < (double)Math.max(1.0f, this.entity.func_213311_cf()) || !voxelshape.func_197766_b() && this.entity.func_226278_cu_() < voxelshape.func_197758_c(Direction.Axis.Y) + (double)blockpos.func_177956_o() && !block.func_203417_a((ITag)BlockTags.field_200029_f) && !block.func_203417_a((ITag)BlockTags.field_219748_G)) {
                    this.entity.func_70683_ar().func_75660_a();
                    this.field_188491_h = MovementController.Action.JUMPING;
                }
            } else if (this.field_188491_h == MovementController.Action.JUMPING) {
                this.entity.func_70659_e((float)(this.field_75645_e * this.entity.func_110148_a(Attributes.field_233821_d_).func_111126_e()));
                if (this.entity.field_70122_E) {
                    this.field_188491_h = MovementController.Action.WAIT;
                }
            } else {
                if (this.entity.func_70090_H() && this.entity.func_70638_az() == null && !this.entity.field_70123_F) {
                    this.entity.func_213317_d(this.entity.func_213322_ci().func_72441_c(0.0, (double)(this.entity.buoyancy - 1), 0.0));
                }
                this.entity.func_191989_p(0.0f);
            }
        }
    }

    public static enum ActivityType implements IStringSerializable
    {
        DIURNAL("diurnal", 1000, 16000),
        NOCTURNAL("nocturnal", 13000, 4000),
        CREPUSCULAR("crepuscular", 8000, 23000),
        CATHEMERAL("cathemeral", -1, -1),
        INSOMNIAC("insomniac", -1, -1);

        public int wakeUp;
        public int sleep;
        public String name;
        public static final Codec<ActivityType> CODEC;

        private ActivityType(String name, int wakeUp, int sleep) {
            this.wakeUp = wakeUp;
            this.sleep = sleep;
            this.name = name;
        }

        private static DataResult<ActivityType> getByName(String path) {
            switch (path) {
                case "diurnal": {
                    return DataResult.success((Object)((Object)DIURNAL));
                }
                case "nocturnal": {
                    return DataResult.success((Object)((Object)NOCTURNAL));
                }
                case "crepuscular": {
                    return DataResult.success((Object)((Object)CREPUSCULAR));
                }
                case "cathemeral": {
                    return DataResult.success((Object)((Object)CATHEMERAL));
                }
            }
            return DataResult.success((Object)((Object)INSOMNIAC));
        }

        public String toString() {
            return this.name;
        }

        public Pair<Integer, Integer> getTimes() {
            return new Pair((Object)this.wakeUp, (Object)this.sleep);
        }

        public String func_176610_l() {
            return null;
        }

        static {
            CODEC = Codec.STRING.comapFlatMap(ActivityType::getByName, ActivityType::toString).stable();
        }
    }
}

