/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity;

import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.DolphinLookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathType;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import untamedwilds.entity.ComplexMob;

public abstract class ComplexMobAquatic
extends ComplexMob {
    public ComplexMobAquatic(EntityType<? extends ComplexMob> entity, World worldIn) {
        super(entity, worldIn);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.field_70765_h = new MoveHelperController(this);
        this.field_70749_g = new DolphinLookController((MobEntity)this, 10);
    }

    public void func_203004_j(boolean downwards) {
    }

    public void func_203002_i(boolean downwards) {
    }

    public boolean func_70648_aU() {
        return true;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_203100_e;
    }

    @Override
    public boolean func_205019_a(IWorldReader worldIn) {
        return worldIn.func_226668_i_((Entity)this);
    }

    protected float func_213348_b(Pose p_213348_1_, EntitySize p_213348_2_) {
        return p_213348_2_.field_220316_b * 0.2f;
    }

    public void func_70030_z() {
        int i = this.func_70086_ai();
        super.func_70030_z();
        this.updateAir(i);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new SwimmerPathNavigator((MobEntity)this, worldIn);
    }

    @Override
    public void func_70636_d() {
        if (!this.func_70090_H() && this.func_233570_aj_() && this.field_70124_G) {
            this.func_213317_d(this.func_213322_ci().func_72441_c((double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.05f), (double)0.4f, (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.05f)));
            this.func_230245_c_(false);
            this.field_70160_al = true;
            this.func_184185_a(this.getFlopSound(), this.func_70599_aP(), this.func_70647_i());
        }
        super.func_70636_d();
    }

    protected void updateAir(int air) {
        if (this.func_70089_S() && !this.func_203005_aq()) {
            this.func_70050_g(air - 1);
            if (this.func_70086_ai() == -20) {
                this.func_70050_g(0);
                this.func_70097_a(DamageSource.field_76369_e, 2.0f);
            }
        } else {
            this.func_70050_g(300);
        }
    }

    public boolean func_96092_aw() {
        return false;
    }

    protected abstract SoundEvent getFlopSound();

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_203817_bZ;
    }

    public void func_213352_e(Vector3d movement) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(this.func_70689_ay(), movement);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (this.func_70638_az() == null) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
        } else {
            super.func_213352_e(movement);
        }
    }

    protected static class SwimGoal
    extends RandomSwimmingGoal {
        public int heightFromBottom;

        public SwimGoal(ComplexMobAquatic entity) {
            super((CreatureEntity)entity, 1.0, 20);
            this.heightFromBottom = -1;
        }

        public SwimGoal(ComplexMobAquatic entity, int offset) {
            super((CreatureEntity)entity, 1.0, 20);
            this.heightFromBottom = offset;
        }

        public boolean func_75250_a() {
            return super.func_75250_a();
        }

        @Nullable
        protected Vector3d func_190864_f() {
            Vector3d vector3d = RandomPositionGenerator.func_75463_a((CreatureEntity)this.field_75457_a, (int)10, (int)7);
            int i = 0;
            while (vector3d != null && !this.field_75457_a.field_70170_p.func_180495_p(new BlockPos(vector3d)).func_196957_g((IBlockReader)this.field_75457_a.field_70170_p, new BlockPos(vector3d), PathType.WATER) && i++ < 10) {
                vector3d = RandomPositionGenerator.func_75463_a((CreatureEntity)this.field_75457_a, (int)10, (int)7);
            }
            if (vector3d != null && this.heightFromBottom > 0 && this.field_75457_a.field_70170_p.func_175710_j(this.field_75457_a.func_233580_cy_())) {
                int offset = this.heightFromBottom + this.field_75457_a.func_70681_au().nextInt(7) - 4;
                return new Vector3d(vector3d.func_82615_a(), (double)(this.field_75457_a.field_70170_p.func_201676_a(Heightmap.Type.OCEAN_FLOOR, (int)vector3d.func_82615_a(), (int)vector3d.func_82616_c()) + offset), vector3d.func_82616_c());
            }
            return vector3d;
        }
    }

    public static class MoveHelperController
    extends MovementController {
        private final ComplexMob entity;
        private final float landMoveFactor;

        public MoveHelperController(ComplexMob entity) {
            super((MobEntity)entity);
            this.entity = entity;
            this.landMoveFactor = 0.1f;
        }

        public MoveHelperController(ComplexMob entity, float landMoveFactor) {
            super((MobEntity)entity);
            this.entity = entity;
            this.landMoveFactor = landMoveFactor;
        }

        public void func_75641_c() {
            if (this.entity.func_70090_H()) {
                this.entity.func_213317_d(this.entity.func_213322_ci().func_72441_c(0.0, 0.0045, 0.0));
            }
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.entity.func_70661_as().func_75500_f()) {
                double d2;
                double d1;
                double d0 = this.func_179917_d() - this.entity.func_226277_ct_();
                double d3 = d0 * d0 + (d1 = this.func_179919_e() - this.entity.func_226278_cu_()) * d1 + (d2 = this.func_179918_f() - this.entity.func_226281_cx_()) * d2;
                if (d3 < 2.500000277905201E-7) {
                    this.field_75648_a.func_191989_p(0.0f);
                } else {
                    float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.entity.field_70761_aq = this.entity.field_70177_z = this.func_75639_a(this.entity.field_70177_z, f, this.entity.turn_speed * 10.0f);
                    this.entity.field_70759_as = this.entity.field_70177_z;
                    float f1 = (float)(this.field_75645_e * this.entity.func_110148_a(Attributes.field_233821_d_).func_111126_e());
                    if (this.entity.func_70090_H()) {
                        this.entity.func_70659_e(f1 * 0.02f);
                        float f2 = -((float)(MathHelper.func_181159_b((double)d1, (double)MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2))) * 57.2957763671875));
                        f2 = MathHelper.func_76131_a((float)MathHelper.func_76142_g((float)f2), (float)-85.0f, (float)85.0f);
                        this.entity.field_70125_A = this.func_75639_a(this.entity.field_70125_A, f2, 5.0f);
                        float f3 = MathHelper.func_76134_b((float)(this.entity.field_70125_A * ((float)Math.PI / 180)));
                        float f4 = MathHelper.func_76126_a((float)(this.entity.field_70125_A * ((float)Math.PI / 180)));
                        this.entity.field_191988_bg = f3 * f1;
                        this.entity.field_70701_bs = -f4 * f1;
                    } else {
                        this.entity.func_70659_e(f1 * this.landMoveFactor);
                    }
                }
            } else {
                this.entity.func_70659_e(0.0f);
                this.entity.func_184646_p(0.0f);
                this.entity.func_70657_f(0.0f);
                this.entity.func_191989_p(0.0f);
            }
        }
    }
}

