/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import untamedwilds.UntamedWilds;
import untamedwilds.block.blockentity.CritterBurrowBlockEntity;
import untamedwilds.compat.CompatBridge;
import untamedwilds.compat.CompatSereneSeasons;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.config.ConfigMobControl;
import untamedwilds.entity.HerdEntity;
import untamedwilds.entity.INeedsPostUpdate;
import untamedwilds.entity.INewSkins;
import untamedwilds.entity.IPackEntity;
import untamedwilds.entity.ISpecies;
import untamedwilds.init.ModItems;
import untamedwilds.util.EntityDataHolder;
import untamedwilds.util.EntityDataHolderClient;
import untamedwilds.util.EntityUtils;
import untamedwilds.util.ResourceListenerEvent;
import untamedwilds.util.SpeciesDataHolder;

public abstract class ComplexMob
extends TameableEntity {
    private static final DataParameter<BlockPos> HOME_POS = EntityDataManager.func_187226_a(ComplexMob.class, (IDataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(ComplexMob.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SKIN = EntityDataManager.func_187226_a(ComplexMob.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static HashMap<String, HashMap<Integer, ArrayList<ResourceLocation>>> TEXTURES_COMMON = new HashMap();
    public static HashMap<String, HashMap<Integer, ArrayList<ResourceLocation>>> TEXTURES_RARE = new HashMap();
    private static final DataParameter<Float> SIZE = EntityDataManager.func_187226_a(ComplexMob.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> GENDER = EntityDataManager.func_187226_a(ComplexMob.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IS_ANGRY = EntityDataManager.func_187226_a(ComplexMob.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> COMMAND = EntityDataManager.func_187226_a(ComplexMob.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SLEEPING = EntityDataManager.func_187226_a(ComplexMob.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SITTING = EntityDataManager.func_187226_a(ComplexMob.class, (IDataSerializer)DataSerializers.field_187198_h);
    public HerdEntity herd = null;
    public float turn_speed = 1.0f;
    public int peacefulTicks;
    public static HashMap<EntityType<?>, EntityDataHolder> ENTITY_DATA_HASH = new HashMap();
    public static HashMap<EntityType<?>, EntityDataHolderClient> CLIENT_DATA_HASH = new HashMap();

    public ComplexMob(EntityType<? extends ComplexMob> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HOME_POS, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(SKIN, (Object)0);
        this.field_70180_af.func_187214_a(SIZE, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(GENDER, (Object)0);
        this.field_70180_af.func_187214_a(IS_ANGRY, (Object)false);
        this.field_70180_af.func_187214_a(COMMAND, (Object)0);
        this.field_70180_af.func_187214_a(SLEEPING, (Object)false);
        this.field_70180_af.func_187214_a(SITTING, (Object)false);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.peacefulTicks > 0) {
            --this.peacefulTicks;
        }
    }

    public static EntityDataHolder getEntityData(EntityType<?> typeIn) {
        if (!ENTITY_DATA_HASH.containsKey(typeIn)) {
            ResourceListenerEvent.registerEntityData(typeIn);
        }
        return ENTITY_DATA_HASH.get(typeIn);
    }

    protected SoundEvent func_184639_G() {
        return EntityUtils.getSound(this.func_200600_R(), this.getVariant(), "ambient");
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return EntityUtils.getSound(this.func_200600_R(), this.getVariant(), "hurt", SoundEvents.field_187543_bD);
    }

    protected SoundEvent func_184615_bR() {
        return EntityUtils.getSound(this.func_200600_R(), this.getVariant(), "death", SoundEvents.field_187661_by);
    }

    protected SoundEvent getThreatSound() {
        return EntityUtils.getSound(this.func_200600_R(), this.getVariant(), "threat");
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return true;
    }

    public boolean func_205019_a(IWorldReader worldIn) {
        return worldIn.func_226668_i_((Entity)this);
    }

    public boolean func_184652_a(PlayerEntity player) {
        if (player.func_184812_l_()) {
            return !this.func_110167_bD();
        }
        return !this.func_110167_bD() && this.func_70909_n();
    }

    public void setMobSleeping(boolean sleeping) {
        this.field_70180_af.func_187227_b(SLEEPING, (Object)sleeping);
    }

    public boolean isMobSleeping() {
        return (Boolean)this.field_70180_af.func_187225_a(SLEEPING);
    }

    public void setSitting(boolean sitting) {
        this.field_70180_af.func_187227_b(SITTING, (Object)sitting);
    }

    public boolean func_233685_eM_() {
        return (Boolean)this.field_70180_af.func_187225_a(SITTING);
    }

    public boolean isNotMoving() {
        return this.func_213322_ci().field_72450_a == 0.0 && this.func_213322_ci().field_72449_c == 0.0;
    }

    public boolean canBeTargeted() {
        return true;
    }

    public double getCurrentSpeed() {
        return Math.sqrt(this.func_213322_ci().field_72450_a * this.func_213322_ci().field_72450_a + this.func_213322_ci().field_72449_c * this.func_213322_ci().field_72449_c);
    }

    public int func_70627_aG() {
        return 300;
    }

    public static void processData(EntityDataHolder dataIn, EntityType<?> typeIn) {
        ENTITY_DATA_HASH.put(typeIn, dataIn);
        ComplexMob.processSkins(dataIn, typeIn.getRegistryName().func_110623_a());
        for (SpeciesDataHolder speciesData : ENTITY_DATA_HASH.get(typeIn).getSpeciesData()) {
            if (!CLIENT_DATA_HASH.containsKey(typeIn)) {
                CLIENT_DATA_HASH.put(typeIn, new EntityDataHolderClient(new HashMap<Integer, Map<String, SoundEvent>>(), new HashMap<Integer, String>()));
            }
            ComplexMob.CLIENT_DATA_HASH.get(typeIn).species_data.put(speciesData.getVariant(), speciesData.getName());
        }
    }

    public static void processSkins(EntityDataHolder dataIn, String nameIn) {
        for (SpeciesDataHolder speciesDatum : dataIn.getSpeciesData()) {
            EntityUtils.buildSkinArrays(nameIn, speciesDatum.getName().toLowerCase(), dataIn, speciesDatum.getVariant(), TEXTURES_COMMON, TEXTURES_RARE);
        }
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public int getSkin() {
        return (Integer)this.field_70180_af.func_187225_a(SKIN);
    }

    public void setSkin(int skin) {
        this.field_70180_af.func_187227_b(SKIN, (Object)skin);
    }

    public <T extends ComplexMob> void chooseSkinForSpecies(T entityIn, boolean allowRares) {
        String name;
        if (entityIn.func_200600_R().getRegistryName() != null && this instanceof INewSkins && !this.field_70170_p.field_72995_K && !TEXTURES_COMMON.get(name = entityIn.func_200600_R().getRegistryName().func_110623_a()).isEmpty()) {
            boolean isRare = allowRares && TEXTURES_RARE.get(name).containsKey(this.getVariant()) && (double)this.field_70146_Z.nextFloat() < (Double)ConfigGamerules.rareSkinChance.get();
            int skin = this.field_70146_Z.nextInt(isRare ? TEXTURES_RARE.get(name).get(this.getVariant()).size() : TEXTURES_COMMON.get(name).get(this.getVariant()).size()) + (isRare ? 100 : 0);
            this.setSkin(skin);
        }
    }

    public float getModelScale() {
        return ComplexMob.getEntityData(this.func_200600_R()).getScale(this.getVariant());
    }

    public float getMobSize() {
        return ((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue();
    }

    public void setMobSize(float size) {
        this.field_70180_af.func_187227_b(SIZE, (Object)Float.valueOf(size));
    }

    public void setRandomMobSize() {
        this.field_70180_af.func_187227_b(SIZE, (Object)Float.valueOf(this.getModelScale() + (float)this.field_70146_Z.nextGaussian() * 0.1f));
    }

    public void setGender(int gender) {
        this.field_70180_af.func_187227_b(GENDER, (Object)gender);
    }

    public int getGender() {
        return (Integer)this.field_70180_af.func_187225_a(GENDER);
    }

    public boolean isMale() {
        return this.getGender() == 0;
    }

    public String getGenderString() {
        return this.isMale() ? "male" : "female";
    }

    public boolean wantsToBreed() {
        if (((Boolean)ConfigGamerules.naturalBreeding.get()).booleanValue()) {
            if (CompatBridge.SereneSeasons) {
                return CompatSereneSeasons.isCurrentSeason(this.field_70170_p, this.getBreedingSeason());
            }
            return true;
        }
        return false;
    }

    public <T extends ComplexMob> void breed() {
        int bound = 1 + (this.getOffspring() > 0 ? this.field_70146_Z.nextInt(this.getOffspring() + 1) : 0);
        for (int i = 0; i < bound; ++i) {
            ComplexMob child = (ComplexMob)this.func_241840_a((ServerWorld)this.field_70170_p, (AgeableEntity)this);
            if (child == null) continue;
            child.setVariant(this.getVariant());
            child.func_70873_a(this.getAdulthoodTime() * -1);
            child.setGender(this.field_70146_Z.nextInt(2));
            child.setRandomMobSize();
            child.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0f, 0.0f);
            if (this.func_70902_q() != null) {
                child.func_193101_c((PlayerEntity)this.func_70902_q());
            }
            if (this instanceof INeedsPostUpdate) {
                ((INeedsPostUpdate)((Object)child)).updateAttributes();
            }
            if (TEXTURES_COMMON.containsKey(child.func_200600_R().getRegistryName().func_110623_a())) {
                this.chooseSkinForSpecies(child, true);
            }
            this.field_70170_p.func_217376_c((Entity)child);
        }
    }

    protected <T extends ComplexMob> T create_offspring(T entity) {
        entity.setGender(this.field_70146_Z.nextInt(2));
        entity.setRandomMobSize();
        entity.setVariant(this.getVariant());
        if (entity instanceof INeedsPostUpdate) {
            ((INeedsPostUpdate)((Object)entity)).updateAttributes();
        }
        return entity;
    }

    public String getBreedingSeason() {
        return ComplexMob.getEntityData(this.func_200600_R()).getBreedingSeason(this.getVariant());
    }

    public int getAdulthoodTime() {
        return ComplexMob.getEntityData(this.func_200600_R()).getGrowingTime(this.getVariant()) * (Integer)ConfigGamerules.cycleLength.get() * 2;
    }

    public int getPregnancyTime() {
        return ComplexMob.getEntityData(this.func_200600_R()).getGrowingTime(this.getVariant()) * (Integer)ConfigGamerules.cycleLength.get();
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b().equals(ComplexMob.getEntityData(this.func_200600_R()).getFavouriteFood(this.getVariant()).func_77973_b());
    }

    protected int getOffspring() {
        return ComplexMob.getEntityData(this.func_200600_R()).getOffspring(this.getVariant());
    }

    public boolean isFavouriteFood(ItemStack stack) {
        return stack.func_77973_b() == ModItems.DEBUG_LOVE_POTION.get();
    }

    public boolean func_175448_a(ItemStack stack) {
        return false;
    }

    private boolean isBlinking() {
        return this.field_70173_aa % 60 > 53;
    }

    public boolean shouldRenderEyes() {
        return !this.isMobSleeping() && !this.field_70729_aU && !this.isBlinking() && this.field_70737_aN == 0;
    }

    public boolean canMove() {
        return !this.func_233685_eM_() && !this.isMobSleeping();
    }

    public void setHome(BlockPos position) {
        this.field_70180_af.func_187227_b(HOME_POS, (Object)position);
    }

    public BlockPos getHome() {
        return (BlockPos)this.field_70180_af.func_187225_a(HOME_POS);
    }

    public Vector3d getHomeAsVec() {
        BlockPos home = this.getHome();
        return new Vector3d((double)home.func_177958_n(), (double)home.func_177956_o(), (double)home.func_177952_p());
    }

    public void func_70873_a(int age) {
        int i = this.field_175504_a;
        super.func_70873_a(age);
        this.field_175504_a = age;
        if (!this.isMale() && !((Boolean)ConfigGamerules.easyBreeding.get()).booleanValue() && i > 0 && age <= 0) {
            this.breed();
        }
    }

    public ResourceLocation getTexture() {
        return EntityUtils.getSkinFromEntity(this);
    }

    public static int getEcoLevel(LivingEntity entity) {
        if (entity instanceof PlayerEntity) {
            return Math.round(4.0f + entity.func_110143_aJ() / 6.0f);
        }
        double attack = Math.max(entity.func_233645_dx_().func_233790_b_(Attributes.field_233823_f_) ? entity.func_110148_a(Attributes.field_233823_f_).func_111126_e() : 1.0, 4.0);
        if (entity instanceof ComplexMob && ((ComplexMob)entity).herd != null) {
            return Math.round((float)Math.sqrt((double)entity.func_110143_aJ() * attack) / 2.5f) + ((ComplexMob)entity).herd.creatureList.size();
        }
        return Math.round((float)Math.sqrt((double)entity.func_110143_aJ() * attack) / 2.5f);
    }

    protected void setAngry(boolean isAngry) {
        this.field_70180_af.func_187227_b(IS_ANGRY, (Object)isAngry);
    }

    public boolean isAngry() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_ANGRY);
    }

    public void setCommandInt(int command) {
        this.field_70180_af.func_187227_b(COMMAND, (Object)(command % 3));
    }

    public int getCommandInt() {
        return (Integer)this.field_70180_af.func_187225_a(COMMAND);
    }

    public boolean shouldDespawn() {
        return this instanceof ISpecies && this.getHome() != BlockPos.field_177992_a;
    }

    public void func_70623_bb() {
        TileEntity burrow;
        super.func_70623_bb();
        if (this.shouldDespawn() && !this.field_70170_p.func_217358_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (double)((Integer)ConfigMobControl.critterSpawnRange.get()).intValue()) && this instanceof ISpecies && this.getHome() != BlockPos.field_177992_a && (burrow = this.field_70170_p.func_175625_s(this.getHome())) instanceof CritterBurrowBlockEntity) {
            ((CritterBurrowBlockEntity)burrow).tryEnterBurrow((LivingEntity)this);
            burrow.func_70296_d();
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.getHome() != BlockPos.field_177992_a) {
            compound.func_74768_a("HomePosX", this.getHome().func_177958_n());
            compound.func_74768_a("HomePosY", this.getHome().func_177956_o());
            compound.func_74768_a("HomePosZ", this.getHome().func_177952_p());
        }
        if (this.func_70909_n()) {
            compound.func_74768_a("Command", this.getCommandInt());
        }
        compound.func_74768_a("Variant", this.getVariant());
        compound.func_74768_a("Skin", this.getSkin());
        compound.func_74776_a("Size", this.getMobSize());
        compound.func_74768_a("Gender", this.getGender());
        compound.func_74757_a("isAngry", this.isAngry());
        compound.func_74768_a("PeacefulTicks", this.peacefulTicks);
        compound.func_74757_a("Sleeping", this.isMobSleeping());
        compound.func_74757_a("Sitting", this.func_233685_eM_());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("HomePosX")) {
            int i = compound.func_74762_e("HomePosX");
            int j = compound.func_74762_e("HomePosY");
            int k = compound.func_74762_e("HomePosZ");
            this.setHome(new BlockPos(i, j, k));
        }
        if (compound.func_74764_b("OwnerUUID")) {
            this.setCommandInt(compound.func_74762_e("Command"));
        }
        this.setVariant(EntityUtils.getClampedNumberOfSpecies(compound.func_74762_e("Variant"), this.func_200600_R()));
        this.setSkin(compound.func_74762_e("Skin"));
        this.setMobSize(compound.func_74760_g("Size"));
        this.setGender(compound.func_74762_e("Gender"));
        this.setAngry(compound.func_74767_n("isAngry"));
        this.peacefulTicks = compound.func_74762_e("PeacefulTicks");
        this.setMobSleeping(compound.func_74767_n("Sleeping"));
        this.setSitting(compound.func_74767_n("Sitting"));
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (reason != SpawnReason.DISPENSER && reason != SpawnReason.BUCKET) {
            Optional optional;
            if (this instanceof ISpecies && (optional = worldIn.func_242406_i(this.func_233580_cy_())).isPresent()) {
                int i = ((ISpecies)((Object)this)).setSpeciesByBiome((RegistryKey<Biome>)((RegistryKey)optional.get()), worldIn.func_226691_t_(this.func_233580_cy_()), reason);
                this.setVariant(i);
                if (i == 99) {
                    this.func_70106_y();
                    return null;
                }
            }
            this.setGender(this.field_70146_Z.nextInt(2));
            this.setRandomMobSize();
            if (TEXTURES_COMMON.containsKey(this.func_200600_R().getRegistryName().func_110623_a())) {
                this.chooseSkinForSpecies(this, (Boolean)ConfigGamerules.wildRareSkins.get());
            }
            if (this instanceof INeedsPostUpdate) {
                ((INeedsPostUpdate)((Object)this)).updateAttributes();
            }
            this.func_70873_a(0);
        }
        if (this instanceof IPackEntity) {
            IPackEntity.initPack(this);
        }
        return spawnDataIn;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        if (hand == Hand.MAIN_HAND && !this.field_70170_p.func_201670_d()) {
            ItemStack itemstack = player.func_184586_b(hand);
            if (player.func_184812_l_() && itemstack.func_190926_b() && this instanceof IPackEntity && this.herd != null) {
                for (int i = 0; i < this.herd.creatureList.size(); ++i) {
                    ComplexMob creature = this.herd.creatureList.get(i);
                    creature.func_195064_c(new EffectInstance(Effects.field_188423_x, 80, 0));
                }
            }
            if (player.func_184812_l_() && itemstack.func_77973_b().equals(ModItems.FOOD_TURTLE_SOUP.get())) {
                UntamedWilds.LOGGER.info((Object)EntityUtils.writeEntityToNBT((LivingEntity)this));
                UntamedWilds.LOGGER.info((Object)this.getHome());
            }
            if (this.func_70909_n() && this.func_70902_q() == player) {
                if (itemstack.func_190926_b()) {
                    this.setCommandInt(this.getCommandInt() + 1);
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("entity.untamedwilds.command." + this.getCommandInt()), Util.field_240973_b_);
                    if (this.getCommandInt() > 1) {
                        this.func_70661_as().func_75499_g();
                        this.setSitting(true);
                    } else if (this.getCommandInt() <= 1 && this.func_233685_eM_()) {
                        this.setSitting(false);
                    }
                } else {
                    EntityUtils.consumeItemStack(this, itemstack);
                }
            }
            return super.func_230254_b_(player, hand);
        }
        return ActionResultType.PASS;
    }
}

