/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.SwordItem;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IForgeShearable;
import untamedwilds.block.IPostGenUpdate;
import untamedwilds.block.UndergrowthBlock;
import untamedwilds.init.ModBlock;
import untamedwilds.init.ModTags;

public class UndergrowthPoisonousBlock
extends UndergrowthBlock
implements IGrowable,
IPostGenUpdate,
IForgeShearable {
    public static final IntegerProperty PROPERTY_AGE = BlockStateProperties.field_208167_T;

    public UndergrowthPoisonousBlock(AbstractBlock.Properties properties, AbstractBlock.OffsetType type) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(0)));
        this.offset = type;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PROPERTY_AGE});
    }

    @Override
    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof LivingEntity && !entityIn.func_225608_bj_() && entityIn.func_213302_cg() > 1.0f) {
            ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76436_u, 100, 1));
            entityIn.func_213295_a(state, new Vector3d((double)0.95f, 1.0, (double)0.95f));
            if (worldIn.func_201674_k().nextInt(20) == 0) {
                worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187579_bV, SoundCategory.AMBIENT, 1.0f, 1.0f, true);
            }
        }
    }

    @Override
    public AbstractBlock.OffsetType func_176218_Q() {
        return this.offset;
    }

    @Nullable
    public BlockState getStateForWorldgen(ISeedReader world, BlockPos pos) {
        BlockState blockstate = world.func_180495_p(pos.func_177977_b());
        if (blockstate.func_177230_c() == ModBlock.HEMLOCK.get()) {
            BlockState blockstate1;
            if (world.func_204610_c(pos.func_177977_b()).func_206888_e() || world.func_180495_p(pos.func_177979_c(2)).func_177230_c() == ModBlock.HEMLOCK.get()) {
                world.func_180501_a(pos.func_177977_b(), (BlockState)blockstate.getBlockState().func_206870_a((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(1)), 1);
            }
            return (blockstate1 = world.func_180495_p(pos.func_177984_a())).func_177230_c() != ModBlock.HEMLOCK.get() ? (BlockState)((Block)ModBlock.HEMLOCK.get()).func_176223_P().func_206870_a((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(0)) : (BlockState)this.func_176223_P().func_206870_a((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(1));
        }
        if (blockstate.func_235714_a_(ModTags.BlockTags.REEDS_PLANTABLE_ON)) {
            return (BlockState)this.func_176223_P().func_206870_a((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(0));
        }
        return null;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockstate = context.func_195991_k().func_180495_p(context.func_195995_a().func_177977_b());
        if (blockstate.func_177230_c() == ModBlock.HEMLOCK.get()) {
            BlockState blockstate1;
            if (context.func_195991_k().func_204610_c(context.func_195995_a().func_177977_b()).func_206888_e() || context.func_195991_k().func_180495_p(context.func_195995_a().func_177979_c(2)).func_177230_c() == ModBlock.HEMLOCK.get()) {
                context.func_195991_k().func_175656_a(context.func_195995_a().func_177977_b(), (BlockState)blockstate.getBlockState().func_206870_a((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(1)));
            }
            return (blockstate1 = context.func_195991_k().func_180495_p(context.func_195995_a().func_177984_a())).func_177230_c() != ModBlock.HEMLOCK.get() ? (BlockState)((Block)ModBlock.HEMLOCK.get()).func_176223_P().func_206870_a((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(0)) : (BlockState)this.func_176223_P().func_206870_a((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(1));
        }
        if (blockstate.func_235714_a_(ModTags.BlockTags.REEDS_PLANTABLE_ON)) {
            return (BlockState)this.func_176223_P().func_206870_a((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(0));
        }
        return null;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (!state.func_196955_c((IWorldReader)worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_235714_a_(ModTags.BlockTags.REEDS_PLANTABLE_ON) || worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == ModBlock.HEMLOCK.get();
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Override
    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        int j;
        int i = this.getNumReedBlocksAbove(worldIn, pos);
        return i + (j = this.getNumReedBlocksBelow(worldIn, pos)) + 1 < 3;
    }

    @Override
    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    @Override
    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        int i = this.getNumReedBlocksAbove((IBlockReader)worldIn, pos);
        int j = this.getNumReedBlocksBelow((IBlockReader)worldIn, pos);
        int k = i + j + 1;
        int l = 1 + rand.nextInt(2);
        for (int i1 = 0; i1 < l; ++i1) {
            BlockPos blockpos = pos.func_177981_b(i);
            BlockState blockstate = worldIn.func_180495_p(blockpos);
            if (k >= 4 || !worldIn.func_175623_d(blockpos.func_177984_a())) {
                return;
            }
            if ((Integer)blockstate.func_177229_b((Property)PROPERTY_AGE) != 2) {
                worldIn.func_180501_a(blockpos, (BlockState)this.func_176223_P().func_206870_a((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(1)), 3);
            }
            worldIn.func_180501_a(blockpos.func_177984_a(), (BlockState)this.func_176223_P().func_206870_a((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(0)), 3);
            ++i;
            ++k;
        }
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader worldIn, BlockPos pos) {
        return player.func_184614_ca().func_77973_b() instanceof SwordItem ? 1.0f : super.func_180647_a(state, player, worldIn, pos);
    }

    protected int getNumReedBlocksAbove(IBlockReader worldIn, BlockPos pos) {
        int i;
        for (i = 0; i < 4 && worldIn.func_180495_p(pos.func_177981_b(i + 1)).func_177230_c() == ModBlock.HEMLOCK.get(); ++i) {
        }
        return i;
    }

    protected int getNumReedBlocksBelow(IBlockReader worldIn, BlockPos pos) {
        int i;
        for (i = 0; i < 4 && worldIn.func_180495_p(pos.func_177979_c(i + 1)).func_177230_c() == ModBlock.HEMLOCK.get(); ++i) {
        }
        return i;
    }

    @Override
    public void updatePostGen(ISeedReader worldIn, BlockPos pos) {
        if (worldIn.func_201674_k().nextBoolean()) {
            worldIn.func_180501_a(pos, (BlockState)this.func_176223_P().func_206870_a((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(1)), 3);
            worldIn.func_180501_a(pos.func_177984_a(), (BlockState)this.func_176223_P().func_206870_a((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(0)), 3);
        }
    }
}

