/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.pathfinding.PathType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import untamedwilds.block.IPostGenUpdate;
import untamedwilds.init.ModBlock;
import untamedwilds.init.ModItems;
import untamedwilds.init.ModTags;

public class TitanArumBlock
extends Block
implements IGrowable,
IPostGenUpdate {
    protected static final VoxelShape SHAPE_NORMAL = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape SHAPE_SPATHE = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    protected static final VoxelShape SHAPE_CORM = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0);
    public static final IntegerProperty PROPERTY_AGE = BlockStateProperties.field_208169_V;
    public static final IntegerProperty PROPERTY_STAGE = BlockStateProperties.field_208137_al;

    public TitanArumBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(0))).func_206870_a((Property)PROPERTY_STAGE, (Comparable)Integer.valueOf(0)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PROPERTY_AGE, PROPERTY_STAGE});
    }

    public AbstractBlock.OffsetType func_176218_Q() {
        return AbstractBlock.OffsetType.XZ;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if ((Integer)state.func_177229_b((Property)PROPERTY_AGE) == 0) {
            return SHAPE_CORM;
        }
        Vector3d vector3d = state.func_191059_e(worldIn, pos);
        VoxelShape shape = (Integer)state.func_177229_b((Property)PROPERTY_AGE) == 1 && (Integer)state.func_177229_b((Property)PROPERTY_STAGE) == 1 ? SHAPE_NORMAL : SHAPE_SPATHE;
        return shape.func_197751_a(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.func_220053_a(state, worldIn, pos, context);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockstate = context.func_195991_k().func_180495_p(context.func_195995_a().func_177977_b());
        if (blockstate.func_235714_a_(ModTags.BlockTags.REEDS_PLANTABLE_ON)) {
            return (BlockState)this.func_176223_P().func_206870_a((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(0));
        }
        return null;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (!state.func_196955_c((IWorldReader)worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public boolean func_149653_t(BlockState state) {
        return (Integer)state.func_177229_b((Property)PROPERTY_STAGE) == 0;
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        int i;
        if ((Integer)state.func_177229_b((Property)PROPERTY_STAGE) == 0 && rand.nextInt(8) == 0 && worldIn.func_175623_d(pos.func_177984_a()) && worldIn.func_226659_b_(pos.func_177984_a(), 0) >= 9 && (i = this.getNumReedBlocksBelow((IBlockReader)worldIn, pos) + 1) < 4 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (rand.nextInt(3) == 0 ? 1 : 0) != 0)) {
            this.grow(state, (World)worldIn, pos, rand, i);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_235714_a_(ModTags.BlockTags.REEDS_PLANTABLE_ON) || worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == ModBlock.TITAN_ARUM.get();
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        int j;
        int i = this.getNumReedBlocksAbove(worldIn, pos);
        return i + (j = this.getNumReedBlocksBelow(worldIn, pos)) + 1 < 4 && (Integer)worldIn.func_180495_p(pos.func_177981_b(i)).func_177229_b((Property)PROPERTY_STAGE) != 1;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        int i = this.getNumReedBlocksAbove((IBlockReader)worldIn, pos);
        int j = this.getNumReedBlocksBelow((IBlockReader)worldIn, pos);
        int k = i + j + 1;
        if (j < 3) {
            BlockPos blockpos = pos.func_177981_b(i);
            BlockState blockstate = worldIn.func_180495_p(blockpos);
            if (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == ModBlock.TITAN_ARUM.get() || (Integer)blockstate.func_177229_b((Property)PROPERTY_STAGE) == 1 || !worldIn.func_175623_d(blockpos.func_177984_a())) {
                return;
            }
            if (k >= 3) {
                this.makeAreaOfEffectCloud((World)worldIn, pos);
                for (i = 0; i < 3 && worldIn.func_180495_p(pos.func_177981_b(i)).func_177230_c() == ModBlock.TITAN_ARUM.get(); ++i) {
                    worldIn.func_180501_a(pos.func_177981_b(i), (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)PROPERTY_AGE, worldIn.func_180495_p(pos.func_177981_b(i)).func_177229_b((Property)PROPERTY_AGE))).func_206870_a((Property)PROPERTY_STAGE, (Comparable)Integer.valueOf(1)), 3);
                }
                i = pos.func_177956_o();
                if (i >= 1 && i + 1 < 256) {
                    for (int n = 0; n < 3; ++n) {
                        if (!worldIn.func_180495_p(pos = pos.func_177982_a(rand.nextInt(3) - 1, 0, rand.nextInt(3) - 1)).canBeReplacedByLeaves((IWorldReader)worldIn, pos) || !blockstate.func_196955_c((IWorldReader)worldIn, pos)) continue;
                        worldIn.func_180501_a(pos, (BlockState)((Block)ModBlock.TITAN_ARUM.get()).func_176223_P().func_206870_a((Property)PROPERTY_STAGE, (Comparable)Integer.valueOf(1)), 2);
                    }
                }
                return;
            }
            this.grow(blockstate, (World)worldIn, blockpos, rand, k);
        }
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader worldIn, BlockPos pos) {
        return player.func_184614_ca().func_77973_b() instanceof SwordItem ? 1.0f : super.func_180647_a(state, player, worldIn, pos);
    }

    protected void grow(BlockState blockStateIn, World worldIn, BlockPos posIn, Random rand, int p_220258_5_) {
        int l = (Integer)blockStateIn.func_177229_b((Property)PROPERTY_AGE);
        if (l == 0) {
            worldIn.func_175656_a(posIn, (BlockState)this.func_176223_P().func_206870_a((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(1)));
        } else {
            worldIn.func_180501_a(posIn.func_177984_a(), (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(Math.min(3, l + 1)))).func_206870_a((Property)PROPERTY_STAGE, (Comparable)Integer.valueOf(0)), 3);
        }
    }

    protected int getNumReedBlocksAbove(IBlockReader worldIn, BlockPos pos) {
        int i;
        for (i = 0; i < 4 && worldIn.func_180495_p(pos.func_177981_b(i + 1)).func_177230_c() == ModBlock.TITAN_ARUM.get(); ++i) {
        }
        return i;
    }

    protected int getNumReedBlocksBelow(IBlockReader worldIn, BlockPos pos) {
        int i;
        for (i = 0; i < 4 && worldIn.func_180495_p(pos.func_177979_c(i + 1)).func_177230_c() == ModBlock.TITAN_ARUM.get(); ++i) {
        }
        return i;
    }

    private void makeAreaOfEffectCloud(World worldIn, BlockPos pos) {
        AreaEffectCloudEntity areaeffectcloudentity = new AreaEffectCloudEntity(worldIn, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() - (Integer)worldIn.func_180495_p(pos).func_177229_b((Property)PROPERTY_AGE)), (double)pos.func_177952_p() + 0.5);
        areaeffectcloudentity.func_184483_a(6.0f);
        areaeffectcloudentity.func_184495_b(-0.2f);
        areaeffectcloudentity.func_184485_d(10);
        areaeffectcloudentity.func_184487_c(-areaeffectcloudentity.func_184490_j() / ((float)areaeffectcloudentity.func_184489_o() * 0.5f));
        areaeffectcloudentity.func_184482_a(5599028);
        areaeffectcloudentity.func_184496_a(new EffectInstance(Effects.field_76431_k, 80, 0, true, false));
        worldIn.func_217376_c((Entity)areaeffectcloudentity);
    }

    protected IItemProvider getSeedsItem() {
        return (IItemProvider)ModItems.SEED_TITAN_ARUM.get();
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack(this.getSeedsItem());
    }

    @Override
    public void updatePostGen(ISeedReader worldIn, BlockPos pos) {
        for (int i = 0; i < 3 && (worldIn.func_180495_p(pos.func_177981_b(i)).canBeReplacedByLeaves((IWorldReader)worldIn, pos.func_177981_b(i)) || worldIn.func_180495_p(pos.func_177981_b(i)).func_177230_c() == ModBlock.TITAN_ARUM.get()); ++i) {
            worldIn.func_180501_a(pos.func_177981_b(i), (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(i + 1))).func_206870_a((Property)PROPERTY_STAGE, (Comparable)Integer.valueOf(1)), 3);
        }
    }
}

