/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.block;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import untamedwilds.block.blockentity.CritterBurrowBlockEntity;

public class CritterBurrowBlock
extends Block
implements IWaterLoggable {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public CritterBurrowBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WATERLOGGED});
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return SHAPE;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return CritterBurrowBlock.func_220064_c((IBlockReader)worldIn, (BlockPos)pos.func_177977_b());
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        if (!this.func_196260_a(stateIn, (IWorldReader)worldIn, currentPos)) {
            worldIn.func_175655_b(currentPos, false);
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader worldIn) {
        return new CritterBurrowBlockEntity();
    }

    public void func_220062_a(BlockState state, ServerWorld worldIn, BlockPos pos, ItemStack stack) {
        super.func_220062_a(state, worldIn, pos, stack);
    }

    public int getExpDrop(BlockState state, IWorldReader world, BlockPos pos, int fortune, int silktouch) {
        return 10 + this.RANDOM.nextInt(10);
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return ItemStack.field_190927_a;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K || hand.equals((Object)Hand.OFF_HAND)) {
            return ActionResultType.FAIL;
        }
        CritterBurrowBlockEntity te = (CritterBurrowBlockEntity)worldIn.func_175625_s(pos);
        if (playerIn.func_184812_l_() && te != null) {
            if (playerIn.func_225608_bj_()) {
                te.cooldown = 1;
            } else {
                playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("This burrow contains " + te.getEntityType().func_210760_d()).func_240699_a_(TextFormatting.ITALIC), playerIn.func_110124_au());
                playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("The variant is " + te.getVariant()).func_240699_a_(TextFormatting.ITALIC), playerIn.func_110124_au());
                playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("There are " + (te.getInhabitants().size() + te.getCount()) + " mobs inside the burrow (" + te.getInhabitants().size() + " stored, and " + te.getCount() + " to be spawned)").func_240699_a_(TextFormatting.ITALIC), playerIn.func_110124_au());
            }
        } else {
            playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("block.burrow.state", new Object[]{te.getEntityType().func_212546_e().getString()}), true);
        }
        return ActionResultType.SUCCESS;
    }
}

