function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile(
			'coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'net/minecraft/block/AbstractBlock$AbstractBlockState',
		'methodName' : resolveName('func_227034_b_'), // randomTick
		'methodDesc' : '(Lnet/minecraft/world/server/ServerWorld;Lnet/minecraft/util/math/BlockPos;Ljava/util/Random;)V'
	}

	var handler = {
		'class' : 'com/endertech/minecraft/forge/events/RandomTickEvent',
		'methodName' : 'onRandomTickBlock',
		'methodDesc' : '(Lnet/minecraft/world/server/ServerWorld;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;)Z'
	}

	var asState = {
		'class' : 'net/minecraft/block/AbstractBlock$AbstractBlockState',
		'methodName' : resolveName('func_230340_p_'), // asState (!mcp getSelf)
		'methodDesc' : '()Lnet/minecraft/block/BlockState;'
	}

    var instructions = [
        insnLoadObj(1, "world"),
        insnLoadObj(2, "pos"),
		insnLoadObj(0, "state"),
		insnInvokeVirtual(asState),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsBeforeAll(method, instructions.concat(instructionsIfTrueReturn()));
				return method;
			}
		}
	}
}