/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.region.texture;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.lwjgl.opengl.GL11;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.biome.BiomeColorCalculator;
import xaero.map.cache.BlockStateShortShapeCache;
import xaero.map.exception.OpenGLException;
import xaero.map.graphics.TextureUploader;
import xaero.map.misc.BufferCompatibilityFix;
import xaero.map.misc.Misc;
import xaero.map.region.LeveledRegion;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTileChunk;
import xaero.map.region.OverlayManager;
import xaero.map.region.texture.BranchTextureRenderer;
import xaero.map.region.texture.RegionTexture;

public class LeafRegionTexture
extends RegionTexture<LeafRegionTexture> {
    private MapTileChunk tileChunk;

    public LeafRegionTexture(MapTileChunk tileChunk) {
        super(tileChunk.getInRegion());
        this.tileChunk = tileChunk;
    }

    public void postBufferUpdate(boolean hasLight) {
        this.colorBufferFormat = -1;
        this.colorBufferCompressed = false;
        this.bufferHasLight = hasLight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preUpload(MapProcessor mapProcessor, BiomeColorCalculator biomeColorCalculator, OverlayManager overlayManager, LeveledRegion<LeafRegionTexture> leveledRegion, boolean detailedDebug, BlockStateShortShapeCache blockStateShortShapeCache) {
        MapRegion region = (MapRegion)leveledRegion;
        if (this.tileChunk.getToUpdateBuffers() && !mapProcessor.isWritingPaused()) {
            Object object = region.writerThreadPauseSync;
            synchronized (object) {
                if (!region.isWritingPaused()) {
                    this.tileChunk.updateBuffers(mapProcessor, biomeColorCalculator, overlayManager, detailedDebug, blockStateShortShapeCache);
                }
            }
        }
    }

    @Override
    public void postUpload(MapProcessor mapProcessor, LeveledRegion<LeafRegionTexture> leveledRegion, boolean cleanAndCacheRequestsBlocked) {
        MapRegion region = (MapRegion)leveledRegion;
        if (!(region.getLoadState() < 2 || region.isBeingWritten() || region.getLastVisited() != 0L && region.getTimeSinceVisit() <= 1000L || cleanAndCacheRequestsBlocked || this.tileChunk.getToUpdateBuffers() || this.tileChunk.getLoadState() == 3)) {
            region.setLoadState((byte)3);
            this.tileChunk.setLoadState((byte)3);
            this.tileChunk.clean(mapProcessor);
        }
    }

    @Override
    public boolean canUpload() {
        return this.tileChunk.getLoadState() >= 2;
    }

    @Override
    public boolean isUploaded() {
        return super.isUploaded() && !this.tileChunk.getToUpdateBuffers();
    }

    @Override
    public boolean hasSourceData() {
        return this.tileChunk.getLoadState() != 3;
    }

    @Override
    protected long uploadNonCache(TextureUploader textureUploader, BranchTextureRenderer unused) {
        long totalEstimatedTime;
        this.writeToUnpackPBO(0, this.colorBuffer);
        if (this.textureVersion == -1) {
            this.updateTextureVersion(this.bufferedTextureVersion != -1 ? this.bufferedTextureVersion + 1 : 1 + (int)(Math.random() * 1000000.0));
        } else {
            this.updateTextureVersion(this.textureVersion + 1);
        }
        this.textureHasLight = this.bufferHasLight;
        if (WorldMap.settings.compression) {
            this.timer = 5;
            this.shouldDownloadFromPBO = true;
            this.bindPackPBO();
            this.unbindPackPBO();
            this.bindColorTexture(true, 9728);
            OpenGLException.checkGLError();
            totalEstimatedTime = textureUploader.requestNormalWithDownload(this.glColorTexture, this.unpackPbo[0], 3553, 0, 34030, 64, 64, 0, 0L, 32993, 32821, this.packPbo);
        } else {
            BufferCompatibilityFix.position(this.colorBuffer, 0);
            this.colorBufferFormat = 32856;
            this.bufferedTextureVersion = this.textureVersion;
            this.bindColorTexture(true, 9728);
            OpenGLException.checkGLError();
            totalEstimatedTime = textureUploader.requestNormal(this.glColorTexture, this.unpackPbo[0], 3553, 0, 32856, 64, 64, 0, 0L, 32993, 32821);
        }
        boolean toUploadImmediately = this.tileChunk.getInRegion().isBeingWritten();
        if (toUploadImmediately) {
            textureUploader.finishNewestRequestImmediately();
        }
        return totalEstimatedTime;
    }

    @Override
    protected void updateTextureVersion(int newVersion) {
        super.updateTextureVersion(newVersion);
        this.region.updateLeafTextureVersion(this.tileChunk.getX() & 7, this.tileChunk.getZ() & 7, newVersion);
    }

    @Override
    public void addDebugLines(List<String> lines) {
        super.addDebugLines(lines);
        lines.add(this.tileChunk.getX() + " " + this.tileChunk.getZ());
        lines.add("loadState: " + this.tileChunk.getLoadState());
        lines.add(String.format("changed: %s include: %s", this.tileChunk.wasChanged(), this.tileChunk.includeInSave()));
    }

    @Override
    protected void onDownloadedBuffer(ByteBuffer mappedPBO, int isCompressed) {
        int length = isCompressed == 1 ? GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)34464) : 16384;
        BufferCompatibilityFix.clear(this.colorBuffer);
        BufferCompatibilityFix.limit(mappedPBO, length);
        this.colorBuffer.put(mappedPBO);
        BufferCompatibilityFix.flip(this.colorBuffer);
    }

    @Override
    public void writeCacheMapData(DataOutputStream output, byte[] usableBuffer, byte[] integerByteBuffer, LeveledRegion<LeafRegionTexture> inRegion) throws IOException {
        super.writeCacheMapData(output, usableBuffer, integerByteBuffer, inRegion);
        this.tileChunk.writeCacheData(output, usableBuffer, integerByteBuffer, inRegion);
    }

    @Override
    public void readCacheData(int cacheSaveVersion, DataInputStream input, byte[] usableBuffer, byte[] integerByteBuffer, LeveledRegion<LeafRegionTexture> inRegion, MapProcessor mapProcessor, int x, int y) throws IOException {
        super.readCacheData(cacheSaveVersion, input, usableBuffer, integerByteBuffer, inRegion, mapProcessor, x, y);
        this.tileChunk.readCacheData(cacheSaveVersion, input, usableBuffer, integerByteBuffer, mapProcessor, x, y);
    }

    public void resetHeights() {
        Misc.clearHeightsData586(this.heightValues.getData());
        Misc.clearHeightsData586(this.topHeightValues.getData());
    }

    @Override
    public boolean shouldBeUsedForBranchUpdate(int usedVersion) {
        return this.tileChunk.getLoadState() != 1 && super.shouldBeUsedForBranchUpdate(usedVersion);
    }

    @Override
    public boolean shouldHaveContentForBranchUpdate() {
        return this.tileChunk.getLoadState() > 0 && super.shouldHaveContentForBranchUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteTexturesAndBuffers() {
        LeveledRegion leveledRegion = this.region.getLevel() == 3 ? this.region : this.region.getParent();
        synchronized (leveledRegion) {
            LeveledRegion leveledRegion2 = this.region;
            synchronized (leveledRegion2) {
                this.tileChunk.setLoadState((byte)0);
            }
        }
        super.deleteTexturesAndBuffers();
    }
}

