/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.region;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import xaero.map.MapProcessor;
import xaero.map.MapWriter;
import xaero.map.WorldMap;
import xaero.map.biome.BiomeColorCalculator;
import xaero.map.biome.BiomeKey;
import xaero.map.cache.BlockStateShortShapeCache;
import xaero.map.region.MapPixel;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;
import xaero.map.region.Overlay;
import xaero.map.region.OverlayManager;

public class MapBlock
extends MapPixel {
    protected boolean slopeUnknown = true;
    private byte verticalSlope;
    private byte diagonalSlope;
    private byte signed_height;
    private byte signed_topHeight;
    private ArrayList<Overlay> overlays;
    private boolean caveBlock = false;
    private BiomeKey biome = null;

    public boolean isGrass() {
        return this.state.func_177230_c() == Blocks.field_196658_i;
    }

    public int getParametres() {
        int parametres = 0;
        parametres |= !this.isGrass() ? 1 : 0;
        parametres |= this.getNumberOfOverlays() != 0 ? 2 : 0;
        parametres |= this.colourType << 2;
        parametres |= this.caveBlock ? 128 : 0;
        parametres |= this.light << 8;
        parametres |= this.getHeight() << 12;
        parametres |= this.biome != null ? 0x100000 : 0;
        return parametres |= this.signed_height != this.signed_topHeight ? 0x1000000 : 0;
    }

    public void getPixelColour(int[] result_dest, MapWriter mapWriter, World world, MapTileChunk tileChunk, MapTileChunk prevChunk, MapTileChunk prevChunkDiagonal, MapTileChunk prevChunkHorisontal, MapTile mapTile, int x, int z, BlockPos.Mutable mutableGlobalPos, MutableRegistry<Biome> biomeRegistry, float shadowR, float shadowG, float shadowB, BiomeColorCalculator biomeColorCalculator, MapProcessor mapProcessor, OverlayManager overlayManager, int effectiveHeight, BlockStateShortShapeCache blockStateShortShapeCache) {
        super.getPixelColours(result_dest, mapWriter, world, tileChunk, prevChunk, prevChunkDiagonal, prevChunkHorisontal, mapTile, x, z, this, effectiveHeight, this.overlays, mutableGlobalPos, biomeRegistry, shadowR, shadowG, shadowB, biomeColorCalculator, mapProcessor, overlayManager, blockStateShortShapeCache);
    }

    public String toRenderString(MutableRegistry<Biome> biomeRegistry) {
        return (Block.field_176229_d.func_148745_a(Block.field_176229_d.func_148757_b((Object)this.getState())) == this.getState()) + " S: " + this.getState() + ", VS: " + this.verticalSlope + ", DS: " + this.diagonalSlope + ", SU: " + this.slopeUnknown + ", H: " + this.getHeight() + ", CT: " + this.colourType + ", B: " + (this.biome == null ? "null" : this.biome.getIdentifier(biomeRegistry)) + ", CC: " + this.customColour + ", L: " + this.light + ", G: " + this.glowing + ", CB: " + this.caveBlock + ", O: " + this.getNumberOfOverlays();
    }

    public boolean equalsSlopesExcluded(MapBlock p) {
        boolean equal;
        boolean bl = equal = p != null && this.state == p.state && this.colourType == p.colourType && this.light == p.light && this.signed_height == p.signed_height && this.signed_topHeight == p.signed_topHeight && this.caveBlock == p.caveBlock && this.getNumberOfOverlays() == p.getNumberOfOverlays() && this.biome == p.biome && (this.colourType != 3 || this.customColour == p.customColour);
        if (equal && this.getNumberOfOverlays() != 0) {
            for (int i = 0; i < this.overlays.size(); ++i) {
                if (this.overlays.get(i).equals(p.overlays.get(i))) continue;
                return false;
            }
        }
        return equal;
    }

    public boolean equals(MapBlock p, boolean equalsSlopesExcluded) {
        return p != null && this.verticalSlope == p.verticalSlope && this.diagonalSlope == p.diagonalSlope && this.slopeUnknown == p.slopeUnknown && equalsSlopesExcluded;
    }

    public void fixHeightType(int x, int z, MapTile mapTile, MapTileChunk tileChunk, MapTileChunk prevChunk, MapTileChunk prevChunkDiagonal, MapTileChunk prevChunkHorisontal, int height, boolean useSourceData, BlockStateShortShapeCache blockStateShortShapeCache) {
        int prevHeight = -1;
        int prevHeightDiagonal = -1;
        if (useSourceData && z > 0) {
            prevHeight = mapTile.getBlock(x, z - 1).getEffectiveHeight(blockStateShortShapeCache);
            if (x > 0) {
                prevHeightDiagonal = mapTile.getBlock(x - 1, z - 1).getEffectiveHeight(blockStateShortShapeCache);
            }
        }
        if (prevHeight == -1 || prevHeightDiagonal == -1) {
            boolean horisontalEdge;
            int inTileChunkX = ((mapTile.getChunkX() & 3) << 4) + x;
            int inTileChunkZ = ((mapTile.getChunkZ() & 3) << 4) + z;
            int inTileChunkXPrev = inTileChunkX - 1;
            int inTileChunkZPrev = inTileChunkZ - 1;
            MapTileChunk verticalSlopeSrc = tileChunk;
            MapTileChunk diagonalSlopeSrc = tileChunk;
            boolean verticalEdge = inTileChunkZPrev < 0;
            boolean bl = horisontalEdge = inTileChunkXPrev < 0;
            if (verticalEdge) {
                verticalSlopeSrc = diagonalSlopeSrc = prevChunk;
                inTileChunkZPrev = 63;
            }
            if (horisontalEdge) {
                inTileChunkXPrev = 63;
                MapTileChunk mapTileChunk = diagonalSlopeSrc = verticalEdge ? prevChunkDiagonal : prevChunkHorisontal;
            }
            if (prevHeight == -1 && verticalSlopeSrc != null && verticalSlopeSrc.getLoadState() >= 2) {
                prevHeight = verticalSlopeSrc.getLeafTexture().getHeight(inTileChunkX, inTileChunkZPrev);
            }
            if (prevHeightDiagonal == -1 && diagonalSlopeSrc != null && diagonalSlopeSrc.getLoadState() >= 2) {
                prevHeightDiagonal = diagonalSlopeSrc.getLeafTexture().getHeight(inTileChunkXPrev, inTileChunkZPrev);
            }
            if (prevHeight == -1 || prevHeightDiagonal == -1) {
                if (useSourceData) {
                    return;
                }
                int reX = x < 15 ? x + 1 : x;
                int reZ = z < 15 ? z + 1 : z;
                int inTileChunkReX = ((mapTile.getChunkX() & 3) << 4) + reX;
                int inTileChunkReZ = ((mapTile.getChunkZ() & 3) << 4) + reZ;
                int reHeight = tileChunk.getLeafTexture().getHeight(inTileChunkReX, inTileChunkReZ);
                if (reHeight != -1) {
                    this.fixHeightType(reX, reZ, mapTile, tileChunk, prevChunk, prevChunkDiagonal, prevChunkHorisontal, reHeight, useSourceData, blockStateShortShapeCache);
                }
                return;
            }
        }
        this.verticalSlope = (byte)Math.max(-128, Math.min(127, height - prevHeight));
        this.diagonalSlope = (byte)Math.max(-128, Math.min(127, height - prevHeightDiagonal));
        this.slopeUnknown = false;
    }

    public void prepareForWriting() {
        if (this.overlays != null) {
            this.overlays.clear();
        }
        this.customColour = 0;
        this.colourType = 0;
        this.biome = null;
        this.state = Blocks.field_150350_a.func_176223_P();
        this.slopeUnknown = true;
        this.light = 0;
        this.glowing = false;
        this.signed_height = 0;
        this.signed_topHeight = 0;
    }

    public void write(BlockState state, int height, int topHeight, int[] biomeStuff, BiomeKey biomeIn, byte light, boolean glowing, boolean cave) {
        this.state = state;
        this.setHeight(height);
        this.setTopHeight(topHeight);
        this.setColourType((byte)biomeStuff[0]);
        if (biomeIn != null) {
            this.biome = biomeIn;
        }
        this.setCustomColour(biomeStuff[2]);
        this.light = light;
        this.glowing = glowing;
        boolean bl = this.caveBlock = cave && !glowing;
        if (this.overlays != null && this.overlays.isEmpty()) {
            this.overlays = null;
        }
    }

    public void addOverlay(Overlay o) {
        if (this.overlays == null) {
            this.overlays = new ArrayList();
        }
        this.overlays.add(o);
    }

    public int getHeight() {
        return this.signed_height & 0xFF;
    }

    public byte getSignedHeight() {
        return this.signed_height;
    }

    public void setHeight(int h) {
        this.signed_height = (byte)h;
    }

    public int getTopHeight() {
        return this.signed_topHeight & 0xFF;
    }

    public byte getSignedTopHeight() {
        return this.signed_topHeight;
    }

    public void setTopHeight(int h) {
        this.signed_topHeight = (byte)h;
    }

    public int getEffectiveHeight(BlockStateShortShapeCache blockStateShortShapeCache) {
        int height = this.getHeight();
        if (WorldMap.settings.adjustHeightForCarpetLikeBlocks && blockStateShortShapeCache.isShort(this.state)) {
            --height;
        }
        return height;
    }

    public int getEffectiveHeight(boolean subtractOne) {
        int height = this.getHeight();
        if (subtractOne) {
            --height;
        }
        return height;
    }

    public int getEffectiveTopHeight(boolean subtractOne) {
        int topHeight = this.getTopHeight();
        if (subtractOne && topHeight == this.getHeight()) {
            --topHeight;
        }
        return topHeight;
    }

    public BiomeKey getBiome() {
        return this.biome;
    }

    public void setBiome(BiomeKey biome) {
        this.biome = biome;
    }

    public ArrayList<Overlay> getOverlays() {
        return this.overlays;
    }

    public byte getVerticalSlope() {
        return this.verticalSlope;
    }

    public void setVerticalSlope(byte slope) {
        this.verticalSlope = slope;
    }

    public byte getDiagonalSlope() {
        return this.diagonalSlope;
    }

    public void setDiagonalSlope(byte slope) {
        this.diagonalSlope = slope;
    }

    public void setSlopeUnknown(boolean slopeUnknown) {
        this.slopeUnknown = slopeUnknown;
    }

    public boolean isCaveBlock() {
        return this.caveBlock;
    }

    public void setCaveBlock(boolean caveBlock) {
        this.caveBlock = caveBlock;
    }

    public int getNumberOfOverlays() {
        return this.overlays == null ? 0 : this.overlays.size();
    }
}

