/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.biome;

import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.level.ColorResolver;
import xaero.map.MapProcessor;
import xaero.map.biome.BiomeKey;
import xaero.map.biome.BiomeKeyManager;
import xaero.map.cache.BlockStateColorTypeCache;
import xaero.map.region.MapTile;

public class BiomeColorCalculator {
    public final BiomeKey UNREACHABLE_BIOME;
    public final BiomeKey RIVER_BIOME;
    private BiomeKeyManager biomeKeyManager;

    public BiomeColorCalculator(BiomeKeyManager biomeKeyManager) {
        this.UNREACHABLE_BIOME = biomeKeyManager.get("xaeroworldmap:unreachable_biome");
        this.RIVER_BIOME = biomeKeyManager.get(Biomes.field_76781_i.func_240901_a_().toString());
        this.biomeKeyManager = biomeKeyManager;
    }

    public int getBiomeColor(BlockState state, boolean overlay, BlockPos.Mutable pos, MapTile tile, World world, MutableRegistry<Biome> biomeRegistry, MapProcessor mapProcessor, BlockStateColorTypeCache blockStateColorTypeCache) {
        int i = 0;
        int j = 0;
        int k = 0;
        int total = 0;
        int initX = pos.func_177958_n();
        int initZ = pos.func_177952_p();
        ColorResolver stateColorResolver = blockStateColorTypeCache.getColorResolver(state);
        if (stateColorResolver == null) {
            return -1;
        }
        for (int o = -1; o < 2; ++o) {
            for (int p = -1; p < 2; ++p) {
                if (o != 0 && p != 0) continue;
                pos.func_181079_c(initX + o, pos.func_177956_o(), initZ + p);
                BiomeKey b = this.getBiomeAtPos((BlockPos)pos, tile, mapProcessor);
                if (b == this.UNREACHABLE_BIOME) continue;
                if (b == null && overlay) {
                    b = this.RIVER_BIOME;
                }
                if (b == null) continue;
                int l = 0;
                Biome gen = this.biomeKeyManager.getBiome(b, biomeRegistry);
                if (gen == null) {
                    gen = world.func_226691_t_((BlockPos)pos);
                }
                if (gen == null) continue;
                l = stateColorResolver.getColor(gen, (double)pos.func_177958_n(), (double)pos.func_177952_p());
                i += l & 0xFF0000;
                j += l & 0xFF00;
                k += l & 0xFF;
                ++total;
            }
        }
        pos.func_181079_c(initX, pos.func_177956_o(), initZ);
        if (total == 0) {
            Biome defaultBiome = (Biome)biomeRegistry.func_230516_a_(Biomes.field_76781_i);
            if (defaultBiome == null) {
                return -1;
            }
            return stateColorResolver.getColor(defaultBiome, (double)pos.func_177958_n(), (double)pos.func_177952_p());
        }
        return i / total & 0xFF0000 | j / total & 0xFF00 | k / total;
    }

    public BiomeKey getBiomeAtPos(BlockPos pos, MapTile centerTile, MapProcessor mapProcessor) {
        MapTile tile;
        int tileX = pos.func_177958_n() >> 4;
        int tileZ = pos.func_177952_p() >> 4;
        MapTile mapTile = tile = tileX == centerTile.getChunkX() && tileZ == centerTile.getChunkZ() ? centerTile : mapProcessor.getMapTile(tileX, tileZ);
        if (tile != null && tile.isLoaded()) {
            return tile.getBlock(pos.func_177958_n() & 0xF, pos.func_177952_p() & 0xF).getBiome();
        }
        return this.UNREACHABLE_BIOME;
    }
}

