/*
 * Decompiled with CFR 0.152.
 */
package xaero.map;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import xaero.map.MapProcessor;
import xaero.map.MapWriter;
import xaero.map.WorldMap;
import xaero.map.biome.BiomeColorCalculator;
import xaero.map.biome.BiomeKeyManager;
import xaero.map.cache.BlockStateColorTypeCache;
import xaero.map.cache.BlockStateShortShapeCache;
import xaero.map.controls.ControlsHandler;
import xaero.map.core.IWorldMapClientPlayNetHandler;
import xaero.map.core.XaeroWorldMapCore;
import xaero.map.file.MapSaveLoad;
import xaero.map.file.worldsave.WorldDataHandler;
import xaero.map.file.worldsave.WorldDataReader;
import xaero.map.graphics.TextureUploader;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;

public class WorldMapSession {
    private ControlsHandler controlsHandler;
    private MapProcessor mapProcessor;
    private MapWriter mapWriter;
    private MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers;
    private boolean usable;

    public void init() throws NoSuchFieldException {
        BiomeKeyManager biomeKeyManager = new BiomeKeyManager();
        BlockStateShortShapeCache blockStateShortShapeCache = new BlockStateShortShapeCache();
        MapSaveLoad mapSaveLoad = new MapSaveLoad(WorldMap.overlayManager, WorldMap.pngExporter, WorldMap.oldFormatSupport, biomeKeyManager, blockStateShortShapeCache);
        TextureUploader textureUploader = new TextureUploader(WorldMap.normalTextureUploadPool, WorldMap.normalWithDownloadTextureUploadPool, WorldMap.compressedTextureUploadPool, WorldMap.branchUpdatePool, WorldMap.branchUpdateAllocatePool, WorldMap.branchDownloadPool, WorldMap.textureUploadBenchmark);
        BlockStateColorTypeCache blockStateColorTypeCache = new BlockStateColorTypeCache(biomeKeyManager);
        blockStateColorTypeCache.updateGrassColor();
        BiomeColorCalculator biomeColorCalculator = new BiomeColorCalculator(biomeKeyManager);
        WorldDataReader worldDataReader = new WorldDataReader(WorldMap.overlayManager, blockStateColorTypeCache, biomeKeyManager, blockStateShortShapeCache);
        WorldDataHandler worldDataHandler = new WorldDataHandler(worldDataReader);
        this.multiTextureRenderTypeRenderers = new MultiTextureRenderTypeRendererProvider(2);
        this.mapWriter = new MapWriter(WorldMap.overlayManager, blockStateColorTypeCache, blockStateShortShapeCache);
        this.mapProcessor = new MapProcessor(mapSaveLoad, this.mapWriter, WorldMap.mapLimiter, WorldMap.bufferDeallocator, WorldMap.tilePool, WorldMap.overlayManager, textureUploader, worldDataHandler, WorldMap.worldMapClient.branchTextureRenderer, this.multiTextureRenderTypeRenderers, WorldMap.worldMapClient.customVertexConsumers, biomeColorCalculator, blockStateColorTypeCache, blockStateShortShapeCache);
        this.mapWriter.setMapProcessor(this.mapProcessor);
        mapSaveLoad.setMapProcessor(this.mapProcessor);
        worldDataReader.setMapProcessor(this.mapProcessor);
        this.controlsHandler = new ControlsHandler(this.mapProcessor);
        this.mapProcessor.onInit();
        this.usable = true;
        System.out.println("New world map session initialized!");
    }

    public void cleanup() {
        try {
            if (this.usable) {
                this.mapProcessor.stop();
                System.out.println("Finalizing world map session...");
                WorldMap.mapRunnerThread.interrupt();
                while (!this.mapProcessor.isFinished()) {
                    this.mapProcessor.waitForLoadingToFinish(() -> {});
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            System.out.println("World map session finalized.");
        }
        catch (Throwable t) {
            System.out.println("World map session failed to finalize properly.");
            t.printStackTrace();
        }
        this.usable = false;
    }

    public ControlsHandler getControlsHandler() {
        return this.controlsHandler;
    }

    public MapProcessor getMapProcessor() {
        return this.mapProcessor;
    }

    public static WorldMapSession getCurrentSession() {
        WorldMapSession session = WorldMapSession.getForPlayer(Minecraft.func_71410_x().field_71439_g);
        if (session == null && XaeroWorldMapCore.currentSession != null && XaeroWorldMapCore.currentSession.usable) {
            session = XaeroWorldMapCore.currentSession;
        }
        return session;
    }

    public static WorldMapSession getForPlayer(ClientPlayerEntity player) {
        if (player == null || player.field_71174_a == null) {
            return null;
        }
        return ((IWorldMapClientPlayNetHandler)player.field_71174_a).getXaero_worldmapSession();
    }

    public boolean isUsable() {
        return this.usable;
    }
}

