/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.toolswapper;

import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.extensions.IForgeItemStack;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.ToolRegistry;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.FilterLogicBase;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;

public class ToolSwapperFilterLogic
extends FilterLogicBase {
    private ItemStack weaponFilter;
    private final Map<ToolType, ItemStack> toolFilters = new TreeMap<ToolType, ItemStack>(Comparator.comparing(ToolType::getName));

    public ToolSwapperFilterLogic(ItemStack upgrade, Consumer<ItemStack> saveHandler) {
        super(upgrade, saveHandler, "");
        this.weaponFilter = NBTHelper.getCompound(upgrade, "weaponFilter").map(ItemStack::func_199557_a).orElse(ItemStack.field_190927_a);
        ToolRegistry.getToolTypes().forEach((name, tt) -> this.toolFilters.put((ToolType)tt, ItemStack.field_190927_a));
        this.loadToolFilters();
    }

    public ItemStack getWeaponFilter() {
        return this.weaponFilter;
    }

    public ItemStack getToolFilter(ToolType toolType) {
        return this.toolFilters.get(toolType);
    }

    public Set<ToolType> getToolFilterTypes() {
        return this.toolFilters.keySet();
    }

    private void loadToolFilters() {
        NBTHelper.getMap(this.upgrade, "toolFilters", key -> key, (key, nbt) -> ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)nbt))).ifPresent(savedToolFilters -> savedToolFilters.forEach((key, stack) -> {
            Map<String, ToolType> toolTypes = ToolRegistry.getToolTypes();
            if (toolTypes.containsKey(key)) {
                this.toolFilters.put(toolTypes.get(key), (ItemStack)stack);
            }
        }));
    }

    public boolean matchesWeaponFilter(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77976_d() == 1 && this.isAllowList() == this.stackMatchesFilter(stack, this.weaponFilter);
    }

    public boolean matchesToolFilter(ItemStack stack, ToolType toolType) {
        return !stack.func_190926_b() && stack.func_77976_d() == 1 && this.isAllowList() == this.stackMatchesFilter(stack, this.toolFilters.getOrDefault(toolType, ItemStack.field_190927_a));
    }

    public void setWeaponFilter(ItemStack stack) {
        this.weaponFilter = stack;
        NBTHelper.setCompoundNBT(this.upgrade, "weaponFilter", stack.serializeNBT());
        this.save();
    }

    public void setToolFilter(ToolType toolType, ItemStack stack) {
        this.toolFilters.put(toolType, stack);
        NBTHelper.setMap(this.upgrade, "toolFilters", this.toolFilters, ToolType::getName, IForgeItemStack::serializeNBT);
        this.save();
    }
}

