/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.common.gui;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.ISlotChangeResponseUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackInventoryHandler;

public class BackpackInventorySlot
extends Slot {
    private static final IInventory EMPTY_INVENTORY = new Inventory(0);
    private final boolean isClientSide;
    private final IBackpackWrapper backpackWrapper;
    private final BackpackInventoryHandler inventoryHandler;
    private final int slotIndex;

    public BackpackInventorySlot(boolean isClientSide, IBackpackWrapper backpackWrapper, BackpackInventoryHandler inventoryHandler, int slotIndex, int lineIndex, int yPosition) {
        super(EMPTY_INVENTORY, slotIndex, 8 + lineIndex * 18, yPosition);
        this.isClientSide = isClientSide;
        this.backpackWrapper = backpackWrapper;
        this.inventoryHandler = inventoryHandler;
        this.slotIndex = slotIndex;
    }

    public void func_75218_e() {
        super.func_75218_e();
        this.backpackWrapper.getInventoryHandler().onContentsChanged(this.slotIndex);
        this.processSlotChangeResponse(this.slotIndex, (IItemHandler)this.backpackWrapper.getInventoryHandler(), this.backpackWrapper);
    }

    private void processSlotChangeResponse(int slot, IItemHandler handler, IBackpackWrapper backpackWrapper) {
        if (!this.isClientSide) {
            backpackWrapper.getUpgradeHandler().getWrappersThatImplementFromMainBackpack(ISlotChangeResponseUpgrade.class).forEach(u -> u.onSlotChange(handler, slot));
        }
    }

    @Nonnull
    public ItemStack func_75211_c() {
        return this.inventoryHandler.getStackInSlot(this.slotIndex);
    }

    public boolean func_75214_a(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return this.inventoryHandler.isItemValid(this.slotIndex, stack);
    }

    public void func_75215_d(ItemStack stack) {
        this.inventoryHandler.setStackInSlot(this.slotIndex, stack);
        this.func_75218_e();
    }

    public int func_75219_a() {
        return this.inventoryHandler.getSlotLimit(this.slotIndex);
    }

    public void func_75220_a(@Nonnull ItemStack oldStackIn, @Nonnull ItemStack newStackIn) {
    }

    public int func_178170_b(ItemStack stack) {
        return this.inventoryHandler.getStackLimit(this.slotIndex, stack);
    }

    public boolean func_82869_a(PlayerEntity playerIn) {
        return !this.inventoryHandler.extractItem(this.slotIndex, 1, true).func_190926_b();
    }

    @Nonnull
    public ItemStack func_75209_a(int amount) {
        return this.inventoryHandler.extractItem(this.slotIndex, amount, false);
    }
}

