/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackFluidHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IEnergyStorageUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IFluidHandlerWrapperUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackStorage;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackFluidHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackInventoryHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackRenderInfo;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackSettingsHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackUpgradeHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.InventoryIOHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.InventoryModificationHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.NoopBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.SortBy;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.nosort.NoSortSettingsCategory;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.stack.StackUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.tank.TankUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.util.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventorySorter;
import net.p3pp3rf1y.sophisticatedbackpacks.util.ItemStackKey;
import net.p3pp3rf1y.sophisticatedbackpacks.util.LootHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.RandHelper;

public class BackpackWrapper
implements IBackpackWrapper {
    public static final int DEFAULT_CLOTH_COLOR = 13394234;
    public static final int DEFAULT_BORDER_COLOR = 6434330;
    private static final String CLOTH_COLOR_TAG = "clothColor";
    private static final String BORDER_COLOR_TAG = "borderColor";
    private static final String OPEN_TAB_ID_TAG = "openTabId";
    private static final String SORT_BY_TAG = "sortBy";
    private static final String CONTENTS_UUID_TAG = "contentsUuid";
    private static final String INVENTORY_SLOTS_TAG = "inventorySlots";
    private static final String UPGRADE_SLOTS_TAG = "upgradeSlots";
    private static final String LOOT_TABLE_NAME_TAG = "lootTableName";
    private static final String LOOT_PERCENTAGE_TAG = "lootPercentage";
    private static final String COLUMNS_TAKEN_TAG = "columnsTaken";
    private final ItemStack backpack;
    private Runnable backpackSaveHandler = () -> {};
    private Runnable inventorySlotChangeHandler = () -> {};
    @Nullable
    private BackpackInventoryHandler handler = null;
    @Nullable
    private BackpackUpgradeHandler upgradeHandler = null;
    @Nullable
    private InventoryIOHandler inventoryIOHandler = null;
    @Nullable
    private InventoryModificationHandler inventoryModificationHandler = null;
    @Nullable
    private BackpackSettingsHandler settingsHandler = null;
    private boolean fluidHandlerInitialized = false;
    @Nullable
    private IBackpackFluidHandler fluidHandler = null;
    private boolean energyStorageInitialized = false;
    @Nullable
    private IEnergyStorage energyStorage = null;
    private final BackpackRenderInfo renderInfo;

    public BackpackWrapper(ItemStack backpack) {
        this.backpack = backpack;
        this.renderInfo = new BackpackRenderInfo(backpack, () -> this.backpackSaveHandler);
    }

    @Override
    public void setBackpackSaveHandler(Runnable saveHandler) {
        this.backpackSaveHandler = saveHandler;
        this.refreshInventoryForUpgradeProcessing();
    }

    @Override
    public void setInventorySlotChangeHandler(Runnable slotChangeHandler) {
        this.inventorySlotChangeHandler = slotChangeHandler;
    }

    @Override
    public IItemHandlerSimpleInserter getInventoryForUpgradeProcessing() {
        if (this.inventoryModificationHandler == null) {
            this.inventoryModificationHandler = new InventoryModificationHandler(this);
        }
        return this.inventoryModificationHandler.getModifiedInventoryHandler();
    }

    @Override
    public BackpackInventoryHandler getInventoryHandler() {
        if (this.handler == null) {
            this.handler = new BackpackInventoryHandler(this.getNumberOfInventorySlots() - this.getNumberOfSlotRows() * this.getColumnsTaken(), this, this.getBackpackContentsNbt(), () -> {
                this.markBackpackContentsDirty();
                this.inventorySlotChangeHandler.run();
            }, StackUpgradeItem.getInventorySlotLimit(this));
            this.handler.addListener(this.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class)::itemChanged);
        }
        return this.handler;
    }

    private int getNumberOfInventorySlots() {
        Optional<Integer> inventorySlots = NBTHelper.getInt(this.backpack, INVENTORY_SLOTS_TAG);
        if (inventorySlots.isPresent()) {
            return inventorySlots.get();
        }
        int itemInventorySlots = ((BackpackItem)this.backpack.func_77973_b()).getNumberOfSlots();
        this.setNumberOfInventorySlots(itemInventorySlots);
        return itemInventorySlots;
    }

    @Override
    public int getNumberOfSlotRows() {
        int itemInventorySlots = this.getNumberOfInventorySlots();
        return (int)Math.ceil(itemInventorySlots <= 81 ? (double)itemInventorySlots / 9.0 : (double)itemInventorySlots / 12.0);
    }

    private void setNumberOfInventorySlots(int itemInventorySlots) {
        NBTHelper.setInteger(this.backpack, INVENTORY_SLOTS_TAG, itemInventorySlots);
    }

    private CompoundNBT getBackpackContentsNbt() {
        return BackpackStorage.get().getOrCreateBackpackContents(this.getOrCreateContentsUuid());
    }

    private void markBackpackContentsDirty() {
        BackpackStorage.get().func_76185_a();
    }

    @Override
    public IItemHandlerSimpleInserter getInventoryForInputOutput() {
        if (this.inventoryIOHandler == null) {
            this.inventoryIOHandler = new InventoryIOHandler(this);
        }
        return this.inventoryIOHandler.getFilteredItemHandler();
    }

    @Override
    public Optional<IBackpackFluidHandler> getFluidHandler() {
        if (!this.fluidHandlerInitialized) {
            IBackpackFluidHandler wrappedHandler = this.getUpgradeHandler().getTypeWrappers(TankUpgradeItem.TYPE).isEmpty() ? null : new BackpackFluidHandler(this);
            List<IFluidHandlerWrapperUpgrade> fluidHandlerWrapperUpgrades = this.getUpgradeHandler().getWrappersThatImplement(IFluidHandlerWrapperUpgrade.class);
            for (IFluidHandlerWrapperUpgrade fluidHandlerWrapperUpgrade : fluidHandlerWrapperUpgrades) {
                wrappedHandler = fluidHandlerWrapperUpgrade.wrapHandler(wrappedHandler, this.backpack);
            }
            this.fluidHandler = wrappedHandler;
        }
        return Optional.ofNullable(this.fluidHandler);
    }

    @Override
    public Optional<IEnergyStorage> getEnergyStorage() {
        if (!this.energyStorageInitialized) {
            IEnergyStorage wrappedStorage = this.getUpgradeHandler().getWrappersThatImplement(IEnergyStorage.class).stream().findFirst().orElse(null);
            for (IEnergyStorageUpgradeWrapper energyStorageWrapperUpgrade : this.getUpgradeHandler().getWrappersThatImplement(IEnergyStorageUpgradeWrapper.class)) {
                wrappedStorage = energyStorageWrapperUpgrade.wrapStorage(wrappedStorage);
            }
            this.energyStorage = wrappedStorage;
        }
        return Optional.ofNullable(this.energyStorage);
    }

    @Override
    public void copyDataTo(IBackpackWrapper otherBackpackWrapper) {
        this.getContentsUuid().ifPresent(originalUuid -> {
            this.getInventoryHandler().copyStacksTo(otherBackpackWrapper.getInventoryHandler());
            this.getUpgradeHandler().copyTo(otherBackpackWrapper.getUpgradeHandler());
            this.getSettingsHandler().copyTo(otherBackpackWrapper.getSettingsHandler());
        });
    }

    @Override
    public BackpackSettingsHandler getSettingsHandler() {
        if (this.settingsHandler == null) {
            this.settingsHandler = this.getContentsUuid().isPresent() ? new BackpackSettingsHandler(this, this.getBackpackContentsNbt(), this::markBackpackContentsDirty) : NoopBackpackWrapper.INSTANCE.getSettingsHandler();
        }
        return this.settingsHandler;
    }

    @Override
    public BackpackUpgradeHandler getUpgradeHandler() {
        if (this.upgradeHandler == null) {
            this.upgradeHandler = this.getContentsUuid().isPresent() ? new BackpackUpgradeHandler(this.getNumberOfUpgradeSlots(), this, this.getBackpackContentsNbt(), this::markBackpackContentsDirty, () -> {
                if (this.handler != null) {
                    this.handler.clearListeners();
                    this.handler.setSlotLimit(StackUpgradeItem.getInventorySlotLimit(this));
                }
                this.getInventoryHandler().clearListeners();
                this.handler.addListener(this.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class)::itemChanged);
                this.inventoryIOHandler = null;
                this.inventoryModificationHandler = null;
                this.fluidHandlerInitialized = false;
                this.fluidHandler = null;
                this.energyStorageInitialized = false;
                this.energyStorage = null;
            }) : NoopBackpackWrapper.INSTANCE.getUpgradeHandler();
        }
        return this.upgradeHandler;
    }

    private int getNumberOfUpgradeSlots() {
        Optional<Integer> upgradeSlots = NBTHelper.getInt(this.backpack, UPGRADE_SLOTS_TAG);
        if (upgradeSlots.isPresent()) {
            return upgradeSlots.get();
        }
        int itemUpgradeSlots = ((BackpackItem)this.backpack.func_77973_b()).getNumberOfUpgradeSlots();
        this.setNumberOfUpgradeSlots(itemUpgradeSlots);
        return itemUpgradeSlots;
    }

    @Override
    public Optional<UUID> getContentsUuid() {
        return NBTHelper.getUniqueId(this.backpack, CONTENTS_UUID_TAG);
    }

    private UUID getOrCreateContentsUuid() {
        Optional<UUID> contentsUuid = this.getContentsUuid();
        if (contentsUuid.isPresent()) {
            return contentsUuid.get();
        }
        this.clearDummyHandlers();
        UUID newUuid = UUID.randomUUID();
        this.setContentsUuid(newUuid);
        this.migrateBackpackContents(newUuid);
        return newUuid;
    }

    private void clearDummyHandlers() {
        if (this.upgradeHandler == NoopBackpackWrapper.INSTANCE.getUpgradeHandler()) {
            this.upgradeHandler = null;
        }
        if (this.settingsHandler == NoopBackpackWrapper.INSTANCE.getSettingsHandler()) {
            this.settingsHandler = null;
        }
    }

    private void migrateBackpackContents(UUID newUuid) {
        this.migrateNbtTag(newUuid, "inventory");
        this.migrateNbtTag(newUuid, "upgradeInventory");
    }

    private void migrateNbtTag(UUID newUuid, String key) {
        NBTHelper.getCompound(this.backpack, key).ifPresent(nbt -> {
            BackpackStorage.get().getOrCreateBackpackContents(newUuid).func_218657_a(key, (INBT)nbt);
            this.markBackpackContentsDirty();
            NBTHelper.removeTag(this.backpack, key);
        });
    }

    @Override
    public int getClothColor() {
        return NBTHelper.getInt(this.backpack, CLOTH_COLOR_TAG).orElse(13394234);
    }

    @Override
    public int getBorderColor() {
        return NBTHelper.getInt(this.backpack, BORDER_COLOR_TAG).orElse(6434330);
    }

    @Override
    public Optional<Integer> getOpenTabId() {
        return NBTHelper.getInt(this.backpack, OPEN_TAB_ID_TAG);
    }

    @Override
    public void setOpenTabId(int openTabId) {
        NBTHelper.setInteger(this.backpack, OPEN_TAB_ID_TAG, openTabId);
        this.backpackSaveHandler.run();
    }

    @Override
    public void removeOpenTabId() {
        this.backpack.func_196082_o().func_82580_o(OPEN_TAB_ID_TAG);
        this.backpackSaveHandler.run();
    }

    @Override
    public void setColors(int clothColor, int borderColor) {
        this.backpack.func_77983_a(CLOTH_COLOR_TAG, (INBT)IntNBT.func_229692_a_((int)clothColor));
        this.backpack.func_77983_a(BORDER_COLOR_TAG, (INBT)IntNBT.func_229692_a_((int)borderColor));
        this.backpackSaveHandler.run();
    }

    @Override
    public void setSortBy(SortBy sortBy) {
        this.backpack.func_77983_a(SORT_BY_TAG, (INBT)StringNBT.func_229705_a_((String)sortBy.func_176610_l()));
        this.backpackSaveHandler.run();
    }

    @Override
    public SortBy getSortBy() {
        return NBTHelper.getEnumConstant(this.backpack, SORT_BY_TAG, SortBy::fromName).orElse(SortBy.NAME);
    }

    @Override
    public void sort() {
        HashSet<Integer> slotIndexesExcludedFromSort = new HashSet<Integer>();
        slotIndexesExcludedFromSort.addAll(this.getSettingsHandler().getTypeCategory(NoSortSettingsCategory.class).getNoSortSlots());
        slotIndexesExcludedFromSort.addAll(this.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class).getSlotIndexes());
        InventorySorter.sortHandler(this.getInventoryHandler(), this.getComparator(), slotIndexesExcludedFromSort);
    }

    private Comparator<Map.Entry<ItemStackKey, Integer>> getComparator() {
        switch (this.getSortBy()) {
            case COUNT: {
                return InventorySorter.BY_COUNT;
            }
            case TAGS: {
                return InventorySorter.BY_TAGS;
            }
        }
        return InventorySorter.BY_NAME;
    }

    @Override
    public ItemStack getBackpack() {
        return this.backpack;
    }

    @Override
    public ItemStack cloneBackpack() {
        ItemStack clonedBackpack = this.cloneBackpack(this);
        clonedBackpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(this::cloneSubbackpacks);
        return clonedBackpack;
    }

    private void cloneSubbackpacks(IBackpackWrapper wrapperCloned) {
        BackpackInventoryHandler inventoryHandler = wrapperCloned.getInventoryHandler();
        InventoryHelper.iterate((IItemHandler)inventoryHandler, (slot, stack) -> {
            if (!(stack.func_77973_b() instanceof BackpackItem)) {
                return;
            }
            inventoryHandler.setStackInSlot((int)slot, stack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(this::cloneBackpack).orElse(ItemStack.field_190927_a));
        });
    }

    private ItemStack cloneBackpack(IBackpackWrapper originalWrapper) {
        ItemStack backpackCopy = originalWrapper.getBackpack().func_77946_l();
        backpackCopy.func_196083_e(CONTENTS_UUID_TAG);
        return backpackCopy.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(wrapperCopy -> {
            originalWrapper.copyDataTo((IBackpackWrapper)wrapperCopy);
            return wrapperCopy.getBackpack();
        }).orElse(ItemStack.field_190927_a);
    }

    @Override
    public void refreshInventoryForInputOutput() {
        this.inventoryIOHandler = null;
    }

    @Override
    public void setPersistent(boolean persistent) {
        this.getInventoryHandler().setPersistent(persistent);
        this.getUpgradeHandler().setPersistent(persistent);
    }

    @Override
    public void setSlotNumbers(int numberOfInventorySlots, int numberOfUpgradeSlots) {
        this.setNumberOfInventorySlots(numberOfInventorySlots);
        this.setNumberOfUpgradeSlots(numberOfUpgradeSlots);
    }

    @Override
    public void setLoot(ResourceLocation lootTableName, float lootPercentage) {
        this.backpack.func_77983_a(LOOT_TABLE_NAME_TAG, (INBT)StringNBT.func_229705_a_((String)lootTableName.toString()));
        this.backpack.func_77983_a(LOOT_PERCENTAGE_TAG, (INBT)FloatNBT.func_229689_a_((float)lootPercentage));
        this.backpackSaveHandler.run();
    }

    @Override
    public void fillWithLoot(PlayerEntity playerEntity) {
        if (playerEntity.field_70170_p.field_72995_K) {
            return;
        }
        NBTHelper.getString(this.backpack, LOOT_TABLE_NAME_TAG).ifPresent(ltName -> this.fillWithLootFromTable(playerEntity, (String)ltName));
    }

    @Override
    public void setContentsUuid(UUID backpackUuid) {
        NBTHelper.setUniqueId(this.backpack, CONTENTS_UUID_TAG, backpackUuid);
    }

    @Override
    public BackpackRenderInfo getRenderInfo() {
        return this.renderInfo;
    }

    @Override
    public void setColumnsTaken(int columnsTaken) {
        NBTHelper.setInteger(this.backpack, COLUMNS_TAKEN_TAG, columnsTaken);
    }

    @Override
    public int getColumnsTaken() {
        return NBTHelper.getInt(this.backpack, COLUMNS_TAKEN_TAG).orElse(0);
    }

    private void fillWithLootFromTable(PlayerEntity playerEntity, String lootName) {
        MinecraftServer server = playerEntity.field_70170_p.func_73046_m();
        if (server == null || !(playerEntity.field_70170_p instanceof ServerWorld)) {
            return;
        }
        ResourceLocation lootTableName = new ResourceLocation(lootName);
        float lootPercentage = NBTHelper.getFloat(this.backpack, LOOT_PERCENTAGE_TAG).orElse(Float.valueOf(0.0f)).floatValue();
        this.backpack.func_196083_e(LOOT_TABLE_NAME_TAG);
        this.backpack.func_196083_e(LOOT_PERCENTAGE_TAG);
        ServerWorld world = (ServerWorld)playerEntity.field_70170_p;
        List<ItemStack> loot = LootHelper.getLoot(lootTableName, server, world, (Entity)playerEntity);
        loot = RandHelper.getNRandomElements(loot, (int)((float)loot.size() * lootPercentage));
        LootHelper.fillWithLoot(world.field_73012_v, loot, this.getInventoryHandler());
    }

    private void setNumberOfUpgradeSlots(int numberOfUpgradeSlots) {
        NBTHelper.setInteger(this.backpack, UPGRADE_SLOTS_TAG, numberOfUpgradeSlots);
    }

    @Override
    public void refreshInventoryForUpgradeProcessing() {
        this.inventoryModificationHandler = null;
        this.fluidHandler = null;
        this.fluidHandlerInitialized = false;
        this.energyStorage = null;
        this.energyStorageInitialized = false;
        this.refreshInventoryForInputOutput();
    }

    @Override
    public void onContentsNbtUpdated() {
        this.handler = null;
        this.upgradeHandler = null;
        this.refreshInventoryForUpgradeProcessing();
    }
}

