/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IRenderedBatteryUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IRenderedTankUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IUpgradeAccessModifier;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IUpgradeWrapperAccessor;
import net.p3pp3rf1y.sophisticatedbackpacks.api.UpgradeType;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackRenderInfo;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.TankPosition;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryHelper;

public class BackpackUpgradeHandler
extends ItemStackHandler {
    public static final String UPGRADE_INVENTORY_TAG = "upgradeInventory";
    private final IBackpackWrapper backpackWrapper;
    private final Runnable backpackContentsSaveHandler;
    private final Runnable onInvalidateUpgradeCaches;
    private final CompoundNBT contentsNbt;
    @Nullable
    private Runnable refreshCallBack = null;
    private final Map<Integer, IUpgradeWrapper> slotWrappers = new HashMap<Integer, IUpgradeWrapper>();
    private final Map<UpgradeType<? extends IUpgradeWrapper>, List<? extends IUpgradeWrapper>> typeWrappers = new HashMap<UpgradeType<? extends IUpgradeWrapper>, List<? extends IUpgradeWrapper>>();
    private boolean justSavingNbtChange = false;
    private boolean wrappersInitialized = false;
    @Nullable
    private IUpgradeWrapperAccessor wrapperAccessor = null;
    private boolean persistent = true;

    public BackpackUpgradeHandler(int numberOfUpgradeSlots, IBackpackWrapper backpackWrapper, CompoundNBT contentsNbt, Runnable backpackContentsSaveHandler, Runnable onInvalidateUpgradeCaches) {
        super(numberOfUpgradeSlots);
        this.contentsNbt = contentsNbt;
        this.backpackWrapper = backpackWrapper;
        this.backpackContentsSaveHandler = backpackContentsSaveHandler;
        this.onInvalidateUpgradeCaches = onInvalidateUpgradeCaches;
        this.deserializeNBT(contentsNbt.func_74775_l(UPGRADE_INVENTORY_TAG));
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return stack.func_190926_b() || stack.func_77973_b() instanceof IBackpackUpgradeItem;
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        if (this.persistent) {
            this.saveInventory();
            this.backpackContentsSaveHandler.run();
        }
        if (!this.justSavingNbtChange) {
            this.refreshUpgradeWrappers();
        }
    }

    public void setSize(int size) {
        super.setSize(this.stacks.size());
    }

    public void saveInventory() {
        this.contentsNbt.func_218657_a(UPGRADE_INVENTORY_TAG, (INBT)this.serializeNBT());
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public void setRefreshCallBack(Runnable refreshCallBack) {
        this.refreshCallBack = refreshCallBack;
    }

    public void removeRefreshCallback() {
        this.refreshCallBack = null;
    }

    private void initializeWrappers() {
        if (this.wrappersInitialized) {
            return;
        }
        this.wrappersInitialized = true;
        this.slotWrappers.clear();
        this.typeWrappers.clear();
        InventoryHelper.iterate((IItemHandler)this, (slot, upgrade) -> {
            if (upgrade.func_190926_b() || !(upgrade.func_77973_b() instanceof IBackpackUpgradeItem)) {
                return;
            }
            UpgradeType type = ((IBackpackUpgradeItem)upgrade.func_77973_b()).getType();
            Object wrapper = type.create(this.backpackWrapper, (ItemStack)upgrade, upgradeStack -> {
                this.justSavingNbtChange = true;
                this.setStackInSlot((int)slot, (ItemStack)upgradeStack);
                this.justSavingNbtChange = false;
            });
            this.slotWrappers.put((Integer)slot, (IUpgradeWrapper)wrapper);
            if (wrapper.isEnabled()) {
                this.addTypeWrapper(type, wrapper);
            }
        });
        this.initRenderInfoCallbacks(false);
    }

    private <T extends IUpgradeWrapper> void addTypeWrapper(UpgradeType<?> type, T wrapper) {
        this.typeWrappers.computeIfAbsent(type, t -> new ArrayList()).add(wrapper);
    }

    public <T extends IUpgradeWrapper> List<T> getTypeWrappers(UpgradeType<T> type) {
        this.initializeWrappers();
        return this.typeWrappers.getOrDefault(type, Collections.emptyList());
    }

    public <T extends IUpgradeWrapper> boolean hasUpgrade(UpgradeType<T> type) {
        return !this.getTypeWrappers(type).isEmpty();
    }

    public <T> List<T> getWrappersThatImplement(Class<T> upgradeClass) {
        this.initializeWrappers();
        return this.getWrapperAccessor().getWrappersThatImplement(upgradeClass);
    }

    private IUpgradeWrapperAccessor getWrapperAccessor() {
        if (this.wrapperAccessor == null) {
            IUpgradeWrapperAccessor accessor = new Accessor(this);
            for (IUpgradeAccessModifier upgrade : this.getListOfWrappersThatImplement(IUpgradeAccessModifier.class)) {
                accessor = upgrade.wrapAccessor(accessor);
            }
            this.wrapperAccessor = accessor;
        }
        return this.wrapperAccessor;
    }

    public <T> List<T> getWrappersThatImplementFromMainBackpack(Class<T> upgradeClass) {
        this.initializeWrappers();
        return this.getWrapperAccessor().getWrappersThatImplementFromMainBackpack(upgradeClass);
    }

    public <T> List<T> getListOfWrappersThatImplement(Class<T> uc) {
        ArrayList<IUpgradeWrapper> ret = new ArrayList<IUpgradeWrapper>();
        for (IUpgradeWrapper wrapper : this.slotWrappers.values()) {
            if (!wrapper.isEnabled() || !uc.isInstance(wrapper)) continue;
            ret.add(wrapper);
        }
        return ret;
    }

    public Map<Integer, IUpgradeWrapper> getSlotWrappers() {
        this.initializeWrappers();
        return this.slotWrappers;
    }

    public void copyTo(BackpackUpgradeHandler otherHandler) {
        InventoryHelper.copyTo((IItemHandlerModifiable)this, (IItemHandlerModifiable)otherHandler);
    }

    public void refreshUpgradeWrappers() {
        this.wrappersInitialized = false;
        if (this.wrapperAccessor != null) {
            this.wrapperAccessor.onBeforeDeconstruct();
            this.wrapperAccessor = null;
        }
        if (this.refreshCallBack != null) {
            this.refreshCallBack.run();
        }
        this.onInvalidateUpgradeCaches.run();
        this.initRenderInfoCallbacks(true);
    }

    private void initRenderInfoCallbacks(boolean forceUpdateRenderInfo) {
        BackpackRenderInfo renderInfo = this.backpackWrapper.getRenderInfo();
        if (forceUpdateRenderInfo) {
            renderInfo.resetUpgradeInfo();
        }
        this.initTankRenderInfoCallbacks(forceUpdateRenderInfo, renderInfo);
        this.initBatteryRenderInfoCallbacks(forceUpdateRenderInfo, renderInfo);
    }

    private void initBatteryRenderInfoCallbacks(boolean forceUpdateRenderInfo, BackpackRenderInfo renderInfo) {
        this.getSlotWrappers().forEach((slot, wrapper) -> {
            if (wrapper instanceof IRenderedBatteryUpgrade) {
                IRenderedBatteryUpgrade batteryWrapper = (IRenderedBatteryUpgrade)((Object)wrapper);
                batteryWrapper.setBatteryRenderInfoUpdateCallback(renderInfo::setBatteryRenderInfo);
                if (forceUpdateRenderInfo) {
                    batteryWrapper.forceUpdateBatteryRenderInfo();
                }
            }
        });
    }

    private void initTankRenderInfoCallbacks(boolean forceUpdateRenderInfo, BackpackRenderInfo renderInfo) {
        AtomicBoolean singleTankRight = new AtomicBoolean(false);
        ArrayList tankRenderWrappers = new ArrayList();
        int minRightSlot = this.getSlots() / 2;
        this.getSlotWrappers().forEach((slot, wrapper) -> {
            if (wrapper instanceof IRenderedTankUpgrade) {
                tankRenderWrappers.add((IRenderedTankUpgrade)((Object)wrapper));
                if (slot >= minRightSlot) {
                    singleTankRight.set(true);
                }
            }
        });
        TankPosition currentTankPos = tankRenderWrappers.size() == 1 && singleTankRight.get() ? TankPosition.RIGHT : TankPosition.LEFT;
        for (IRenderedTankUpgrade tankRenderWrapper : tankRenderWrappers) {
            TankPosition finalCurrentTankPos = currentTankPos;
            tankRenderWrapper.setTankRenderInfoUpdateCallback(tankRenderInfo -> renderInfo.setTankRenderInfo(finalCurrentTankPos, (IRenderedTankUpgrade.TankRenderInfo)tankRenderInfo));
            if (forceUpdateRenderInfo) {
                tankRenderWrapper.forceUpdateTankRenderInfo();
            }
            currentTankPos = TankPosition.RIGHT;
        }
    }

    private static class Accessor
    implements IUpgradeWrapperAccessor {
        private final Map<Class<?>, List<?>> interfaceWrappers = new HashMap();
        private final BackpackUpgradeHandler upgradeHandler;

        public Accessor(BackpackUpgradeHandler upgradeHandler) {
            this.upgradeHandler = upgradeHandler;
        }

        @Override
        public <T> List<T> getWrappersThatImplement(Class<T> upgradeClass) {
            return this.interfaceWrappers.computeIfAbsent(upgradeClass, this.upgradeHandler::getListOfWrappersThatImplement);
        }

        @Override
        public <T> List<T> getWrappersThatImplementFromMainBackpack(Class<T> upgradeClass) {
            return this.interfaceWrappers.computeIfAbsent(upgradeClass, this.upgradeHandler::getListOfWrappersThatImplement);
        }
    }
}

