/*
 * Decompiled with CFR 0.152.
 */
package xaero.common;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import xaero.common.IXaeroMinimap;
import xaero.common.cache.BlockStateShortShapeCache;
import xaero.common.controls.ControlsHandler;
import xaero.common.controls.event.KeyEventHandler;
import xaero.common.core.IXaeroMinimapClientPlayNetHandler;
import xaero.common.core.XaeroMinimapCore;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.common.interfaces.Interface;
import xaero.common.interfaces.InterfaceInstance;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.radar.MinimapRadar;
import xaero.common.minimap.waypoints.WaypointSharingHandler;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.minimap.waypoints.render.WaypointsGuiRenderer;
import xaero.common.minimap.waypoints.render.WaypointsIngameRenderer;
import xaero.common.minimap.write.MinimapWriter;

public class XaeroMinimapSession {
    protected IXaeroMinimap modMain;
    protected WaypointsManager waypointsManager;
    protected WaypointSharingHandler waypointSharing;
    protected ControlsHandler controls;
    protected KeyEventHandler keyEventHandler;
    protected WaypointsGuiRenderer waypointsGuiRenderer;
    protected WaypointsIngameRenderer waypointsIngameRenderer;
    protected MinimapProcessor minimap;
    protected Map<Interface, InterfaceInstance> interfaceInstances;
    private MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers;
    private boolean usable;

    public XaeroMinimapSession(IXaeroMinimap modMain) {
        this.modMain = modMain;
    }

    public void init() throws IOException {
        this.waypointsManager = new WaypointsManager(this.modMain, this);
        this.modMain.getSettings().loadWaypointsFromAllSources(this.waypointsManager);
        this.waypointSharing = new WaypointSharingHandler(this.modMain, this);
        this.keyEventHandler = new KeyEventHandler();
        MinimapWriter minimapWriter = new MinimapWriter(this.modMain, this, new BlockStateShortShapeCache(this.modMain));
        MinimapRadar entityRadar = new MinimapRadar(this.modMain, this, this.modMain.getEntityRadarCategoryManager());
        this.minimap = new MinimapProcessor(this.modMain, this, minimapWriter, entityRadar);
        this.interfaceInstances = new HashMap<Interface, InterfaceInstance>();
        Iterator<Interface> interfaces = this.modMain.getInterfaces().getInterfaceIterator();
        while (interfaces.hasNext()) {
            Interface inter = interfaces.next();
            this.interfaceInstances.put(inter, inter.createInterfaceInstance(this));
        }
        this.multiTextureRenderTypeRenderers = new MultiTextureRenderTypeRendererProvider(2);
        this.usable = true;
        System.out.println("New minimap session initialized!");
    }

    public void cleanup() {
        try {
            this.minimap.cleanup();
            Iterator<Interface> interfaces = this.modMain.getInterfaces().getInterfaceIterator();
            while (interfaces.hasNext()) {
                Interface inter = interfaces.next();
                this.interfaceInstances.get(inter).cleanup();
            }
            System.out.println("Minimap session finalized.");
        }
        catch (Throwable t) {
            System.out.println("Minimap session failed to finalize properly.");
            t.printStackTrace();
        }
        this.usable = false;
    }

    public WaypointsManager getWaypointsManager() {
        return this.waypointsManager;
    }

    public WaypointSharingHandler getWaypointSharing() {
        return this.waypointSharing;
    }

    public ControlsHandler getControls() {
        return this.controls;
    }

    public KeyEventHandler getKeyEventHandler() {
        return this.keyEventHandler;
    }

    public MinimapProcessor getMinimapProcessor() {
        return this.minimap;
    }

    public Map<Interface, InterfaceInstance> getInterfaceInstances() {
        return this.interfaceInstances;
    }

    public static XaeroMinimapSession getCurrentSession() {
        XaeroMinimapSession session = XaeroMinimapSession.getForPlayer(Minecraft.func_71410_x().field_71439_g);
        if (session == null && XaeroMinimapCore.currentSession != null && XaeroMinimapCore.currentSession.usable) {
            session = XaeroMinimapCore.currentSession;
        }
        return session;
    }

    public static XaeroMinimapSession getForPlayer(ClientPlayerEntity player) {
        if (player == null || player.field_71174_a == null) {
            return null;
        }
        return ((IXaeroMinimapClientPlayNetHandler)player.field_71174_a).getXaero_minimapSession();
    }

    public MultiTextureRenderTypeRendererProvider getMultiTextureRenderTypeRenderers() {
        return this.multiTextureRenderTypeRenderers;
    }
}

