/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import vectorwing.farmersdelight.FDItemGroup;
import vectorwing.farmersdelight.crafting.CookingPotRecipe;
import vectorwing.farmersdelight.crafting.CuttingBoardRecipe;
import vectorwing.farmersdelight.crafting.ingredients.ToolIngredient;
import vectorwing.farmersdelight.registry.ModBiomeFeatures;
import vectorwing.farmersdelight.registry.ModBlocks;
import vectorwing.farmersdelight.registry.ModContainerTypes;
import vectorwing.farmersdelight.registry.ModEffects;
import vectorwing.farmersdelight.registry.ModEnchantments;
import vectorwing.farmersdelight.registry.ModItems;
import vectorwing.farmersdelight.registry.ModParticleTypes;
import vectorwing.farmersdelight.registry.ModRecipeSerializers;
import vectorwing.farmersdelight.registry.ModSounds;
import vectorwing.farmersdelight.registry.ModTileEntityTypes;
import vectorwing.farmersdelight.setup.ClientEventHandler;
import vectorwing.farmersdelight.setup.CommonEventHandler;
import vectorwing.farmersdelight.setup.Configuration;

@Mod(value="farmersdelight")
@Mod.EventBusSubscriber(modid="farmersdelight", bus=Mod.EventBusSubscriber.Bus.MOD)
public class FarmersDelight {
    public static final String MODID = "farmersdelight";
    public static final FDItemGroup ITEM_GROUP = new FDItemGroup("farmersdelight");
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public FarmersDelight() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(CommonEventHandler::init);
        modEventBus.addListener(ClientEventHandler::init);
        modEventBus.addGenericListener(IRecipeSerializer.class, this::registerRecipeSerializers);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Configuration.COMMON_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, Configuration.CLIENT_CONFIG);
        ModParticleTypes.PARTICLE_TYPES.register(modEventBus);
        ModEnchantments.ENCHANTMENTS.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModBlocks.BLOCKS.register(modEventBus);
        ModEffects.EFFECTS.register(modEventBus);
        ModBiomeFeatures.FEATURES.register(modEventBus);
        ModSounds.SOUNDS.register(modEventBus);
        ModTileEntityTypes.TILES.register(modEventBus);
        ModContainerTypes.CONTAINER_TYPES.register(modEventBus);
        ModRecipeSerializers.RECIPE_SERIALIZERS.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void registerRecipeSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        CraftingHelper.register((ResourceLocation)new ResourceLocation(MODID, "tool"), (IIngredientSerializer)ToolIngredient.SERIALIZER);
        event.getRegistry().register((IForgeRegistryEntry)CookingPotRecipe.SERIALIZER);
        event.getRegistry().register((IForgeRegistryEntry)CuttingBoardRecipe.SERIALIZER);
    }
}

