/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.gui.DelegatedStencilElement;
import com.simibubi.create.foundation.gui.IScreenRenderable;
import com.simibubi.create.foundation.gui.RenderElement;
import com.simibubi.create.foundation.utility.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AllIcons
implements IScreenRenderable {
    public static final ResourceLocation ICON_ATLAS = Create.asResource("textures/gui/icons.png");
    private static int x = 0;
    private static int y = -1;
    private int iconX;
    private int iconY;
    public static final AllIcons I_ADD = AllIcons.newRow();
    public static final AllIcons I_TRASH = AllIcons.next();
    public static final AllIcons I_3x3 = AllIcons.next();
    public static final AllIcons I_TARGET = AllIcons.next();
    public static final AllIcons I_PRIORITY_VERY_LOW = AllIcons.next();
    public static final AllIcons I_PRIORITY_LOW = AllIcons.next();
    public static final AllIcons I_PRIORITY_HIGH = AllIcons.next();
    public static final AllIcons I_PRIORITY_VERY_HIGH = AllIcons.next();
    public static final AllIcons I_BLACKLIST = AllIcons.next();
    public static final AllIcons I_WHITELIST = AllIcons.next();
    public static final AllIcons I_WHITELIST_OR = AllIcons.next();
    public static final AllIcons I_WHITELIST_AND = AllIcons.next();
    public static final AllIcons I_WHITELIST_NOT = AllIcons.next();
    public static final AllIcons I_RESPECT_NBT = AllIcons.next();
    public static final AllIcons I_IGNORE_NBT = AllIcons.next();
    public static final AllIcons I_CONFIRM = AllIcons.newRow();
    public static final AllIcons I_NONE = AllIcons.next();
    public static final AllIcons I_OPEN_FOLDER = AllIcons.next();
    public static final AllIcons I_REFRESH = AllIcons.next();
    public static final AllIcons I_ACTIVE = AllIcons.next();
    public static final AllIcons I_PASSIVE = AllIcons.next();
    public static final AllIcons I_ROTATE_PLACE = AllIcons.next();
    public static final AllIcons I_ROTATE_PLACE_RETURNED = AllIcons.next();
    public static final AllIcons I_ROTATE_NEVER_PLACE = AllIcons.next();
    public static final AllIcons I_MOVE_PLACE = AllIcons.next();
    public static final AllIcons I_MOVE_PLACE_RETURNED = AllIcons.next();
    public static final AllIcons I_MOVE_NEVER_PLACE = AllIcons.next();
    public static final AllIcons I_CART_ROTATE = AllIcons.next();
    public static final AllIcons I_CART_ROTATE_PAUSED = AllIcons.next();
    public static final AllIcons I_CART_ROTATE_LOCKED = AllIcons.next();
    public static final AllIcons I_DONT_REPLACE = AllIcons.newRow();
    public static final AllIcons I_REPLACE_SOLID = AllIcons.next();
    public static final AllIcons I_REPLACE_ANY = AllIcons.next();
    public static final AllIcons I_REPLACE_EMPTY = AllIcons.next();
    public static final AllIcons I_CENTERED = AllIcons.next();
    public static final AllIcons I_ATTACHED = AllIcons.next();
    public static final AllIcons I_INSERTED = AllIcons.next();
    public static final AllIcons I_FILL = AllIcons.next();
    public static final AllIcons I_PLACE = AllIcons.next();
    public static final AllIcons I_REPLACE = AllIcons.next();
    public static final AllIcons I_CLEAR = AllIcons.next();
    public static final AllIcons I_OVERLAY = AllIcons.next();
    public static final AllIcons I_FLATTEN = AllIcons.next();
    public static final AllIcons I_LMB = AllIcons.next();
    public static final AllIcons I_SCROLL = AllIcons.next();
    public static final AllIcons I_RMB = AllIcons.next();
    public static final AllIcons I_TOOL_DEPLOY = AllIcons.newRow();
    public static final AllIcons I_SKIP_MISSING = AllIcons.next();
    public static final AllIcons I_SKIP_TILES = AllIcons.next();
    public static final AllIcons I_DICE = AllIcons.next();
    public static final AllIcons I_TUNNEL_SPLIT = AllIcons.next();
    public static final AllIcons I_TUNNEL_FORCED_SPLIT = AllIcons.next();
    public static final AllIcons I_TUNNEL_ROUND_ROBIN = AllIcons.next();
    public static final AllIcons I_TUNNEL_FORCED_ROUND_ROBIN = AllIcons.next();
    public static final AllIcons I_TUNNEL_PREFER_NEAREST = AllIcons.next();
    public static final AllIcons I_TUNNEL_RANDOMIZE = AllIcons.next();
    public static final AllIcons I_TUNNEL_SYNCHRONIZE = AllIcons.next();
    public static final AllIcons I_TOOLBOX = AllIcons.next();
    public static final AllIcons I_TOOL_MOVE_XZ = AllIcons.newRow();
    public static final AllIcons I_TOOL_MOVE_Y = AllIcons.next();
    public static final AllIcons I_TOOL_ROTATE = AllIcons.next();
    public static final AllIcons I_TOOL_MIRROR = AllIcons.next();
    public static final AllIcons I_ARM_ROUND_ROBIN = AllIcons.next();
    public static final AllIcons I_ARM_FORCED_ROUND_ROBIN = AllIcons.next();
    public static final AllIcons I_ARM_PREFER_FIRST = AllIcons.next();
    public static final AllIcons I_ADD_INVERTED_ATTRIBUTE = AllIcons.next();
    public static final AllIcons I_FLIP = AllIcons.next();
    public static final AllIcons I_PLAY = AllIcons.newRow();
    public static final AllIcons I_PAUSE = AllIcons.next();
    public static final AllIcons I_STOP = AllIcons.next();
    public static final AllIcons I_PLACEMENT_SETTINGS = AllIcons.next();
    public static final AllIcons I_ROTATE_CCW = AllIcons.next();
    public static final AllIcons I_HOUR_HAND_FIRST = AllIcons.next();
    public static final AllIcons I_MINUTE_HAND_FIRST = AllIcons.next();
    public static final AllIcons I_HOUR_HAND_FIRST_24 = AllIcons.next();
    public static final AllIcons I_PATTERN_SOLID = AllIcons.newRow();
    public static final AllIcons I_PATTERN_CHECKERED = AllIcons.next();
    public static final AllIcons I_PATTERN_CHECKERED_INVERSED = AllIcons.next();
    public static final AllIcons I_PATTERN_CHANCE_25 = AllIcons.next();
    public static final AllIcons I_PATTERN_CHANCE_50 = AllIcons.newRow();
    public static final AllIcons I_PATTERN_CHANCE_75 = AllIcons.next();
    public static final AllIcons I_FOLLOW_DIAGONAL = AllIcons.next();
    public static final AllIcons I_FOLLOW_MATERIAL = AllIcons.next();
    public static final AllIcons I_SCHEMATIC = AllIcons.newRow();
    public static final AllIcons I_MTD_LEFT = AllIcons.newRow();
    public static final AllIcons I_MTD_CLOSE = AllIcons.next();
    public static final AllIcons I_MTD_RIGHT = AllIcons.next();
    public static final AllIcons I_MTD_SCAN = AllIcons.next();
    public static final AllIcons I_MTD_REPLAY = AllIcons.next();
    public static final AllIcons I_MTD_USER_MODE = AllIcons.next();
    public static final AllIcons I_MTD_SLOW_MODE = AllIcons.next();
    public static final AllIcons I_CONFIG_UNLOCKED = AllIcons.newRow();
    public static final AllIcons I_CONFIG_LOCKED = AllIcons.next();
    public static final AllIcons I_CONFIG_DISCARD = AllIcons.next();
    public static final AllIcons I_CONFIG_SAVE = AllIcons.next();
    public static final AllIcons I_CONFIG_RESET = AllIcons.next();
    public static final AllIcons I_CONFIG_BACK = AllIcons.next();
    public static final AllIcons I_CONFIG_PREV = AllIcons.next();
    public static final AllIcons I_CONFIG_NEXT = AllIcons.next();
    public static final AllIcons I_DISABLE = AllIcons.next();
    public static final AllIcons I_CONFIG_OPEN = AllIcons.next();
    public static final AllIcons I_FX_SURFACE_OFF = AllIcons.newRow();
    public static final AllIcons I_FX_SURFACE_ON = AllIcons.next();
    public static final AllIcons I_FX_FIELD_OFF = AllIcons.next();
    public static final AllIcons I_FX_FIELD_ON = AllIcons.next();
    public static final AllIcons I_FX_BLEND = AllIcons.next();
    public static final AllIcons I_FX_BLEND_OFF = AllIcons.next();

    public AllIcons(int x, int y) {
        this.iconX = x * 16;
        this.iconY = y * 16;
    }

    private static AllIcons next() {
        return new AllIcons(++x, y);
    }

    private static AllIcons newRow() {
        x = 0;
        return new AllIcons(0, ++y);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void bind() {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ICON_ATLAS);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(MatrixStack matrixStack, AbstractGui screen, int x, int y) {
        this.bind();
        screen.func_238474_b_(matrixStack, x, y, this.iconX, this.iconY, 16, 16);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(MatrixStack ms, IRenderTypeBuffer buffer, int color) {
        IVertexBuilder builder = buffer.getBuffer(RenderType.func_228660_m_((ResourceLocation)ICON_ATLAS));
        float sheetSize = 256.0f;
        int i = 0xF000F0;
        int j = i >> 16 & 0xFFFF;
        int k = i & 0xFFFF;
        MatrixStack.Entry peek = ms.func_227866_c_();
        Vector3d rgb = Color.vectorFromRGB(color);
        Vector3d vec4 = new Vector3d(1.0, 1.0, 0.0);
        Vector3d vec3 = new Vector3d(0.0, 1.0, 0.0);
        Vector3d vec2 = new Vector3d(0.0, 0.0, 0.0);
        Vector3d vec1 = new Vector3d(1.0, 0.0, 0.0);
        float u1 = (float)(this.iconX + 16) / sheetSize;
        float u2 = (float)this.iconX / sheetSize;
        float v1 = (float)this.iconY / sheetSize;
        float v2 = (float)(this.iconY + 16) / sheetSize;
        this.vertex(peek, builder, j, k, rgb, vec1, u1, v1);
        this.vertex(peek, builder, j, k, rgb, vec2, u2, v1);
        this.vertex(peek, builder, j, k, rgb, vec3, u2, v2);
        this.vertex(peek, builder, j, k, rgb, vec4, u1, v2);
    }

    @OnlyIn(value=Dist.CLIENT)
    public DelegatedStencilElement asStencil() {
        return (DelegatedStencilElement)((RenderElement)new DelegatedStencilElement().withStencilRenderer((ms, w, h, alpha) -> this.draw(ms, 0, 0))).withBounds(16, 16);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void vertex(MatrixStack.Entry peek, IVertexBuilder builder, int j, int k, Vector3d rgb, Vector3d vec, float u, float v) {
        builder.func_227888_a_(peek.func_227870_a_(), (float)vec.field_72450_a, (float)vec.field_72448_b, (float)vec.field_72449_c).func_227885_a_((float)rgb.field_72450_a, (float)rgb.field_72448_b, (float)rgb.field_72449_c, 1.0f).func_225583_a_(u, v).func_225587_b_(j, k).func_181675_d();
    }
}

