/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.config.ui;

import com.electronwill.nightconfig.core.AbstractConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.foundation.config.ui.BaseConfigScreen;
import com.simibubi.create.foundation.config.ui.CConfigureConfigPacket;
import com.simibubi.create.foundation.config.ui.ConfigAnnotations;
import com.simibubi.create.foundation.config.ui.ConfigHelper;
import com.simibubi.create.foundation.config.ui.ConfigScreen;
import com.simibubi.create.foundation.config.ui.ConfigScreenList;
import com.simibubi.create.foundation.config.ui.ConfigTextField;
import com.simibubi.create.foundation.config.ui.HintableTextFieldWidget;
import com.simibubi.create.foundation.config.ui.entries.BooleanEntry;
import com.simibubi.create.foundation.config.ui.entries.EnumEntry;
import com.simibubi.create.foundation.config.ui.entries.NumberEntry;
import com.simibubi.create.foundation.config.ui.entries.SubMenuEntry;
import com.simibubi.create.foundation.config.ui.entries.ValueEntry;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.ConfirmationScreen;
import com.simibubi.create.foundation.gui.DelegatedStencilElement;
import com.simibubi.create.foundation.gui.RenderElement;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.gui.Theme;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import com.simibubi.create.foundation.gui.widgets.AbstractSimiWidget;
import com.simibubi.create.foundation.gui.widgets.BoxWidget;
import com.simibubi.create.foundation.gui.widgets.ElementWidget;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class SubMenuConfigScreen
extends ConfigScreen {
    public final ModConfig.Type type;
    protected ForgeConfigSpec spec;
    protected UnmodifiableConfig configGroup;
    protected ConfigScreenList list;
    protected BoxWidget resetAll;
    protected BoxWidget saveChanges;
    protected BoxWidget discardChanges;
    protected BoxWidget goBack;
    protected BoxWidget serverLocked;
    protected HintableTextFieldWidget search;
    protected int listWidth;
    protected String field_230704_d_;
    protected Set<String> highlights = new HashSet<String>();

    public static SubMenuConfigScreen find(ConfigHelper.ConfigPath path) {
        ForgeConfigSpec spec = ConfigHelper.findConfigSpecFor(path.getType(), path.getModID());
        UnmodifiableConfig values = spec.getValues();
        BaseConfigScreen base = new BaseConfigScreen(null, path.getModID());
        SubMenuConfigScreen screen = new SubMenuConfigScreen(base, "root", path.getType(), spec, values);
        ArrayList remainingPath = Lists.newArrayList((Object[])path.getPath());
        block0: while (!remainingPath.isEmpty()) {
            String next = (String)remainingPath.remove(0);
            for (Map.Entry entry : values.valueMap().entrySet()) {
                String key = (String)entry.getKey();
                Object obj = entry.getValue();
                if (!key.equalsIgnoreCase(next)) continue;
                if (!(obj instanceof AbstractConfig)) {
                    screen.highlights.add(path.getPath()[path.getPath().length - 1]);
                    continue;
                }
                values = (UnmodifiableConfig)obj;
                screen = new SubMenuConfigScreen(screen, SubMenuConfigScreen.toHumanReadable(key), path.getType(), spec, values);
                continue block0;
            }
        }
        ConfigScreen.modID = path.getModID();
        return screen;
    }

    public SubMenuConfigScreen(Screen parent, String title, ModConfig.Type type, ForgeConfigSpec configSpec, UnmodifiableConfig configGroup) {
        super(parent);
        this.type = type;
        this.spec = configSpec;
        this.field_230704_d_ = title;
        this.configGroup = configGroup;
    }

    public SubMenuConfigScreen(Screen parent, ModConfig.Type type, ForgeConfigSpec configSpec) {
        super(parent);
        this.type = type;
        this.spec = configSpec;
        this.field_230704_d_ = "root";
        this.configGroup = configSpec.getValues();
    }

    protected void clearChanges() {
        ConfigHelper.changes.clear();
        this.list.func_231039_at__().stream().filter(e -> e instanceof ValueEntry).forEach(e -> ((ValueEntry)((Object)e)).onValueChange());
    }

    protected void saveChanges() {
        UnmodifiableConfig values = this.spec.getValues();
        ConfigHelper.changes.forEach((path, change) -> {
            ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)values.get(path);
            configValue.set(change.value);
            if (this.type == ModConfig.Type.SERVER) {
                AllPackets.channel.sendToServer(new CConfigureConfigPacket<Object>(ConfigScreen.modID, (String)path, change.value));
            }
            String command = change.annotations.get("Execute");
            if (Minecraft.func_71410_x().field_71439_g != null && command != null && command.startsWith("/")) {
                Minecraft.func_71410_x().field_71439_g.func_71165_d(command);
            }
        });
        this.clearChanges();
    }

    protected void resetConfig(UnmodifiableConfig values) {
        values.valueMap().forEach((key, obj) -> {
            if (obj instanceof AbstractConfig) {
                this.resetConfig((UnmodifiableConfig)obj);
            } else if (obj instanceof ForgeConfigSpec.ConfigValue) {
                ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)obj;
                ForgeConfigSpec.ValueSpec valueSpec = (ForgeConfigSpec.ValueSpec)this.spec.getRaw(configValue.getPath());
                ArrayList<String> comments = new ArrayList<String>(Arrays.asList(valueSpec.getComment().split("\n")));
                Pair<String, Map<String, String>> metadata = ConfigHelper.readMetadataFromComment(comments);
                ConfigHelper.setValue(String.join((CharSequence)".", configValue.getPath()), configValue, valueSpec.getDefault(), metadata.getSecond());
            }
        });
        this.list.func_231039_at__().stream().filter(e -> e instanceof ValueEntry).forEach(e -> ((ValueEntry)((Object)e)).onValueChange());
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        this.list.tick();
    }

    @Override
    protected void func_231160_c_() {
        this.widgets.clear();
        super.func_231160_c_();
        this.listWidth = Math.min(this.field_230708_k_ - 80, 300);
        int yCenter = this.field_230709_l_ / 2;
        int listL = this.field_230708_k_ / 2 - this.listWidth / 2;
        int listR = this.field_230708_k_ / 2 + this.listWidth / 2;
        this.resetAll = (BoxWidget)((Object)((AbstractSimiWidget)((Object)new BoxWidget(listR + 10, yCenter - 25, 20, 20).withPadding(2.0f, 2.0f))).withCallback((x, y) -> new ConfirmationScreen().centered().withText(ITextProperties.func_240652_a_((String)("Resetting all settings of the " + this.type.toString() + " config. Are you sure?"))).withAction(success -> {
            if (success.booleanValue()) {
                this.resetConfig(this.spec.getValues());
            }
        }).open(this)));
        this.resetAll.showingElement((RenderElement)AllIcons.I_CONFIG_RESET.asStencil().withElementRenderer(BoxWidget.gradientFactory.apply(this.resetAll)));
        this.resetAll.getToolTip().add((ITextComponent)new StringTextComponent("Reset All"));
        this.resetAll.getToolTip().addAll(TooltipHelper.cutStringTextComponent("Click here to reset all settings to their default value.", TextFormatting.GRAY, TextFormatting.GRAY));
        this.saveChanges = (BoxWidget)((Object)((AbstractSimiWidget)((Object)new BoxWidget(listL - 30, yCenter - 25, 20, 20).withPadding(2.0f, 2.0f))).withCallback((x, y) -> {
            if (ConfigHelper.changes.isEmpty()) {
                return;
            }
            ConfirmationScreen confirm = new ConfirmationScreen().centered().withText(ITextProperties.func_240652_a_((String)("Saving " + ConfigHelper.changes.size() + " changed value" + (ConfigHelper.changes.size() != 1 ? "s" : "") + ""))).withAction(success -> {
                if (success.booleanValue()) {
                    this.saveChanges();
                }
            });
            this.addAnnotationsToConfirm(confirm).open(this);
        }));
        this.saveChanges.showingElement((RenderElement)AllIcons.I_CONFIG_SAVE.asStencil().withElementRenderer(BoxWidget.gradientFactory.apply(this.saveChanges)));
        this.saveChanges.getToolTip().add((ITextComponent)new StringTextComponent("Save Changes"));
        this.saveChanges.getToolTip().addAll(TooltipHelper.cutStringTextComponent("Click here to save your current changes.", TextFormatting.GRAY, TextFormatting.GRAY));
        this.discardChanges = (BoxWidget)((Object)((AbstractSimiWidget)((Object)new BoxWidget(listL - 30, yCenter + 5, 20, 20).withPadding(2.0f, 2.0f))).withCallback((x, y) -> {
            if (ConfigHelper.changes.isEmpty()) {
                return;
            }
            new ConfirmationScreen().centered().withText(ITextProperties.func_240652_a_((String)("Discarding " + ConfigHelper.changes.size() + " unsaved change" + (ConfigHelper.changes.size() != 1 ? "s" : "") + ""))).withAction(success -> {
                if (success.booleanValue()) {
                    this.clearChanges();
                }
            }).open(this);
        }));
        this.discardChanges.showingElement((RenderElement)AllIcons.I_CONFIG_DISCARD.asStencil().withElementRenderer(BoxWidget.gradientFactory.apply(this.discardChanges)));
        this.discardChanges.getToolTip().add((ITextComponent)new StringTextComponent("Discard Changes"));
        this.discardChanges.getToolTip().addAll(TooltipHelper.cutStringTextComponent("Click here to discard all the changes you made.", TextFormatting.GRAY, TextFormatting.GRAY));
        this.goBack = (BoxWidget)((Object)((AbstractSimiWidget)((Object)new BoxWidget(listL - 30, yCenter + 65, 20, 20).withPadding(2.0f, 2.0f))).withCallback(this::attemptBackstep));
        this.goBack.showingElement((RenderElement)AllIcons.I_CONFIG_BACK.asStencil().withElementRenderer(BoxWidget.gradientFactory.apply(this.goBack)));
        this.goBack.getToolTip().add((ITextComponent)new StringTextComponent("Go Back"));
        this.widgets.add(this.resetAll);
        this.widgets.add(this.saveChanges);
        this.widgets.add(this.discardChanges);
        this.widgets.add(this.goBack);
        this.list = new ConfigScreenList(this.field_230706_i_, this.listWidth, this.field_230709_l_ - 80, 35, this.field_230709_l_ - 45, 40);
        this.list.func_230959_g_(this.field_230708_k_ / 2 - this.list.getWidth() / 2);
        this.field_230705_e_.add(this.list);
        this.search = new ConfigTextField(this.field_230712_o_, this.field_230708_k_ / 2 - this.listWidth / 2, this.field_230709_l_ - 35, this.listWidth, 20);
        this.search.func_212954_a(this::updateFilter);
        this.search.setHint("Search..");
        this.search.func_146196_d();
        this.widgets.add(this.search);
        this.configGroup.valueMap().forEach((key, obj) -> {
            String humanKey = SubMenuConfigScreen.toHumanReadable(key);
            if (obj instanceof AbstractConfig) {
                SubMenuEntry entry = new SubMenuEntry(this, humanKey, this.spec, (UnmodifiableConfig)obj);
                entry.path = key;
                this.list.func_231039_at__().add(entry);
                if (this.configGroup.valueMap().size() == 1) {
                    ScreenOpener.open(new SubMenuConfigScreen(this.parent, humanKey, this.type, this.spec, (UnmodifiableConfig)obj));
                }
            } else if (obj instanceof ForgeConfigSpec.ConfigValue) {
                ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)obj;
                ForgeConfigSpec.ValueSpec valueSpec = (ForgeConfigSpec.ValueSpec)this.spec.getRaw(configValue.getPath());
                Object value = configValue.get();
                ConfigScreenList.LabeledEntry entry = null;
                if (value instanceof Boolean) {
                    entry = new BooleanEntry(humanKey, (ForgeConfigSpec.ConfigValue<Boolean>)configValue, valueSpec);
                } else if (value instanceof Enum) {
                    entry = new EnumEntry(humanKey, (ForgeConfigSpec.ConfigValue<Enum<?>>)configValue, valueSpec);
                } else if (value instanceof Number) {
                    entry = NumberEntry.create(value, humanKey, configValue, valueSpec);
                }
                if (entry == null) {
                    entry = new ConfigScreenList.LabeledEntry("Impl missing - " + configValue.get().getClass().getSimpleName() + "  " + humanKey + " : " + value);
                }
                if (this.highlights.contains(key)) {
                    entry.annotations.put("highlight", ":)");
                }
                this.list.func_231039_at__().add(entry);
            }
        });
        Collections.sort(this.list.func_231039_at__(), (e, e2) -> {
            int group = (e2 instanceof SubMenuEntry ? 1 : 0) - (e instanceof SubMenuEntry ? 1 : 0);
            if (group == 0 && e instanceof ConfigScreenList.LabeledEntry && e2 instanceof ConfigScreenList.LabeledEntry) {
                ConfigScreenList.LabeledEntry le = (ConfigScreenList.LabeledEntry)((Object)e);
                ConfigScreenList.LabeledEntry le2 = (ConfigScreenList.LabeledEntry)((Object)e2);
                return le.label.getComponent().getString().compareTo(le2.label.getComponent().getString());
            }
            return group;
        });
        this.list.search(this.highlights.stream().findFirst().orElse(""));
        if (this.type != ModConfig.Type.SERVER) {
            return;
        }
        if (this.field_230706_i_.func_71356_B()) {
            return;
        }
        boolean canEdit = this.field_230706_i_ != null && this.field_230706_i_.field_71439_g != null && this.field_230706_i_.field_71439_g.func_211513_k(2);
        Couple<Color> red = Theme.p(Theme.Key.BUTTON_FAIL);
        Couple<Color> green = Theme.p(Theme.Key.BUTTON_SUCCESS);
        DelegatedStencilElement stencil = new DelegatedStencilElement();
        this.serverLocked = (BoxWidget)((Object)((ElementWidget)((Object)new BoxWidget(listR + 10, yCenter + 5, 20, 20).withPadding(2.0f, 2.0f))).showingElement(stencil));
        if (!canEdit) {
            this.list.func_231039_at__().forEach(e -> e.setEditable(false));
            this.resetAll.field_230693_o_ = false;
            stencil.withStencilRenderer((ms, w, h, alpha) -> AllIcons.I_CONFIG_LOCKED.draw(ms, 0, 0));
            stencil.withElementRenderer((ms, w, h, alpha) -> UIRenderHelper.angledGradient(ms, 90.0f, 8, 0, 16, 16, red));
            this.serverLocked.withBorderColors(red);
            this.serverLocked.getToolTip().add((ITextComponent)new StringTextComponent("Locked").func_240699_a_(TextFormatting.BOLD));
            this.serverLocked.getToolTip().addAll(TooltipHelper.cutStringTextComponent("You do not have enough permissions to edit the server config. You can still look at the current values here though.", TextFormatting.GRAY, TextFormatting.GRAY));
        } else {
            stencil.withStencilRenderer((ms, w, h, alpha) -> AllIcons.I_CONFIG_UNLOCKED.draw(ms, 0, 0));
            stencil.withElementRenderer((ms, w, h, alpha) -> UIRenderHelper.angledGradient(ms, 90.0f, 8, 0, 16, 16, green));
            this.serverLocked.withBorderColors(green);
            this.serverLocked.getToolTip().add((ITextComponent)new StringTextComponent("Unlocked").func_240699_a_(TextFormatting.BOLD));
            this.serverLocked.getToolTip().addAll(TooltipHelper.cutStringTextComponent("You have enough permissions to edit the server config. Changes you make here will be synced with the server when you save them.", TextFormatting.GRAY, TextFormatting.GRAY));
        }
        this.widgets.add(this.serverLocked);
    }

    @Override
    protected void renderWindow(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        super.renderWindow(ms, mouseX, mouseY, partialTicks);
        int x = this.field_230708_k_ / 2;
        SubMenuConfigScreen.func_238471_a_((MatrixStack)ms, (FontRenderer)this.field_230706_i_.field_71466_p, (String)(ConfigScreen.modID + " > " + this.type.toString().toLowerCase(Locale.ROOT) + " > " + this.field_230704_d_), (int)x, (int)15, (int)Theme.i(Theme.Key.TEXT));
        this.list.func_230430_a_(ms, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void renderWindowForeground(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        super.renderWindowForeground(ms, mouseX, mouseY, partialTicks);
    }

    public void func_231152_a_(@Nonnull Minecraft client, int width, int height) {
        double scroll = this.list.func_230966_l_();
        this.func_231158_b_(client, width, height);
        this.list.func_230932_a_(scroll);
    }

    @Nullable
    public IGuiEventListener func_241217_q_() {
        if (ConfigScreenList.currentText != null) {
            return ConfigScreenList.currentText;
        }
        return super.func_241217_q_();
    }

    @Override
    public boolean func_231046_a_(int code, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (super.func_231046_a_(code, p_keyPressed_2_, p_keyPressed_3_)) {
            return true;
        }
        if (Screen.func_231172_r_() && code == 70) {
            this.search.func_146195_b(true);
        }
        if (code == 259) {
            this.attemptBackstep();
        }
        return false;
    }

    private void updateFilter(String search) {
        if (this.list.search(search)) {
            this.search.func_146193_g(Theme.i(Theme.Key.TEXT));
        } else {
            this.search.func_146193_g(Theme.i(Theme.Key.BUTTON_FAIL));
        }
    }

    private void attemptBackstep() {
        if (ConfigHelper.changes.isEmpty() || !(this.parent instanceof BaseConfigScreen)) {
            ScreenOpener.open(this.parent);
            return;
        }
        Consumer<ConfirmationScreen.Response> action = success -> {
            if (success == ConfirmationScreen.Response.Cancel) {
                return;
            }
            if (success == ConfirmationScreen.Response.Confirm) {
                this.saveChanges();
            }
            ConfigHelper.changes.clear();
            ScreenOpener.open(this.parent);
        };
        this.showLeavingPrompt(action);
    }

    public void func_231175_as__() {
        if (ConfigHelper.changes.isEmpty()) {
            super.func_231175_as__();
            ScreenOpener.open(this.parent);
            return;
        }
        Consumer<ConfirmationScreen.Response> action = success -> {
            if (success == ConfirmationScreen.Response.Cancel) {
                return;
            }
            if (success == ConfirmationScreen.Response.Confirm) {
                this.saveChanges();
            }
            ConfigHelper.changes.clear();
            super.func_231175_as__();
        };
        this.showLeavingPrompt(action);
    }

    public void showLeavingPrompt(Consumer<ConfirmationScreen.Response> action) {
        ConfirmationScreen screen = new ConfirmationScreen().centered().withThreeActions(action).addText(ITextProperties.func_240652_a_((String)("Leaving with " + ConfigHelper.changes.size() + " unsaved change" + (ConfigHelper.changes.size() != 1 ? "s" : "") + " for this config")));
        this.addAnnotationsToConfirm(screen).open(this);
    }

    private ConfirmationScreen addAnnotationsToConfirm(ConfirmationScreen screen) {
        AtomicBoolean relog = new AtomicBoolean(false);
        AtomicBoolean restart = new AtomicBoolean(false);
        ConfigHelper.changes.values().forEach(change -> {
            if (change.annotations.containsKey(ConfigAnnotations.RequiresRelog.TRUE.getName())) {
                relog.set(true);
            }
            if (change.annotations.containsKey(ConfigAnnotations.RequiresRestart.CLIENT.getName())) {
                restart.set(true);
            }
        });
        if (relog.get()) {
            screen.addText(ITextProperties.func_240652_a_((String)" "));
            screen.addText(ITextProperties.func_240652_a_((String)"At least one changed value will require you to relog to take full effect"));
        }
        if (restart.get()) {
            screen.addText(ITextProperties.func_240652_a_((String)" "));
            screen.addText(ITextProperties.func_240652_a_((String)"At least one changed value will require you to restart your game to take full effect"));
        }
        return screen;
    }
}

