/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter.attribute;

import com.simibubi.create.content.logistics.item.filter.ItemAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

public class BookAuthorAttribute
implements ItemAttribute {
    String author;

    public BookAuthorAttribute(String author) {
        this.author = author;
    }

    @Override
    public boolean appliesTo(ItemStack itemStack) {
        return this.extractAuthor(itemStack).equals(this.author);
    }

    @Override
    public List<ItemAttribute> listAttributesOf(ItemStack itemStack) {
        String name = this.extractAuthor(itemStack);
        ArrayList<ItemAttribute> atts = new ArrayList<ItemAttribute>();
        if (name.length() > 0) {
            atts.add(new BookAuthorAttribute(name));
        }
        return atts;
    }

    @Override
    public String getTranslationKey() {
        return "book_author";
    }

    @Override
    public Object[] getTranslationParameters() {
        return new Object[]{this.author};
    }

    @Override
    public void writeNBT(CompoundNBT nbt) {
        nbt.func_74778_a("author", this.author);
    }

    @Override
    public ItemAttribute readNBT(CompoundNBT nbt) {
        return new BookAuthorAttribute(nbt.func_74779_i("author"));
    }

    private String extractAuthor(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("author")) {
            return nbt.func_74779_i("author");
        }
        return "";
    }
}

