/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.toolbox;

import com.simibubi.create.content.curiosities.toolbox.ToolboxHandler;
import com.simibubi.create.content.curiosities.toolbox.ToolboxTileEntity;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class ToolboxDisposeAllPacket
extends SimplePacketBase {
    private BlockPos toolboxPos;

    public ToolboxDisposeAllPacket(BlockPos toolboxPos) {
        this.toolboxPos = toolboxPos;
    }

    public ToolboxDisposeAllPacket(PacketBuffer buffer) {
        this.toolboxPos = buffer.func_179259_c();
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_179255_a(this.toolboxPos);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ServerPlayerEntity player = ctx.getSender();
            World world = player.field_70170_p;
            TileEntity blockEntity = world.func_175625_s(this.toolboxPos);
            double maxRange = ToolboxHandler.getMaxRange((PlayerEntity)player);
            if (player.func_70092_e((double)this.toolboxPos.func_177958_n() + 0.5, (double)this.toolboxPos.func_177956_o(), (double)this.toolboxPos.func_177952_p() + 0.5) > maxRange * maxRange) {
                return;
            }
            if (!(blockEntity instanceof ToolboxTileEntity)) {
                return;
            }
            ToolboxTileEntity toolbox = (ToolboxTileEntity)blockEntity;
            CompoundNBT compound = player.getPersistentData().func_74775_l("CreateToolboxData");
            MutableBoolean sendData = new MutableBoolean(false);
            toolbox.inventory.inLimitedMode(inventory -> {
                for (int i = 0; i < 36; ++i) {
                    ItemStack itemStack;
                    ItemStack remainder;
                    String key = String.valueOf(i);
                    if (compound.func_74764_b(key) && NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l(key).func_74775_l("Pos")).equals((Object)this.toolboxPos)) {
                        ToolboxHandler.unequip((PlayerEntity)player, i, true);
                        sendData.setTrue();
                    }
                    if ((remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)toolbox.inventory, (ItemStack)(itemStack = player.field_71071_by.func_70301_a(i)), (boolean)false)).func_190916_E() == itemStack.func_190916_E()) continue;
                    player.field_71071_by.func_70299_a(i, remainder);
                }
            });
            if (sendData.booleanValue()) {
                ToolboxHandler.syncData((PlayerEntity)player);
            }
        });
        ctx.setPacketHandled(true);
    }
}

