/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.simibubi.create.Create;
import com.simibubi.create.compat.jei.ConversionRecipe;
import com.simibubi.create.content.contraptions.components.crafter.MechanicalCraftingRecipe;
import com.simibubi.create.content.contraptions.components.crusher.CrushingRecipe;
import com.simibubi.create.content.contraptions.components.deployer.DeployerApplicationRecipe;
import com.simibubi.create.content.contraptions.components.fan.SplashingRecipe;
import com.simibubi.create.content.contraptions.components.millstone.MillingRecipe;
import com.simibubi.create.content.contraptions.components.mixer.CompactingRecipe;
import com.simibubi.create.content.contraptions.components.mixer.MixingRecipe;
import com.simibubi.create.content.contraptions.components.press.PressingRecipe;
import com.simibubi.create.content.contraptions.components.saw.CuttingRecipe;
import com.simibubi.create.content.contraptions.fluids.actors.FillingRecipe;
import com.simibubi.create.content.contraptions.itemAssembly.SequencedAssemblyRecipeSerializer;
import com.simibubi.create.content.contraptions.processing.BasinRecipe;
import com.simibubi.create.content.contraptions.processing.EmptyingRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeBuilder;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeSerializer;
import com.simibubi.create.content.curiosities.toolbox.ToolboxDyeingRecipe;
import com.simibubi.create.content.curiosities.tools.SandPaperPolishingRecipe;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.recipe.IRecipeTypeInfo;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;

public enum AllRecipeTypes implements IRecipeTypeInfo
{
    CONVERSION(ConversionRecipe::new),
    CRUSHING(CrushingRecipe::new),
    CUTTING(CuttingRecipe::new),
    MILLING(MillingRecipe::new),
    BASIN(BasinRecipe::new),
    MIXING(MixingRecipe::new),
    COMPACTING(CompactingRecipe::new),
    PRESSING(PressingRecipe::new),
    SANDPAPER_POLISHING(SandPaperPolishingRecipe::new),
    SPLASHING(SplashingRecipe::new),
    DEPLOYING(DeployerApplicationRecipe::new),
    FILLING(FillingRecipe::new),
    EMPTYING(EmptyingRecipe::new),
    MECHANICAL_CRAFTING(MechanicalCraftingRecipe.Serializer::new),
    SEQUENCED_ASSEMBLY(SequencedAssemblyRecipeSerializer::new),
    TOOLBOX_DYEING(() -> new SpecialRecipeSerializer(ToolboxDyeingRecipe::new), IRecipeType.field_222149_a);

    private ResourceLocation id = Create.asResource(Lang.asId(this.name()));
    private Supplier<IRecipeSerializer<?>> serializerSupplier;
    private Supplier<IRecipeType<?>> typeSupplier;
    private IRecipeSerializer<?> serializer;
    private IRecipeType<?> type;

    private AllRecipeTypes(Supplier<IRecipeSerializer<?>> serializerSupplier, Supplier<IRecipeType<?>> typeSupplier) {
        this.serializerSupplier = serializerSupplier;
        this.typeSupplier = typeSupplier;
    }

    private AllRecipeTypes(Supplier<IRecipeSerializer<?>> serializerSupplier, IRecipeType<?> existingType) {
        this(serializerSupplier, () -> existingType);
    }

    private AllRecipeTypes(Supplier<IRecipeSerializer<?>> serializerSupplier) {
        this.serializerSupplier = serializerSupplier;
        this.typeSupplier = () -> AllRecipeTypes.simpleType(this.id);
    }

    private AllRecipeTypes(ProcessingRecipeBuilder.ProcessingRecipeFactory<?> processingFactory) {
        this(AllRecipeTypes.processingSerializer(processingFactory));
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public <T extends IRecipeSerializer<?>> T getSerializer() {
        return (T)this.serializer;
    }

    @Override
    public <T extends IRecipeType<?>> T getType() {
        return (T)this.type;
    }

    public <C extends IInventory, T extends IRecipe<C>> Optional<T> find(C inv, World world) {
        return world.func_199532_z().func_215371_a(this.getType(), inv, world);
    }

    public static void register(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        ShapedRecipe.setCraftingSize((int)9, (int)9);
        for (AllRecipeTypes r : AllRecipeTypes.values()) {
            r.serializer = r.serializerSupplier.get();
            r.type = r.typeSupplier.get();
            r.serializer.setRegistryName(r.id);
            event.getRegistry().register(r.serializer);
        }
    }

    private static Supplier<IRecipeSerializer<?>> processingSerializer(ProcessingRecipeBuilder.ProcessingRecipeFactory<?> factory) {
        return () -> new ProcessingRecipeSerializer(factory);
    }

    public static <T extends IRecipe<?>> IRecipeType<T> simpleType(ResourceLocation id) {
        final String stringId = id.toString();
        return (IRecipeType)Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)id, (Object)new IRecipeType<T>(){

            public String toString() {
                return stringId;
            }
        });
    }

    public static boolean isManualRecipe(IRecipe<?> recipe) {
        return recipe.func_199560_c().func_110623_a().endsWith("_manual_only");
    }
}

