/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt.network;

import dev.gigaherz.toolbelt.BeltFinder;
import dev.gigaherz.toolbelt.ConfigData;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class SwapItems {
    public int swapWith;

    public SwapItems(int windowId) {
        this.swapWith = windowId;
    }

    public SwapItems(PacketBuffer buf) {
        this.swapWith = buf.readInt();
    }

    public void encode(PacketBuffer buf) {
        buf.writeInt(this.swapWith);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> SwapItems.swapItem(this.swapWith, (PlayerEntity)((NetworkEvent.Context)context.get()).getSender()));
        return true;
    }

    public static void swapItem(int swapWith, PlayerEntity player) {
        BeltFinder.findBelt(player).ifPresent(getter -> {
            ItemStack stack = getter.getBelt();
            if (stack.func_190916_E() <= 0) {
                return;
            }
            ItemStack inHand = player.func_184614_ca();
            if (!ConfigData.isItemStackAllowed(inHand)) {
                return;
            }
            IItemHandlerModifiable cap = (IItemHandlerModifiable)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElseThrow(() -> new RuntimeException("No inventory!"));
            if (swapWith < 0) {
                player.func_184611_a(Hand.MAIN_HAND, ItemHandlerHelper.insertItem((IItemHandler)cap, (ItemStack)inHand, (boolean)false));
            } else {
                ItemStack inSlot = cap.getStackInSlot(swapWith);
                player.func_184611_a(Hand.MAIN_HAND, inSlot);
                cap.setStackInSlot(swapWith, inHand);
            }
            getter.syncToClients();
        });
    }
}

