/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt.belt;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.gigaherz.toolbelt.ToolBelt;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class BeltIngredient
extends Ingredient {
    public static final ResourceLocation NAME = ToolBelt.location("belt_upgrade_level");
    private final int level;

    public static BeltIngredient withLevel(int level) {
        return new BeltIngredient(level);
    }

    protected BeltIngredient(int level) {
        super(Stream.of(new Ingredient.SingleItemList(ToolBelt.BELT.of(level))));
        this.level = level;
    }

    public boolean test(@Nullable ItemStack stack) {
        return stack != null && stack.func_77973_b() == ToolBelt.BELT && ToolBelt.BELT.getLevel(stack) == this.level;
    }

    public JsonElement func_200304_c() {
        JsonObject object = new JsonObject();
        object.addProperty("type", NAME.toString());
        object.addProperty("upgrade_level", (Number)this.level);
        return object;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements IIngredientSerializer<BeltIngredient> {
        public static final IIngredientSerializer<? extends Ingredient> INSTANCE = new Serializer();

        public BeltIngredient parse(PacketBuffer buffer) {
            return new BeltIngredient(buffer.func_150792_a());
        }

        public void write(PacketBuffer buffer, BeltIngredient ingredient) {
            buffer.func_150787_b(ingredient.level);
        }

        public BeltIngredient parse(JsonObject json) {
            return new BeltIngredient(JSONUtils.func_151203_m((JsonObject)json, (String)"upgrade_level"));
        }
    }
}

