/*
 * Decompiled with CFR 0.152.
 */
package squeek.wailaharvestability.helpers;

import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ToolItem;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolType;

public class ToolHelper {
    public static Set<ToolType> getToolTypesOf(@Nonnull ItemStack tool) {
        return tool.func_77973_b().getToolTypes(tool);
    }

    public static boolean isToolOfClass(@Nonnull ItemStack tool, ToolType toolType) {
        return ToolHelper.getToolTypesOf(tool).contains(toolType);
    }

    public static boolean toolHasAnyToolClass(@Nonnull ItemStack tool) {
        return !ToolHelper.getToolTypesOf(tool).isEmpty();
    }

    public static boolean isToolEffectiveAgainst(@Nonnull ItemStack tool, IWorldReader worldReader, BlockPos blockPos, ToolType effectiveToolType) {
        return ForgeHooks.isToolEffective((IWorldReader)worldReader, (BlockPos)blockPos, (ItemStack)tool) || (ToolHelper.toolHasAnyToolClass(tool) ? ToolHelper.isToolOfClass(tool, effectiveToolType) : tool.func_77973_b().func_150893_a(tool, worldReader.func_180495_p(blockPos)) > 1.5f);
    }

    public static boolean canToolHarvestLevel(@Nonnull ItemStack tool, IWorldReader worldReader, BlockPos blockPos, PlayerEntity player, int harvestLevel) {
        BlockState state = worldReader.func_180495_p(blockPos);
        ToolType harvestTool = state.func_177230_c().getHarvestTool(state);
        return !tool.func_190926_b() && harvestTool != null && tool.func_77973_b().getHarvestLevel(tool, harvestTool, player, state) >= harvestLevel;
    }

    public static boolean canToolHarvestBlock(@Nonnull ItemStack tool, BlockState blockState) {
        return !blockState.func_235783_q_() || tool.func_150998_b(blockState);
    }

    public static int getToolHarvestLevel(ToolItem tool, @Nonnull ItemStack toolStack) {
        Set<ToolType> toolClasses = ToolHelper.getToolTypesOf(toolStack);
        if (toolClasses.isEmpty()) {
            return 0;
        }
        ToolType toolClass = toolClasses.iterator().next();
        return tool.getHarvestLevel(toolStack, toolClass, null, null);
    }
}

