/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IForgeShearable;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGSoundEvents;

public class MogEntity
extends AnimalEntity
implements IForgeShearable {
    private static final DataParameter<Boolean> HAS_MOSS = EntityDataManager.func_187226_a(MogEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int timeWithoutMoss;

    public MogEntity(EntityType<? extends AnimalEntity> entityType, World world) {
        super(entityType, world);
        this.field_70138_W = 1.0f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new PanicGoal((CreatureEntity)this, 1.5));
        this.field_70714_bg.func_75776_a(1, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new TemptGoal((CreatureEntity)this, 1.1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)UGItems.DEPTHROCK_PEBBLE.get()}), false));
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(4, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return AnimalEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.1).func_233815_a_(Attributes.field_233820_c_, 0.9);
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)UGSoundEvents.MOG_AMBIENT.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return (SoundEvent)UGSoundEvents.MOG_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)UGSoundEvents.MOG_DEATH.get();
    }

    public boolean func_70648_aU() {
        return true;
    }

    public static boolean canMogSpawn(EntityType<? extends AnimalEntity> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_203425_a((Block)UGBlocks.DEEPTURF_BLOCK.get());
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity parent) {
        return (AgeableEntity)((EntityType)UGEntityTypes.MOG.get()).func_200721_a((World)world);
    }

    public boolean func_70877_b(ItemStack stack) {
        return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)UGItems.DEPTHROCK_PEBBLE.get()}).test(stack);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.timeWithoutMoss = !this.hasMoss() ? ++this.timeWithoutMoss : 0;
        if (this.timeWithoutMoss == 6000) {
            this.setMoss(true);
        }
    }

    public boolean hasMoss() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_MOSS);
    }

    public void setMoss(boolean hasMoss) {
        this.field_70180_af.func_187227_b(HAS_MOSS, (Object)hasMoss);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 0.2f;
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74757_a("HasMoss", this.hasMoss());
        this.timeWithoutMoss = nbt.func_74762_e("TimeWithoutMoss");
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.setMoss(nbt.func_74767_n("HasMoss"));
        nbt.func_74768_a("TimeWithoutMoss", this.timeWithoutMoss);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAS_MOSS, (Object)true);
    }

    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData data, @Nullable CompoundNBT nbt) {
        this.setMoss(true);
        return super.func_213386_a(world, difficulty, reason, data, nbt);
    }

    public boolean isShearable(@Nonnull ItemStack item, World world, BlockPos pos) {
        return this.hasMoss() && this.func_70089_S() && !this.func_70631_g_();
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nullable PlayerEntity player, @Nonnull ItemStack item, World world, BlockPos pos, int fortune) {
        world.func_217384_a(null, (Entity)this, SoundEvents.field_187763_eJ, player == null ? SoundCategory.BLOCKS : SoundCategory.PLAYERS, 1.0f, 1.0f);
        if (!world.field_72995_K) {
            this.setMoss(false);
            int mossAmount = 1 + this.field_70146_Z.nextInt(2);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (int i = 0; i < mossAmount; ++i) {
                items.add(new ItemStack((IItemProvider)UGItems.MOGMOSS.get()));
            }
            return items;
        }
        return Collections.emptyList();
    }
}

